/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.crafting.centrifuge;

import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.gui.client.machine.GuiCentrifuge;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.crafting.BaseRecipeCategory;
import cofh.thermalexpansion.plugins.jei.crafting.centrifuge.CentrifugeRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.CentrifugeManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CentrifugeRecipeCategory
extends BaseRecipeCategory<CentrifugeRecipeWrapper> {
    public static boolean enable = true;
    IDrawableStatic tank;
    IDrawableStatic tankOverlay;

    public static void register(IRecipeCategoryRegistration registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new CentrifugeRecipeCategory(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipes(CentrifugeRecipeCategory.getRecipes(guiHelper), "thermalexpansion.centrifuge");
        registry.addRecipeClickArea(GuiCentrifuge.class, 72, 34, 24, 16, new String[]{"thermalexpansion.centrifuge"});
        registry.addRecipeCatalyst((Object)BlockMachine.machineCentrifuge, new String[]{"thermalexpansion.centrifuge"});
    }

    public static List<CentrifugeRecipeWrapper> getRecipes(IGuiHelper guiHelper) {
        ArrayList<CentrifugeRecipeWrapper> recipes = new ArrayList<CentrifugeRecipeWrapper>();
        for (CentrifugeManager.CentrifugeRecipe recipe : CentrifugeManager.getRecipeList()) {
            recipes.add(new CentrifugeRecipeWrapper(guiHelper, recipe));
        }
        return recipes;
    }

    public CentrifugeRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiCentrifuge.TEXTURE, 26, 11, 124, 62, 0, 0, 16, 24);
        this.tank = Drawables.getDrawables(guiHelper).getTank(0);
        this.tankOverlay = Drawables.getDrawables(guiHelper).getTankSmallOverlay(0);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.machine.centrifuge.name");
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.centrifuge";
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.tank.draw(minecraft, 140, 0);
        this.energyMeter.draw(minecraft, 2, 8);
    }

    public void setRecipe(IRecipeLayout recipeLayout, CentrifugeRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        List outputFluids = ingredients.getOutputs(FluidStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, true, 33, 14);
        guiItemStacks.init(1, false, 96, 14);
        guiItemStacks.init(2, false, 114, 14);
        guiItemStacks.init(3, false, 96, 32);
        guiItemStacks.init(4, false, 114, 32);
        guiFluidStacks.init(0, false, 141, 1, 16, 60, 2000, false, (IDrawable)this.tankOverlay);
        guiItemStacks.set(0, (List)inputs.get(0));
        for (int i = 0; i < outputs.size(); ++i) {
            guiItemStacks.set(i + 1, (List)outputs.get(i));
        }
        guiFluidStacks.set(0, (List)outputFluids.get(0));
        guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (!centrifugeRecipeWrapper.chance.isEmpty() && slotIndex >= 1 && slotIndex <= 4 && centrifugeRecipeWrapper.chance.get(slotIndex - 1) < 100) {
                tooltip.add(StringHelper.localize((String)"info.cofh.chance") + ": " + centrifugeRecipeWrapper.chance.get(slotIndex - 1) + "%");
            }
        });
    }
}

