/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.item;

import cofh.api.core.ISecurable;
import cofh.api.item.IUpgradeItem;
import cofh.core.item.ItemMulti;
import cofh.core.render.IModelRegister;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.tileentity.IUpgradeable;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemUpgrade
extends ItemMulti
implements IInitializer,
IUpgradeItem {
    private TIntObjectHashMap<UpgradeEntry> upgradeMap = new TIntObjectHashMap();
    public static ItemStack[] upgradeIncremental;
    public static ItemStack[] upgradeFull;
    public static ItemStack upgradeCreative;

    public ItemUpgrade() {
        super("thermalexpansion");
        this.func_77655_b("upgrade");
        this.func_77637_a(ThermalExpansion.tabItems);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        IUpgradeItem.UpgradeType type = this.getUpgradeType(stack);
        switch (type) {
            case INCREMENTAL: {
                tooltip.add(StringHelper.getInfoText((String)"info.thermalexpansion.upgrade.incremental.0"));
                tooltip.add(StringHelper.getNoticeText((String)"info.thermalexpansion.upgrade.incremental.1"));
                break;
            }
            case FULL: {
                tooltip.add(StringHelper.getInfoText((String)"info.thermalexpansion.upgrade.full.0"));
                tooltip.add(StringHelper.getNoticeText((String)"info.thermalexpansion.upgrade.full.1"));
                break;
            }
            case CREATIVE: {
                tooltip.add(StringHelper.getInfoText((String)"info.thermalexpansion.upgrade.creative.0"));
                tooltip.add(StringHelper.getNoticeText((String)"info.thermalexpansion.upgrade.creative.1"));
                break;
            }
        }
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean func_77662_d() {
        return true;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!block.hasTileEntity(state)) {
            return EnumActionResult.PASS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ISecurable && !((ISecurable)tile).canPlayerAccess(player)) {
            return EnumActionResult.PASS;
        }
        if (tile instanceof IUpgradeable) {
            if (!((IUpgradeable)tile).canUpgrade(stack)) {
                return EnumActionResult.PASS;
            }
            if (ServerHelper.isServerWorld((World)world)) {
                if (((IUpgradeable)tile).installUpgrade(stack)) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.thermalexpansion.upgrade.install.success", new Object[0]));
                } else {
                    ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.thermalexpansion.upgrade.install.failure", new Object[0]));
                }
                return EnumActionResult.SUCCESS;
            }
            if (((IUpgradeable)tile).installUpgrade(stack)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                ServerHelper.sendItemUsePacket((World)world, (BlockPos)pos, (EnumFacing)side, (EnumHand)hand, (float)hitX, (float)hitY, (float)hitZ);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public IUpgradeItem.UpgradeType getUpgradeType(ItemStack stack) {
        return ((UpgradeEntry)this.upgradeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).type;
    }

    public int getUpgradeLevel(ItemStack stack) {
        return ((UpgradeEntry)this.upgradeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).level;
    }

    public boolean preInit() {
        int level;
        int i;
        upgradeIncremental = new ItemStack[4];
        for (i = 0; i < 4; ++i) {
            level = i + 1;
            ItemUpgrade.upgradeIncremental[i] = this.addItem(i, "incremental" + level, EnumRarity.values()[level / 2]);
            this.addUpgradeEntry(i, IUpgradeItem.UpgradeType.INCREMENTAL, level);
        }
        upgradeFull = new ItemStack[4];
        for (i = 1; i < 4; ++i) {
            level = i + 1;
            ItemUpgrade.upgradeFull[i] = this.addItem(32 + i, "full" + level, EnumRarity.values()[level / 2]);
            this.addUpgradeEntry(32 + i, IUpgradeItem.UpgradeType.FULL, level);
        }
        upgradeCreative = this.addItem(256, "creative", EnumRarity.EPIC);
        this.addUpgradeEntry(256, IUpgradeItem.UpgradeType.CREATIVE, 127);
        ThermalExpansion.proxy.addIModelRegister((IModelRegister)this);
        return true;
    }

    public boolean initialize() {
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)upgradeIncremental[0], (Object[])new Object[]{" I ", "IGI", "DID", Character.valueOf('D'), "dustRedstone", Character.valueOf('G'), "gearBronze", Character.valueOf('I'), "ingotInvar"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)upgradeIncremental[1], (Object[])new Object[]{" I ", "IGI", "DID", Character.valueOf('D'), "blockGlassHardened", Character.valueOf('G'), "gearSilver", Character.valueOf('I'), "ingotElectrum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)upgradeIncremental[2], (Object[])new Object[]{" I ", "IGI", "DID", Character.valueOf('D'), "dustCryotheum", Character.valueOf('G'), "gearElectrum", Character.valueOf('I'), "ingotSignalum"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)upgradeIncremental[3], (Object[])new Object[]{" I ", "IGI", "DID", Character.valueOf('D'), "dustPyrotheum", Character.valueOf('G'), "gearLumium", Character.valueOf('I'), "ingotEnderium"}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)upgradeFull[1], (Object[])new Object[]{upgradeIncremental[0], upgradeIncremental[1]}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)upgradeFull[2], (Object[])new Object[]{upgradeFull[1], upgradeIncremental[2]}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)upgradeFull[2], (Object[])new Object[]{upgradeIncremental[0], upgradeIncremental[1], upgradeIncremental[2]}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)upgradeFull[3], (Object[])new Object[]{upgradeFull[2], upgradeIncremental[3]}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)upgradeFull[3], (Object[])new Object[]{upgradeFull[1], upgradeIncremental[2], upgradeIncremental[3]}));
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapelessRecipe((ItemStack)upgradeFull[3], (Object[])new Object[]{upgradeIncremental[0], upgradeIncremental[1], upgradeIncremental[2], upgradeIncremental[3]}));
        return true;
    }

    public boolean postInit() {
        return true;
    }

    private void addUpgradeEntry(int metadata, IUpgradeItem.UpgradeType type, int level) {
        this.upgradeMap.put(metadata, (Object)new UpgradeEntry(type, level));
    }

    public class UpgradeEntry {
        public final IUpgradeItem.UpgradeType type;
        public final int level;

        UpgradeEntry(IUpgradeItem.UpgradeType type, int level) {
            this.type = type;
            this.level = level;
        }
    }
}

