/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.container.storage;

import cofh.api.core.ISecurable;
import cofh.core.util.CoreUtils;
import cofh.core.util.helpers.SecurityHelper;
import cofh.lib.gui.container.ContainerInventoryItem;
import cofh.lib.gui.slot.ISlotValidator;
import cofh.lib.gui.slot.SlotLocked;
import cofh.lib.gui.slot.SlotValidated;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.gui.slot.SlotSatchelCreative;
import cofh.thermalexpansion.item.ItemSatchel;
import cofh.thermalexpansion.network.PacketTEBase;
import com.mojang.authlib.GameProfile;
import gnu.trove.map.hash.THashMap;
import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;

@ChestContainer
public class ContainerSatchel
extends ContainerInventoryItem
implements ISecurable,
ISlotValidator {
    static final String NAME = "item.thermalexpansion.satchel.name";
    int storageIndex;
    int rowSize;

    public ContainerSatchel(ItemStack stack, InventoryPlayer inventory) {
        super(stack, inventory);
        this.storageIndex = ItemSatchel.getStorageIndex(stack);
        this.rowSize = MathHelper.clamp((int)this.storageIndex, (int)9, (int)14);
        int rows = MathHelper.clamp((int)this.storageIndex, (int)2, (int)9);
        int slots = this.rowSize * rows;
        int yOffset = 17;
        this.addPlayerSlotsToContainer(inventory, 8 + 9 * (this.rowSize - 9), rows);
        if (this.storageIndex == 0) {
            this.func_75146_a(new SlotSatchelCreative(this, (IInventory)this.containerWrapper, 0, 80, 26));
            this.rowSize = 1;
        } else if (this.storageIndex == 1) {
            yOffset += 9;
            for (int i = 0; i < 9; ++i) {
                this.func_75146_a((Slot)new SlotValidated((ISlotValidator)this, (IInventory)this.containerWrapper, i, 8 + i % this.rowSize * 18, yOffset + i / this.rowSize * 18));
            }
        } else {
            for (int i = 0; i < slots; ++i) {
                this.func_75146_a((Slot)new SlotValidated((ISlotValidator)this, (IInventory)this.containerWrapper, i, 8 + i % this.rowSize * 18, yOffset + i / this.rowSize * 18));
            }
        }
    }

    public String getInventoryName() {
        return this.containerWrapper.func_145818_k_() ? this.containerWrapper.func_70005_c_() : StringHelper.localize((String)NAME);
    }

    protected int getPlayerInventoryVerticalOffset() {
        return 84;
    }

    private void addPlayerSlotsToContainer(InventoryPlayer inventory, int invOffset, int rows) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventory, j + i * 9 + 9, invOffset + j * 18, 30 + 18 * rows + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (i == inventory.field_70461_c) {
                this.func_75146_a((Slot)new SlotLocked((IInventory)inventory, i, invOffset + i * 18, 88 + 18 * rows));
                continue;
            }
            this.func_75146_a(new Slot((IInventory)inventory, i, invOffset + i * 18, 88 + 18 * rows));
        }
    }

    @Optional.Method(modid="inventorytweaks")
    @ChestContainer.RowSizeCallback
    public int getRowSize() {
        return this.rowSize;
    }

    @ContainerSectionCallback
    @Optional.Method(modid="inventorytweaks")
    public Map<ContainerSection, List<Slot>> getContainerSections() {
        THashMap slotRefs = new THashMap();
        slotRefs.put(ContainerSection.INVENTORY, this.field_75151_b.subList(0, 36));
        slotRefs.put(ContainerSection.INVENTORY_NOT_HOTBAR, this.field_75151_b.subList(0, 27));
        slotRefs.put(ContainerSection.INVENTORY_HOTBAR, this.field_75151_b.subList(27, 36));
        slotRefs.put(ContainerSection.CHEST, this.field_75151_b.subList(36, this.field_75151_b.size()));
        return slotRefs;
    }

    public boolean setAccess(ISecurable.AccessMode access) {
        if (SecurityHelper.setAccess((ItemStack)this.getContainerStack(), (ISecurable.AccessMode)access)) {
            this.onSlotChanged();
            if (CoreUtils.isClient()) {
                PacketTEBase.sendSecurityPacketToServer(this);
            }
            return true;
        }
        return false;
    }

    public ISecurable.AccessMode getAccess() {
        return SecurityHelper.getAccess((ItemStack)this.getContainerStack());
    }

    public String getOwnerName() {
        return SecurityHelper.getOwnerName((ItemStack)this.getContainerStack());
    }

    public GameProfile getOwner() {
        return SecurityHelper.getOwner((ItemStack)this.getContainerStack());
    }

    public boolean canPlayerAccess(EntityPlayer player) {
        throw new UnsupportedOperationException();
    }

    public boolean setOwnerName(String name) {
        throw new UnsupportedOperationException();
    }

    public boolean setOwner(GameProfile name) {
        throw new UnsupportedOperationException();
    }

    public boolean isItemValid(ItemStack stack) {
        return this.containerWrapper.func_94041_b(0, stack);
    }
}

