/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.helpers.AugmentHelper;
import cofh.lib.gui.container.ICustomInventory;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiPrecipitator;
import cofh.thermalexpansion.gui.container.machine.ContainerPrecipitator;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TilePrecipitator
extends TileMachineBase
implements ICustomInventory {
    private static final int TYPE = BlockMachine.Type.PRECIPITATOR.getMetadata();
    public static int basePower = 20;
    public static ItemStack SNOW_LAYER;
    public static ItemStack PACKED_ICE;
    private static int[] processWater;
    private static int[] processEnergy;
    private static ItemStack[] processItems;
    private int outputTracker;
    private byte curSelection;
    private byte prevSelection;
    private ItemStack[] outputItems = new ItemStack[3];
    private FluidTankCore tank = new FluidTankCore(8000);
    protected boolean augmentSnowLayer;
    protected boolean augmentPackedIce;

    public static void initialize() {
        processItems = new ItemStack[3];
        TilePrecipitator.processItems[0] = new ItemStack(Items.field_151126_ay, 4, 0);
        TilePrecipitator.processItems[1] = new ItemStack(Blocks.field_150433_aE);
        TilePrecipitator.processItems[2] = new ItemStack(Blocks.field_150432_aD);
        SNOW_LAYER = new ItemStack(Blocks.field_150431_aC, 2, 0);
        PACKED_ICE = new ItemStack(Blocks.field_150403_cj);
        TilePrecipitator.SIDE_CONFIGS[TilePrecipitator.TYPE] = new TileTEBase.SideConfig();
        TilePrecipitator.SIDE_CONFIGS[TilePrecipitator.TYPE].numConfig = 5;
        TilePrecipitator.SIDE_CONFIGS[TilePrecipitator.TYPE].slotGroups = new int[][]{new int[0], new int[0], {0}, {0}, {0}};
        TilePrecipitator.SIDE_CONFIGS[TilePrecipitator.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TilePrecipitator.SIDE_CONFIGS[TilePrecipitator.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TilePrecipitator.SLOT_CONFIGS[TilePrecipitator.TYPE] = new TileTEBase.SlotConfig();
        TilePrecipitator.SLOT_CONFIGS[TilePrecipitator.TYPE].allowInsertionSlot = new boolean[]{false, false};
        TilePrecipitator.SLOT_CONFIGS[TilePrecipitator.TYPE].allowExtractionSlot = new boolean[]{true, false};
        TilePrecipitator.VALID_AUGMENTS[TilePrecipitator.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machinePrecipitatorPackedIce");
        GameRegistry.registerTileEntity(TilePrecipitator.class, (String)"thermalexpansion:machine_precipitator");
        TilePrecipitator.config();
    }

    public static void config() {
        String category = "Machine.Precipitator";
        BlockMachine.enable[TilePrecipitator.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        TilePrecipitator.ENERGY_CONFIGS[TilePrecipitator.TYPE] = new TileTEBase.EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower);
    }

    public TilePrecipitator() {
        this.inventory = new ItemStack[2];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        for (int i = 0; i < 3; ++i) {
            this.outputItems[i] = processItems[i].func_77946_l();
        }
        this.tank.setLock(FluidRegistry.WATER);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected int getMaxInputSlot() {
        return -1;
    }

    @Override
    protected boolean canStart() {
        if (this.tank.getFluidAmount() < processWater[this.curSelection] || this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        if (this.inventory[0].func_190926_b()) {
            return true;
        }
        if (!this.inventory[0].func_77969_a(this.outputItems[this.curSelection])) {
            return false;
        }
        return this.inventory[0].func_190916_E() + this.outputItems[this.curSelection].func_190916_E() <= this.outputItems[this.prevSelection].func_77976_d();
    }

    @Override
    protected boolean canFinish() {
        return this.processRem <= 0;
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = processEnergy[this.curSelection] * this.energyMod / 100;
        this.prevSelection = this.curSelection;
    }

    @Override
    protected void processFinish() {
        if (this.inventory[0].func_190926_b()) {
            this.inventory[0] = this.outputItems[this.prevSelection].func_77946_l();
        } else {
            this.inventory[0].func_190917_f(this.outputItems[this.prevSelection].func_190916_E());
        }
        this.tank.drain(processWater[this.prevSelection], true);
        this.prevSelection = this.curSelection;
    }

    @Override
    protected void transferOutput() {
        if (!this.enableAutoOutput) {
            return;
        }
        if (this.inventory[0].func_190926_b()) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!this.isPrimaryOutput(this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.outputTracker = side;
            break;
        }
    }

    @Override
    protected boolean readPortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        if (!super.readPortableTagInternal(player, tag)) {
            return false;
        }
        if (tag.func_74764_b("Sel")) {
            this.curSelection = tag.func_74771_c("Sel");
            if (!this.isActive) {
                this.prevSelection = this.curSelection;
            }
        }
        return true;
    }

    @Override
    protected boolean writePortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        if (!super.writePortableTagInternal(player, tag)) {
            return false;
        }
        tag.func_74774_a("Sel", this.curSelection);
        return true;
    }

    @Override
    protected void setLevelFlags() {
        super.setLevelFlags();
        this.hasAutoInput = false;
        this.enableAutoInput = false;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiPrecipitator(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerPrecipitator(inventory, (TileEntity)this);
    }

    public int getCurSelection() {
        return this.curSelection;
    }

    public int getPrevSelection() {
        return this.prevSelection;
    }

    @Override
    public FluidTankCore getTank() {
        return this.tank;
    }

    @Override
    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public void setMode(int selection) {
        byte lastSelection = this.curSelection;
        this.curSelection = (byte)selection;
        this.sendModePacket();
        this.curSelection = lastSelection;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.prevSelection = nbt.func_74771_c("Prev");
        this.curSelection = nbt.func_74771_c("Sel");
        this.tank.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        nbt.func_74774_a("Prev", this.prevSelection);
        nbt.func_74774_a("Sel", this.curSelection);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    public PacketCoFHBase getModePacket() {
        PacketCoFHBase payload = super.getModePacket();
        payload.addByte(this.curSelection);
        return payload;
    }

    protected void handleModePacket(PacketCoFHBase payload) {
        super.handleModePacket(payload);
        this.curSelection = payload.getByte();
        if (!this.isActive) {
            this.prevSelection = this.curSelection;
        }
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase payload = super.getGuiPacket();
        payload.addByte(this.curSelection);
        payload.addByte(this.prevSelection);
        payload.addInt(this.tank.getFluidAmount());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase payload) {
        super.handleGuiPacket(payload);
        this.curSelection = payload.getByte();
        this.prevSelection = payload.getByte();
        this.tank.getFluid().amount = payload.getInt();
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.outputItems[1] = processItems[1].func_77946_l();
        this.outputItems[2] = processItems[2].func_77946_l();
        this.augmentSnowLayer = false;
        this.augmentPackedIce = false;
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentSnowLayer && "machinePrecipitatorSnowLayer".equals(id)) {
            this.outputItems[1] = SNOW_LAYER.func_77946_l();
            this.hasModeAugment = true;
            return true;
        }
        if (!this.augmentPackedIce && "machinePrecipitatorPackedIce".equals(id)) {
            this.outputItems[2] = PACKED_ICE.func_77946_l();
            this.hasModeAugment = true;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    public ItemStack[] getInventorySlots(int inventoryIndex) {
        return this.outputItems;
    }

    public int getSlotStackLimit(int slotIndex) {
        return 64;
    }

    public void onSlotUpdate() {
        this.markChunkDirty();
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TilePrecipitator.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, false)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from != null && !TilePrecipitator.this.allowInsertion(((TilePrecipitator)TilePrecipitator.this).sideConfig.sideTypes[TilePrecipitator.this.sideCache[from.ordinal()]])) {
                        return 0;
                    }
                    if (resource.getFluid() != FluidRegistry.WATER) {
                        return 0;
                    }
                    return TilePrecipitator.this.tank.fill(resource, doFill);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    return null;
                }
            });
        }
        return super.getCapability(capability, from);
    }

    static {
        processWater = new int[]{500, 500, 1000};
        processEnergy = new int[]{800, 800, 1600};
    }
}

