/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.core.init.CoreProps;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.RenderHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.gui.client.device.GuiNullifier;
import cofh.thermalexpansion.gui.container.device.ContainerNullifier;
import cofh.thermalexpansion.init.TETextures;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileNullifier
extends TileDeviceBase {
    private static final int TYPE = BlockDevice.Type.NULLIFIER.getMetadata();
    private static final int[] SLOTS = new int[]{0};

    public static void initialize() {
        TileNullifier.SIDE_CONFIGS[TileNullifier.TYPE] = new TileTEBase.SideConfig();
        TileNullifier.SIDE_CONFIGS[TileNullifier.TYPE].numConfig = 2;
        TileNullifier.SIDE_CONFIGS[TileNullifier.TYPE].slotGroups = new int[][]{new int[0], {0}, new int[0]};
        TileNullifier.SIDE_CONFIGS[TileNullifier.TYPE].sideTypes = new int[]{0, 1, 4};
        TileNullifier.SIDE_CONFIGS[TileNullifier.TYPE].defaultSides = new byte[]{0, 1, 1, 1, 1, 1};
        TileNullifier.SLOT_CONFIGS[TileNullifier.TYPE] = new TileTEBase.SlotConfig();
        TileNullifier.SLOT_CONFIGS[TileNullifier.TYPE].allowInsertionSlot = new boolean[]{true};
        TileNullifier.SLOT_CONFIGS[TileNullifier.TYPE].allowExtractionSlot = new boolean[]{false};
        GameRegistry.registerTileEntity(TileNullifier.class, (String)"thermalexpansion:device_nullifier");
        TileNullifier.config();
    }

    public static void config() {
        String category = "Device.Nullifier";
        BlockDevice.enable[TileNullifier.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
    }

    public TileNullifier() {
        this.inventory = new ItemStack[1];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
    }

    public int getType() {
        return TYPE;
    }

    public int getLightValue() {
        return this.redstoneControlOrDisable() ? FluidHelper.getFluidLuminosity((Fluid)FluidRegistry.LAVA) : 0;
    }

    @Override
    public boolean sendRedstoneUpdates() {
        return true;
    }

    protected boolean isSideAccessible(EnumFacing side) {
        return side == null || this.allowInsertion(this.sideConfig.sideTypes[this.sideCache[side.ordinal()]]) && this.redstoneControlOrDisable();
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiNullifier(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerNullifier(inventory, (TileEntity)this);
    }

    @Override
    public void readInventoryFromNBT(NBTTagCompound nbt) {
    }

    @Override
    public void writeInventoryToNBT(NBTTagCompound nbt) {
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        if (this.inventory[slot].func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (this.inventory[slot].func_190916_E() <= amount) {
            amount = this.inventory[slot].func_190916_E();
        }
        ItemStack stack = this.inventory[slot].func_77979_a(amount);
        if (this.inventory[slot].func_190916_E() <= 0) {
            this.inventory[slot] = ItemStack.field_190927_a;
        }
        return stack;
    }

    @Override
    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot].func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = this.inventory[slot];
        this.inventory[slot] = ItemStack.field_190927_a;
        return stack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        if (slot == 0) {
            return;
        }
        this.inventory[slot] = stack;
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    @Override
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return TETextures.DEVICE_BOTTOM;
            }
            if (side == 1) {
                return TETextures.DEVICE_TOP;
            }
            return side != this.facing ? TETextures.DEVICE_SIDE : (this.redstoneControlOrDisable() ? RenderHelper.getFluidTexture((Fluid)FluidRegistry.LAVA) : TETextures.DEVICE_FACE[TYPE]);
        }
        if (side < 6) {
            return side != this.facing ? TETextures.CONFIG[this.sideConfig.sideTypes[this.sideCache[side]]] : (this.redstoneControlOrDisable() ? TETextures.DEVICE_ACTIVE[TYPE] : TETextures.DEVICE_FACE[TYPE]);
        }
        return TETextures.DEVICE_SIDE;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return this.isSideAccessible(side) ? SLOTS : CoreProps.EMPTY_INVENTORY;
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.isSideAccessible(side);
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return false;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    return new IFluidTankProperties[]{new FluidTankProperties(null, Integer.MAX_VALUE, true, false)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return TileNullifier.this.isSideAccessible(facing) ? resource.amount : 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    return null;
                }
            });
        }
        return super.getCapability(capability, facing);
    }
}

