/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.apparatus;

import cofh.api.core.IAccelerable;
import cofh.api.item.IAugmentItem;
import cofh.api.tileentity.IInventoryConnection;
import cofh.core.entity.CoFHFakePlayer;
import cofh.core.util.helpers.AugmentHelper;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.InventoryHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TilePowered;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.apparatus.BlockApparatus;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.util.Utils;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;

public abstract class TileApparatusBase
extends TilePowered
implements IAccelerable,
IInventoryConnection,
ITickable {
    public static final TileTEBase.SideConfig[] SIDE_CONFIGS = new TileTEBase.SideConfig[BlockApparatus.Type.values().length];
    public static final TileTEBase.SlotConfig[] SLOT_CONFIGS = new TileTEBase.SlotConfig[BlockApparatus.Type.values().length];
    public static final TileTEBase.EnergyConfig[] ENERGY_CONFIGS = new TileTEBase.EnergyConfig[BlockApparatus.Type.values().length];
    public static final HashSet[] VALID_AUGMENTS = new HashSet[BlockApparatus.Type.values().length];
    public static final int[] LIGHT_VALUES = new int[BlockApparatus.Type.values().length];
    private static boolean enableSecurity = true;
    protected static final HashSet<String> VALID_AUGMENTS_BASE = new HashSet();
    int processMax;
    int processRem;
    boolean wasActive;
    boolean hasModeAugment;
    CoFHFakePlayer fakePlayer;
    LinkedList<ItemStack> stuffedItems = new LinkedList();
    TileTEBase.EnergyConfig energyConfig;
    int depth = 0;
    int radius = 0;

    public static void config() {
        String comment = "Enable this to allow for Apparatus to be securable.";
        enableSecurity = ThermalExpansion.CONFIG.get("Security", "Apparatus.Securable", true, comment);
    }

    public void onLoad() {
        if (ServerHelper.isServerWorld((World)this.field_145850_b)) {
            this.fakePlayer = new CoFHFakePlayer((WorldServer)this.field_145850_b);
        }
    }

    public TileApparatusBase() {
        this.sideConfig = SIDE_CONFIGS[this.getType()];
        this.slotConfig = SLOT_CONFIGS[this.getType()];
        this.enableAutoOutput = true;
        this.setDefaultSides();
    }

    public String getTileName() {
        return "tile.thermalexpansion.apparatus." + BlockApparatus.Type.byMetadata(this.getType()).func_176610_l() + ".name";
    }

    @Override
    public boolean enableSecurity() {
        return enableSecurity;
    }

    @Override
    public boolean sendRedstoneUpdates() {
        return true;
    }

    @Override
    public void setDefaultSides() {
        this.sideCache = this.getDefaultSides();
        this.sideCache[this.facing] = 0;
        this.sideCache[this.facing ^ 1] = 1;
    }

    public void func_73660_a() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 16L == 0L && this.redstoneControlOrDisable()) {
            if (!this.isStuffingEmpty()) {
                this.outputBuffer();
            }
            if (this.isStuffingEmpty()) {
                this.activate();
            }
        }
        this.chargeEnergy();
    }

    protected void activate() {
    }

    protected boolean isStuffingEmpty() {
        return this.stuffedItems.isEmpty();
    }

    protected boolean outputBuffer() {
        if (this.enableAutoOutput) {
            for (int i = 0; i < 6; ++i) {
                EnumFacing side;
                TileEntity curTile;
                if (this.sideCache[i] != 1 || !Utils.isAccessibleOutput(curTile = BlockHelper.getAdjacentTileEntity((TileEntity)this, (EnumFacing)(side = EnumFacing.field_82609_l[i])), side)) continue;
                LinkedList<ItemStack> newStuffed = new LinkedList<ItemStack>();
                for (ItemStack curItem : this.stuffedItems) {
                    curItem = curItem.func_190926_b() ? ItemStack.field_190927_a : InventoryHelper.addToInventory((TileEntity)curTile, (EnumFacing)side, (ItemStack)curItem);
                    if (curItem.func_190926_b()) continue;
                    newStuffed.add(curItem);
                }
                this.stuffedItems = newStuffed;
            }
        }
        return this.isStuffingEmpty();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("StuffedInv", 10);
        this.stuffedItems.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            this.stuffedItems.add(new ItemStack(compound));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagList list = new NBTTagList();
        for (ItemStack item : this.stuffedItems) {
            if (item.func_190926_b()) continue;
            NBTTagCompound compound = new NBTTagCompound();
            item.func_77955_b(compound);
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("StuffedInv", (NBTBase)list);
        return nbt;
    }

    @Override
    protected void preAugmentInstall() {
        this.radius = 0;
        this.depth = 0;
    }

    @Override
    protected void postAugmentInstall() {
    }

    @Override
    protected boolean isValidAugment(IAugmentItem.AugmentType type, String id) {
        if (type == IAugmentItem.AugmentType.CREATIVE && !this.isCreative) {
            return false;
        }
        if (type == IAugmentItem.AugmentType.MODE && this.hasModeAugment) {
            return false;
        }
        return VALID_AUGMENTS_BASE.contains(id) || super.isValidAugment(type, id);
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if ("apparatusDepth".equals(id)) {
            ++this.depth;
            return true;
        }
        if ("apparatusRadius".equals(id)) {
            ++this.radius;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    public int updateAccelerable() {
        return 0;
    }

    public IInventoryConnection.ConnectionType canConnectInventory(EnumFacing from) {
        if (from != null && from.ordinal() != this.facing && this.sideCache[from.ordinal()] == 1) {
            return IInventoryConnection.ConnectionType.FORCE;
        }
        return IInventoryConnection.ConnectionType.DEFAULT;
    }

    @Override
    public boolean allowYAxisFacing() {
        return true;
    }

    @Override
    public boolean setFacing(int side) {
        if (side < 0 || side > 5) {
            return false;
        }
        this.facing = (byte)side;
        this.sideCache[this.facing] = 0;
        this.sideCache[this.facing ^ 1] = 1;
        this.markChunkDirty();
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    public int getNumPasses() {
        return 2;
    }

    @Override
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            return side != this.facing ? TETextures.APPARATUS_SIDE : (this.redstoneControlOrDisable() ? TETextures.APPARATUS_ACTIVE[this.getType()] : TETextures.APPARATUS_FACE[this.getType()]);
        }
        if (side < 6) {
            return TETextures.CONFIG[this.sideConfig.sideTypes[this.sideCache[side]]];
        }
        return TETextures.APPARATUS_SIDE;
    }

    static {
        VALID_AUGMENTS_BASE.add("apparatusDepth");
        VALID_AUGMENTS_BASE.add("apparatusRadius");
    }
}

