/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.render;

import codechicken.lib.model.PerspectiveAwareModelProperties;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.key.IItemStackKeyGenerator;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.TransformUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.tuple.Pair;

public class BakedDuctItemModel
implements IBakedModel {
    public static BakedDuctItemModel INSTANCE = new BakedDuctItemModel();
    private static Cache<String, IBakedModel> modelCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return new ArrayList<BakedQuad>();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return TextureUtils.getMissingSprite();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return DuctOverrideList.INSTANCE;
    }

    private static class WrappedBakedModel
    implements IPerspectiveAwareModel {
        private IBakedModel wrappedModel;
        public PerspectiveAwareModelProperties perspectiveProperties;

        public WrappedBakedModel(IBakedModel model, PerspectiveAwareModelProperties perspectiveProperties) {
            this.wrappedModel = model;
            this.perspectiveProperties = perspectiveProperties;
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return this.wrappedModel.func_188616_a(state, side, rand);
        }

        public boolean func_177555_b() {
            return this.perspectiveProperties.getProperties().isAmbientOcclusion();
        }

        public boolean func_177556_c() {
            return this.perspectiveProperties.getProperties().isGui3d();
        }

        public boolean func_188618_c() {
            return this.perspectiveProperties.getProperties().isBuiltInRenderer();
        }

        public TextureAtlasSprite func_177554_e() {
            return TextureUtils.getMissingSprite();
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, (IModelState)this.perspectiveProperties.getModelState(), (ItemCameraTransforms.TransformType)cameraTransformType);
        }
    }

    private static class DuctOverrideList
    extends ItemOverrideList {
        private static DuctOverrideList INSTANCE = new DuctOverrideList();

        public DuctOverrideList() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            IItemStackKeyGenerator keyGen = ModelBakery.getKeyGenerator((Item)stack.func_77973_b());
            String key = keyGen.generateKey(stack);
            Object wrappedModel = (IBakedModel)modelCache.getIfPresent((Object)key);
            if (wrappedModel == null) {
                IBakedModel bakeryModel = ModelBakery.generateItemModel((ItemStack)stack);
                PerspectiveAwareModelProperties properties = new PerspectiveAwareModelProperties((IModelState)TransformUtils.DEFAULT_BLOCK, true, false);
                wrappedModel = new WrappedBakedModel(bakeryModel, properties);
                modelCache.put((Object)key, wrappedModel);
            }
            return wrappedModel;
        }
    }
}

