/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.item;

import cofh.lib.util.helpers.StringHelper;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.attachments.filter.FilterFluid;
import cofh.thermaldynamics.duct.attachments.filter.FilterItem;
import cofh.thermaldynamics.duct.attachments.filter.FilterLogic;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.item.ItemAttachment;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class ItemFilter
extends ItemAttachment {
    public static EnumRarity[] rarity = new EnumRarity[]{EnumRarity.COMMON, EnumRarity.COMMON, EnumRarity.UNCOMMON, EnumRarity.UNCOMMON, EnumRarity.RARE};
    public static ItemStack basicFilter;
    public static ItemStack hardenedFilter;
    public static ItemStack reinforcedFilter;
    public static ItemStack signalumFilter;
    public static ItemStack resonantFilter;

    public ItemFilter() {
        this.func_77655_b("thermaldynamics.filter");
    }

    public String func_77667_c(ItemStack item) {
        return super.func_77667_c(item) + "." + item.func_77952_i();
    }

    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < 5; ++i) {
            list.add((Object)new ItemStack(item, 1, i));
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return rarity[stack.func_77952_i() % 5];
    }

    @Override
    public Attachment getAttachment(EnumFacing side, ItemStack stack, TileGrid tile) {
        int type = stack.func_77952_i() % 5;
        if (tile.getDuct(DuctToken.FLUID) != null) {
            return new FilterFluid(tile, (byte)(side.ordinal() ^ 1), type);
        }
        if (tile.getDuct(DuctToken.ITEMS) != null) {
            return new FilterItem(tile, (byte)(side.ordinal() ^ 1), type);
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean extraInfo) {
        super.func_77624_a(stack, player, list, extraInfo);
        int type = stack.func_77952_i() % 5;
        if (!StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.getInfoText((String)"item.thermaldynamics.filter.info"));
            if (StringHelper.displayShiftForDetail) {
                list.add(StringHelper.shiftForDetails());
            }
            return;
        }
        list.add("\u00a7e" + StringHelper.localize((String)"info.cofh.items") + "\u00a7r");
        ItemFilter.addFiltering(list, type, Duct.Type.ITEM);
        list.add("\u00a7e" + StringHelper.localize((String)"info.cofh.fluids") + "\u00a7r");
        ItemFilter.addFiltering(list, type, Duct.Type.FLUID);
    }

    public static void addFiltering(List<String> list, int type, Duct.Type duct) {
        StringBuilder b = new StringBuilder();
        b.append(StringHelper.localize((String)"info.thermaldynamics.filter.options")).append(": ").append("\u00a7f");
        boolean flag = false;
        for (int i = 0; i < FilterLogic.flagTypes.length; ++i) {
            if (!FilterLogic.canAlterFlag(duct, type, i)) continue;
            if (flag) {
                b.append(", ");
            } else {
                flag = true;
            }
            b.append(StringHelper.localize((String)("info.thermaldynamics.filter." + FilterLogic.flagTypes[i])));
        }
        flag = false;
        for (String s : Minecraft.func_71410_x().field_71466_p.func_78271_c(b.toString(), 140)) {
            if (flag) {
                s = "  \u00a7f" + s;
            }
            flag = true;
            list.add("  " + s + "\u00a7r");
        }
    }

    public boolean preInit() {
        GameRegistry.register((IForgeRegistryEntry)this.setRegistryName("filter"));
        basicFilter = new ItemStack((Item)this, 1, 0);
        hardenedFilter = new ItemStack((Item)this, 1, 1);
        reinforcedFilter = new ItemStack((Item)this, 1, 2);
        signalumFilter = new ItemStack((Item)this, 1, 3);
        resonantFilter = new ItemStack((Item)this, 1, 4);
        ThermalDynamics.proxy.addIModelRegister(this);
        return true;
    }

    @Override
    public boolean initialize() {
        return true;
    }

    @Override
    public void registerModels() {
        String[] names = new String[]{"basic", "hardened", "reinforced", "signalum", "resonant"};
        for (int i = 0; i < names.length; ++i) {
            ModelResourceLocation location = new ModelResourceLocation("thermaldynamics:attachment", "type=" + this.getRegistryName().func_110623_a() + "_" + names[i]);
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)location);
        }
    }
}

