/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.gui.container;

import cofh.lib.util.helpers.ItemHelper;
import cofh.thermaldynamics.duct.attachments.ConnectionBase;
import cofh.thermaldynamics.duct.attachments.filter.FilterLogic;
import cofh.thermaldynamics.gui.container.ContainerAttachmentBase;
import cofh.thermaldynamics.gui.slot.SlotFilter;
import cofh.thermaldynamics.gui.slot.SlotFilterFluid;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerDuctConnection
extends ContainerAttachmentBase {
    private final ConnectionBase tile;
    public final FilterLogic filter;
    public LinkedList<SlotFilter> filterSlots = new LinkedList();
    public final int gridWidth;
    public final int gridHeight;
    public final int gridX0;
    public final int gridY0;

    public ContainerDuctConnection(InventoryPlayer inventory, ConnectionBase tile) {
        super(inventory, tile);
        this.tile = tile;
        this.filter = tile.getFilter();
        assert (this.filter != null);
        int n = this.filter.getFilterStacks().length;
        this.gridWidth = this.filter.filterStackGridWidth();
        this.gridHeight = n / this.gridWidth;
        this.gridX0 = 89 - this.gridWidth * 9;
        switch (this.gridHeight) {
            case 1: {
                this.gridY0 = 38;
                break;
            }
            case 2: {
                this.gridY0 = 29;
                break;
            }
            default: {
                this.gridY0 = 20;
            }
        }
        for (int i = 0; i < this.gridHeight; ++i) {
            for (int j = 0; j < this.gridWidth; ++j) {
                if (this.filter.isItem()) {
                    this.filterSlots.add((SlotFilter)this.func_75146_a((Slot)new SlotFilter(this.filter, j + i * this.gridWidth, this.gridX0 + j * 18, this.gridY0 + i * 18)));
                    continue;
                }
                this.filterSlots.add((SlotFilter)this.func_75146_a((Slot)new SlotFilterFluid(this.filter, j + i * this.gridWidth, this.gridX0 + j * 18, this.gridY0 + i * 18)));
            }
        }
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        int invPlayer = 27;
        int invFull = invPlayer + 9;
        int invTile = invFull + this.filter.getFilterStacks().length;
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            if (slotIndex < 0) {
                return ItemStack.field_190927_a;
            }
            if (slotIndex < invFull) {
                Slot k = null;
                for (int i = invFull; i < invTile; ++i) {
                    Slot slot1 = (Slot)this.field_75151_b.get(i);
                    if (!slot1.func_75216_d()) {
                        if (k != null) continue;
                        k = slot1;
                        continue;
                    }
                    if (!ItemHelper.itemsEqualWithMetadata((ItemStack)slot1.func_75211_c(), (ItemStack)stack)) continue;
                    return ItemStack.field_190927_a;
                }
                if (k != null) {
                    k.func_75215_d(stack.func_77946_l());
                }
                return ItemStack.field_190927_a;
            }
            slot.func_75215_d(ItemStack.field_190927_a);
            slot.func_75218_e();
        }
        return ItemStack.field_190927_a;
    }
}

