/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.item;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class SimulatedInv
implements IItemHandler {
    public static final int REBUILD_THRESHOLD = 128;
    public static SimulatedInv INSTANCE = new SimulatedInv();
    IItemHandler originalLogic;
    IItemHandler slotHandler;
    NonNullList<ItemStack> items;
    int size;

    public SimulatedInv() {
    }

    public SimulatedInv(IInventory target) {
        this.setTarget((IItemHandler)new InvWrapper(target));
    }

    public static SimulatedInv wrapHandler(IItemHandler handler) {
        return INSTANCE.setTarget(handler);
    }

    public static SimulatedInv wrapInv(IInventory inventory) {
        return INSTANCE.setTarget((IItemHandler)new InvWrapper(inventory));
    }

    public void clear() {
        this.originalLogic = null;
    }

    public SimulatedInv setTarget(IItemHandler target) {
        this.originalLogic = target;
        this.size = target.getSlots();
        if (this.items == null || this.items.size() < this.size || this.size < 128 && this.items.size() >= 128) {
            this.items = NonNullList.func_191197_a((int)target.getSlots(), (Object)ItemStack.field_190927_a);
            this.slotHandler = new ItemStackHandler(this.items);
        }
        for (int i = 0; i < this.size; ++i) {
            ItemStack stackInSlot = target.getStackInSlot(i);
            this.items.set(i, (Object)(!stackInSlot.func_190926_b() ? stackInSlot.func_77946_l() : ItemStack.field_190927_a));
        }
        return this;
    }

    public int getSlots() {
        return this.size;
    }

    public ItemStack getStackInSlot(int i) {
        return (ItemStack)this.items.get(i);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.func_190926_b() || stack.func_190916_E() == 0) {
            return ItemStack.field_190927_a;
        }
        int originalStackSize = stack.func_190916_E();
        ItemStack copy = stack.func_77946_l();
        int maxStackSize = copy.func_77976_d();
        copy.func_190920_e(maxStackSize);
        ItemStack insertItem = this.originalLogic.insertItem(slot, copy, true);
        if (insertItem == copy) {
            return stack;
        }
        int insertable = maxStackSize - (!insertItem.func_190926_b() ? insertItem.func_190916_E() : 0);
        if (insertable == 0) {
            return stack;
        }
        if (insertable >= originalStackSize) {
            return this.slotHandler.insertItem(slot, stack, simulate);
        }
        copy.func_190920_e(insertable);
        int remainderStackSize = originalStackSize - insertable;
        ItemStack simInsertStack = this.slotHandler.insertItem(slot, copy, simulate);
        if (simInsertStack.func_190926_b() || simInsertStack.func_190916_E() == 0) {
            copy.func_190920_e(remainderStackSize);
        } else {
            copy.func_190920_e(remainderStackSize + simInsertStack.func_190916_E());
        }
        return copy;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        throw new UnsupportedOperationException();
    }

    public int getSlotLimit(int slot) {
        return this.originalLogic.getSlotLimit(slot);
    }
}

