/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.item;

import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.energy.DuctUnitEnergy;
import cofh.thermaldynamics.duct.energy.GridEnergy;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.GridItem;
import cofh.thermaldynamics.duct.item.TravelingItem;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DuctUnitItemEnder
extends DuctUnitItem {
    final DuctUnitEnergy enderEnergy;
    public boolean powered = false;

    public DuctUnitItemEnder(TileGrid grid, Duct duct, DuctUnitEnergy enderEnergy) {
        super(grid, duct);
        this.enderEnergy = enderEnergy;
    }

    @Override
    public void transferItem(TravelingItem travelingItem) {
        super.transferItem(travelingItem);
    }

    @Override
    public int getDuctLength() {
        return this.isPowered() ? 1 : 60;
    }

    @Override
    public int getPipeHalfLength() {
        return this.isPowered() ? 1 : 30;
    }

    @Override
    public boolean acceptingItems() {
        GridEnergy grid = (GridEnergy)this.enderEnergy.getGrid();
        return grid != null && grid.isPowered();
    }

    @Override
    public void tickItems() {
        if (this.itemsToAdd.size() > 0) {
            for (TravelingItem travelingItem : this.itemsToAdd) {
                this.myItems.add(travelingItem);
            }
            this.itemsToAdd.clear();
            this.hasChanged = true;
        }
        if (this.myItems.size() > 0) {
            for (TravelingItem travelingItem : this.myItems) {
                if (((GridItem)this.grid).repoll) {
                    ((GridItem)this.grid).poll(travelingItem);
                }
                if (travelingItem.reRoute || travelingItem.myPath == null) {
                    travelingItem.bounceItem(this);
                    continue;
                }
                if (this.enderEnergy.getGrid() != null && ((GridEnergy)this.enderEnergy.getGrid()).myStorage.getEnergyStored() >= 50 && ((GridEnergy)this.enderEnergy.getGrid()).myStorage.extractEnergy(50, true) >= 50) {
                    ((GridEnergy)this.enderEnergy.getGrid()).myStorage.extractEnergy(50, false);
                    this.multiAdvance(travelingItem, false);
                    continue;
                }
                travelingItem.tickForward(this);
            }
            if (this.itemsToRemove.size() > 0) {
                this.myItems.removeAll(this.itemsToRemove);
                this.itemsToRemove.clear();
                this.hasChanged = true;
            }
        }
        if (this.hasChanged) {
            ((GridItem)this.grid).shouldRepoll = true;
        }
        this.updateRender();
    }

    @Override
    public void insertNewItem(TravelingItem travelingItem) {
        if (this.enderEnergy.getGrid() != null && ((GridEnergy)this.enderEnergy.getGrid()).myStorage.getEnergyStored() >= 50 && ((GridEnergy)this.enderEnergy.getGrid()).myStorage.extractEnergy(50, true) >= 50) {
            ((GridEnergy)this.enderEnergy.getGrid()).myStorage.extractEnergy(50, false);
            this.multiAdvance(travelingItem, true);
        } else {
            super.insertNewItem(travelingItem);
        }
    }

    public void multiAdvance(TravelingItem travelingItem, boolean newInsert) {
        DuctUnitItem duct;
        block6: {
            block7: {
                duct = this;
                do {
                    duct.pulseLine(travelingItem.direction, (byte)(travelingItem.oldDirection ^ 1));
                    DuctUnitItem newHome = (DuctUnitItem)duct.getConnectedSide(travelingItem.direction);
                    if (newHome == null) break block6;
                    if (newHome.getConnectedSide(travelingItem.direction ^ 1) == null) break block7;
                    duct = newHome;
                    if (!travelingItem.myPath.hasNextDirection()) {
                        travelingItem.reRoute = true;
                        this.transferItem(travelingItem, duct, newInsert);
                        return;
                    }
                    travelingItem.oldDirection = travelingItem.direction;
                    travelingItem.direction = travelingItem.myPath.getNextDirection();
                } while (duct.getClass() == DuctUnitItemEnder.class);
                this.transferItem(travelingItem, duct, newInsert);
                return;
            }
            travelingItem.reRoute = true;
            this.transferItem(travelingItem, duct, newInsert);
            return;
        }
        if (duct.isOutput(travelingItem.direction)) {
            travelingItem.stack.func_190920_e(duct.insertIntoInventory(travelingItem.stack, travelingItem.direction));
            if (travelingItem.stack.func_190916_E() > 0) {
                travelingItem.reRoute = true;
                this.transferItem(travelingItem, duct, newInsert);
            } else if (!newInsert) {
                this.itemsToRemove.add(travelingItem);
            }
            return;
        }
        travelingItem.reRoute = true;
        this.transferItem(travelingItem, duct, newInsert);
    }

    public void transferItem(TravelingItem travelingItem, DuctUnitItem duct, boolean newInsert) {
        if (newInsert) {
            ((GridItem)this.grid).shouldRepoll = true;
            duct.transferItem(travelingItem);
        } else if (duct != this) {
            duct.transferItem(travelingItem);
            this.itemsToRemove.add(travelingItem);
        }
    }

    public void sendPowerPacket() {
        PacketTileInfo myPayload = this.newPacketTileInfo();
        myPayload.addByte((byte)6);
        myPayload.addBool(this.powered);
        PacketHandler.sendToAllAround((PacketBase)myPayload, (TileEntity)this.parent);
    }

    @Override
    public void handlePacketType(PacketCoFHBase payload, int b) {
        if (b == 6) {
            this.powered = payload.getBool();
            this.centerLine = 0;
            for (int i = 0; i < this.centerLineSub.length; ++i) {
                this.centerLineSub[i] = 0;
            }
        } else {
            super.handlePacketType(payload, b);
        }
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return pass == 0 && (this.powered || super.shouldRenderInPass(pass));
    }

    @Override
    public void writeToTilePacket(PacketCoFHBase payload) {
        payload.addBool(this.isPowered());
    }

    public boolean isPowered() {
        return this.enderEnergy.getGrid() != null ? ((GridEnergy)this.enderEnergy.getGrid()).isPowered() : this.powered;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketCoFHBase payload) {
        this.powered = payload.getBool();
    }

    public void updateRender() {
        if (this.enderEnergy.getGrid() != null && ((GridEnergy)this.enderEnergy.getGrid()).isPowered() != this.powered) {
            this.powered = ((GridEnergy)this.enderEnergy.getGrid()).isPowered();
            this.sendPowerPacket();
        }
        if (!this.powered && this.hasChanged) {
            this.hasChanged = false;
            this.sendTravelingItemsPacket();
        }
    }
}

