/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct;

import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.DuctUnitStructural;
import cofh.thermaldynamics.duct.attachments.relay.Relay;
import cofh.thermaldynamics.multiblock.IGridTile;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cofh.thermaldynamics.util.WorldGridList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class GridStructural
extends MultiBlockGrid<DuctUnitStructural> {
    public boolean signalsUpToDate;
    public MultiBlockGrid.RedstoneControl rs;

    public GridStructural(WorldGridList worldGrid) {
        super(worldGrid);
    }

    public GridStructural(World worldObj) {
        super(worldObj);
    }

    @Override
    public boolean canAddBlock(IGridTile aBlock) {
        return true;
    }

    @Override
    public void tickGrid() {
        Relay signaller;
        Iterator<Object> iterator;
        if (this.rs != null && this.rs.nextRedstoneLevel != -128) {
            this.rs.redstoneLevel = this.rs.nextRedstoneLevel;
            this.rs.nextRedstoneLevel = (byte)-128;
            ArrayList<Attachment> signallersOut = this.rs.relaysOut;
            if (signallersOut != null) {
                iterator = signallersOut.iterator();
                while (iterator.hasNext()) {
                    Attachment output = (Attachment)iterator.next();
                    output.checkSignal();
                }
            }
        }
        if (this.signalsUpToDate) {
            return;
        }
        this.signalsUpToDate = true;
        if (this.rs == null || this.rs.relaysIn == null) {
            if (this.rs != null) {
                this.rs.relaysOut = null;
            }
            for (DuctUnitStructural multiBlock : this.nodeSet) {
                multiBlock.addRelays();
            }
            for (DuctUnitStructural multiBlock : this.idleSet) {
                multiBlock.addRelays();
            }
        }
        if (this.rs == null) {
            return;
        }
        if (this.rs.relaysIn == null) {
            if (this.rs.relaysOut == null) {
                this.rs = null;
                return;
            }
            this.rs.nextRedstoneLevel = 0;
            return;
        }
        int powered = 0;
        iterator = this.rs.relaysIn.iterator();
        while (iterator.hasNext() && (powered = Math.max(powered, (signaller = (Relay)iterator.next()).getPowerLevel())) != 15) {
        }
        this.rs.nextRedstoneLevel = (byte)powered;
    }

    public void addSignalInput(Relay signaller) {
        if (signaller.isInput()) {
            if (this.rs == null) {
                this.rs = new MultiBlockGrid.RedstoneControl();
            }
            if (this.rs.relaysIn == null) {
                this.rs.relaysIn = new ArrayList();
            }
            this.rs.relaysIn.add(signaller);
        }
    }

    public void addSignalOutput(Attachment attachment) {
        if (this.rs == null) {
            this.rs = new MultiBlockGrid.RedstoneControl();
        }
        if (this.rs.relaysOut == null) {
            this.rs.relaysOut = new ArrayList();
        }
        this.rs.relaysOut.add(attachment);
    }

    public void resetRelays() {
        if (this.rs != null) {
            this.rs.relaysIn = null;
            this.rs.relaysOut = null;
        }
        this.signalsUpToDate = false;
    }

    @Override
    public void onMinorGridChange() {
        this.resetRelays();
    }

    @Override
    public void onMajorGridChange() {
        this.resetRelays();
    }

    @Override
    public void addInfo(List<ITextComponent> info, EntityPlayer player, boolean debug) {
        if (this.rs != null) {
            int r = this.rs.redstoneLevel;
            if (this.rs.nextRedstoneLevel != -128) {
                r = this.rs.nextRedstoneLevel;
            }
            this.addInfo(info, "redstone", r);
        }
        super.addInfo(info, player, debug);
    }
}

