/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.item;

import cofh.api.core.ISecurable;
import cofh.core.item.ItemMulti;
import cofh.core.render.IModelRegister;
import cofh.core.util.StateMapper;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ChatHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.thermalfoundation.ThermalFoundation;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSecurity
extends ItemMulti
implements IInitializer {
    public static ItemStack lock;

    public ItemSecurity() {
        super("thermalfoundation");
        this.setUnlocalizedName("util", "security");
        this.func_77637_a(ThermalFoundation.tabCommon);
        this.func_77627_a(true);
    }

    private boolean doLockUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (ServerHelper.isClientWorld((World)world)) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ISecurable) {
            if (((ISecurable)tile).setOwner(player.func_146103_bH())) {
                ((ISecurable)tile).setAccess(ISecurable.AccessMode.PUBLIC);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.cofh.secure.block.success", new Object[0]));
            }
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean advanced) {
    }

    public boolean func_77662_d() {
        return true;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return player.func_175151_a(pos.func_177972_a(facing), facing, player.func_184586_b(hand)) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        boolean ret;
        ItemStack stack = player.func_184586_b(hand);
        switch (Type.values()[ItemHelper.getItemDamage((ItemStack)stack)]) {
            case LOCK: {
                ret = this.doLockUseFirst(stack, player, world, pos, side, hitX, hitY, hitZ, hand);
                break;
            }
            default: {
                return EnumActionResult.PASS;
            }
        }
        return ret ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        StateMapper mapper = new StateMapper(this.modName, "util", this.name);
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)mapper);
        for (Map.Entry entry : this.itemMap.entrySet()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)((Integer)entry.getKey()), (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + "util", "type=" + ((ItemMulti.ItemEntry)entry.getValue()).name));
        }
    }

    public boolean preInit() {
        lock = this.addItem(Type.LOCK.ordinal(), "lock");
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)this);
        return true;
    }

    public boolean initialize() {
        ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)lock, (Object[])new Object[]{" S ", "SBS", "SSS", Character.valueOf('B'), "ingotBronze", Character.valueOf('S'), "nuggetSignalum"}));
        return true;
    }

    public boolean postInit() {
        return true;
    }

    static enum Type {
        LOCK;

    }
}

