/*
 * Decompiled with CFR 0.152.
 */
package squeek.speedometer.gui.widget;

import squeek.speedometer.gui.IGuiHierarchical;
import squeek.speedometer.gui.widget.IWidget;
import squeek.speedometer.gui.widget.WidgetBase;

public class WidgetFluidGrid
extends WidgetBase {
    public int margin = 4;
    public int padding = 0;
    public int columns = 0;
    public int columnWidth = 100;

    public WidgetFluidGrid(IGuiHierarchical parent, int x, int y, int w, int h) {
        super(parent, x, y, w, h);
    }

    @Override
    protected void onChildrenChanged() {
        super.onChildrenChanged();
        this.determineLayout();
    }

    public void determineLayout() {
        int totalHeightAvailablePerColumn = this.h - this.margin * 2 - this.padding * 2;
        if (totalHeightAvailablePerColumn > 0) {
            int totalHeightOfAllChildren = 0;
            int widthOfWidestChild = 0;
            for (IWidget child : this.children) {
                totalHeightOfAllChildren += child.getHeight() + this.margin * 2 + this.padding * 2;
                if (child.getWidth() <= widthOfWidestChild) continue;
                widthOfWidestChild = child.getWidth();
            }
            this.columnWidth = widthOfWidestChild + this.margin * 2 + this.padding * 2;
            int maxColumns = (int)Math.floor(this.w / this.columnWidth);
            int neededColumns = (int)Math.floor(totalHeightOfAllChildren / totalHeightAvailablePerColumn + 1);
            if (neededColumns > maxColumns) {
                maxColumns = neededColumns;
            }
            this.columns = Math.max(0, Math.min(neededColumns, Math.min(this.children.size(), maxColumns)));
            int clampedW = Math.min(this.w, this.columnWidth * this.columns);
            int clampedX = this.x + (this.w - clampedW) / 2;
            int[] columnHeights = new int[this.columns];
            int tallestColumnHeight = 0;
            int iColumn = 0;
            for (int iChildIndex = 0; iChildIndex < this.children.size(); ++iChildIndex) {
                int n = iColumn;
                columnHeights[n] = columnHeights[n] + (((IWidget)this.children.get(iChildIndex)).getHeight() + this.margin * 2);
                if (columnHeights[iColumn] > tallestColumnHeight) {
                    tallestColumnHeight = columnHeights[iColumn];
                }
                iColumn = (iColumn + 1) % this.columns;
            }
            int columnYOffset = Math.max(0, (this.h - tallestColumnHeight) / 2);
            int[] columnY = new int[this.columns];
            int iColumn2 = 0;
            for (int iChildIndex = 0; iChildIndex < this.children.size(); ++iChildIndex) {
                int elementX = clampedX + iColumn2 * this.columnWidth;
                int elementY = this.y + columnYOffset + columnY[iColumn2];
                IWidget child = (IWidget)this.children.get(iChildIndex);
                child.setPos(elementX + this.columnWidth / 2 - child.getWidth() / 2, elementY += this.margin);
                columnY[iColumn2] = (elementY += child.getHeight() + this.margin) - this.y - columnYOffset;
                iColumn2 = (iColumn2 + 1) % this.columns;
            }
        }
    }
}

