/*
 * Decompiled with CFR 0.152.
 */
package squeek.speedometer.gui.widget;

import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import squeek.speedometer.gui.GuiEvent;
import squeek.speedometer.gui.IGuiHierarchical;
import squeek.speedometer.gui.widget.IWidget;
import squeek.speedometer.gui.widget.WidgetBase;
import squeek.speedometer.gui.widget.WidgetLabel;

public class WidgetButton
extends WidgetBase {
    protected static final ResourceLocation DEFAULT_BUTTON_TEXTURE = new ResourceLocation("textures/gui/widgets.png");
    protected ResourceLocation buttonTexture = DEFAULT_BUTTON_TEXTURE;
    protected int textureX = 0;
    protected int textureY = 46;
    protected WidgetLabel label = null;

    public WidgetButton(IGuiHierarchical parent, int x, int y, int w, int h, String labelText) {
        super(parent, x, y, w, h);
        this.label = new WidgetLabel(this, this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2, labelText, 0xFFFFFF, true);
    }

    public WidgetButton(IGuiHierarchical parent, int x, int y, int w, int h, ResourceLocation buttonTexture, int textureX, int textureY, String labelText) {
        super(parent, x, y, w, h);
        this.buttonTexture = buttonTexture;
        this.textureX = textureX;
        this.textureY = textureY;
        this.label = new WidgetLabel(this, x + w / 2, y + h / 2, labelText, 0xFFFFFF, true);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        this.MC.func_110434_K().func_110577_a(this.buttonTexture);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int offsetTextureY = (this.isEnabled() ? (this.isMouseInsideBounds(mouseX, mouseY) ? 2 : 1) : 0) * 20;
        this.func_73729_b(this.x, this.y, this.textureX, this.textureY + offsetTextureY, this.w / 2, this.h);
        this.func_73729_b(this.x + this.w / 2, this.y, this.textureX + 200 - this.w / 2, this.textureY + offsetTextureY, this.w / 2, this.h);
        for (IWidget child : this.children) {
            if (!(child instanceof WidgetLabel)) continue;
            WidgetLabel childLabel = (WidgetLabel)child;
            childLabel.setColor(this.isEnabled() ? (this.isMouseInsideBounds(mouseX, mouseY) ? 0xFFFFA0 : 0xFFFFFF) : 0xA0A0A0);
        }
        super.drawBackground(mouseX, mouseY);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int type, boolean isShiftKeyDown) {
        if (this.isEnabled() && this.isVisible() && this.isMouseInsideBounds(mouseX, mouseY)) {
            this.MC.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.onClicked(type, isShiftKeyDown);
        } else {
            super.mouseClicked(mouseX, mouseY, type, isShiftKeyDown);
        }
    }

    protected void onClicked(int type, boolean isShiftKeyDown) {
        Object[] eventData = new Object[]{type, isShiftKeyDown};
        this.pushGuiEvent(GuiEvent.BUTTON_PRESSED, eventData);
    }

    public void setLabelText(String text) {
        this.label.setText(text);
    }
}

