/*
 * Decompiled with CFR 0.152.
 */
package squeek.speedometer.gui.screen;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.common.Loader;
import squeek.speedometer.ModConfig;
import squeek.speedometer.SpeedUnit;
import squeek.speedometer.gui.GuiEvent;
import squeek.speedometer.gui.IGuiHierarchical;
import squeek.speedometer.gui.screen.GuiScreen;
import squeek.speedometer.gui.widget.IWidget;
import squeek.speedometer.gui.widget.WidgetBox;
import squeek.speedometer.gui.widget.WidgetButton;
import squeek.speedometer.gui.widget.WidgetFluidGrid;
import squeek.speedometer.gui.widget.WidgetLabel;
import squeek.speedometer.gui.widget.WidgetTextField;
import squeek.speedometer.gui.widget.WidgetWrapper;

public class ScreenSpeedometerSettings
extends GuiScreen {
    private static final int padding = 5;
    private static final int colWidth = 150;
    private static final int rowHeight = 20;
    private static final int buttonHeight = 20;
    private static final int buttonWidth = 50;
    private static final int alignButtonDimensions = 10;
    protected WidgetButton saveButton;
    protected WidgetButton cancelButton;
    protected WidgetButton lastJumpButton;
    protected WidgetButton lastJumpFloatButton;
    protected WidgetButton unitsButton;
    protected WidgetButton backgroundButton;
    protected WidgetButton showUnitsButton;
    protected WidgetTextField xField;
    protected WidgetTextField yField;
    protected WidgetTextField paddingField;
    protected WidgetTextField marginField;
    protected WidgetWrapper alignmentSettings;
    protected WidgetTextField precisionField;

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int midX = this.field_146294_l / 2;
        int topY = Math.max(5, this.field_146295_m / 6 - 20);
        int bottomY = this.field_146295_m - 20 - Math.max(5, this.field_146295_m / 8 - 20);
        new WidgetLabel(this, midX, topY + this.field_146289_q.field_78288_b / 2, I18n.func_135052_a((String)"squeedometer.settings.title", (Object[])new Object[0]), 0xFFFFFF, true);
        this.saveButton = new WidgetButton(this, midX - 50 - 5, bottomY, 50, 20, I18n.func_135052_a((String)"squeedometer.settings.save", (Object[])new Object[0]));
        this.cancelButton = new WidgetButton(this, midX + 5, bottomY, 50, 20, I18n.func_135052_a((String)"squeedometer.settings.cancel", (Object[])new Object[0]));
        int gridHeight = (bottomY -= 5) - (topY += this.field_146289_q.field_78288_b + 5);
        int halfColWidth = 72;
        WidgetFluidGrid fluidGrid = new WidgetFluidGrid(this, 5, topY, this.field_146294_l - 10, gridHeight);
        WidgetWrapper positionSettings = new WidgetWrapper(fluidGrid);
        this.xField = new WidgetTextField(positionSettings, 0, this.field_146289_q.field_78288_b + 5, halfColWidth, 20);
        new WidgetLabel((IGuiHierarchical)positionSettings, (int)0, (int)0, (String)I18n.func_135052_a((String)"squeedometer.settings.x", (Object[])new Object[0])).drawCentered = false;
        this.yField = new WidgetTextField(positionSettings, halfColWidth + 5, this.field_146289_q.field_78288_b + 5, halfColWidth, 20);
        new WidgetLabel((IGuiHierarchical)positionSettings, (int)(halfColWidth + 5), (int)0, (String)I18n.func_135052_a((String)"squeedometer.settings.y", (Object[])new Object[0])).drawCentered = false;
        WidgetWrapper layoutSettings = new WidgetWrapper(fluidGrid);
        this.marginField = new WidgetTextField(layoutSettings, 0, this.field_146289_q.field_78288_b + 5, halfColWidth, 20);
        new WidgetLabel((IGuiHierarchical)layoutSettings, (int)0, (int)0, (String)I18n.func_135052_a((String)"squeedometer.settings.margin", (Object[])new Object[0])).drawCentered = false;
        this.paddingField = new WidgetTextField(layoutSettings, halfColWidth + 5, this.field_146289_q.field_78288_b + 5, halfColWidth, 20);
        new WidgetLabel((IGuiHierarchical)layoutSettings, (int)(halfColWidth + 5), (int)0, (String)I18n.func_135052_a((String)"squeedometer.settings.padding", (Object[])new Object[0])).drawCentered = false;
        int alignBoxTop = this.field_146289_q.field_78288_b + 5;
        int alignBoxHeight = 46;
        this.alignmentSettings = new WidgetWrapper(fluidGrid);
        new WidgetLabel((IGuiHierarchical)this.alignmentSettings, (int)0, (int)0, (String)I18n.func_135052_a((String)"squeedometer.settings.screenalign", (Object[])new Object[0])).drawCentered = false;
        new WidgetBox(this.alignmentSettings, 0, alignBoxTop, 150, alignBoxHeight);
        new WidgetScreenAlignment(this.alignmentSettings, 0, alignBoxTop, 10, 10, "left", "top");
        new WidgetScreenAlignment(this.alignmentSettings, 70, alignBoxTop, 10, 10, "center", "top");
        new WidgetScreenAlignment(this.alignmentSettings, 140, alignBoxTop, 10, 10, "right", "top");
        new WidgetScreenAlignment(this.alignmentSettings, 0, alignBoxTop + alignBoxHeight / 2 - 5, 10, 10, "left", "middle");
        new WidgetScreenAlignment(this.alignmentSettings, 70, alignBoxTop + alignBoxHeight / 2 - 5, 10, 10, "center", "middle");
        new WidgetScreenAlignment(this.alignmentSettings, 140, alignBoxTop + alignBoxHeight / 2 - 5, 10, 10, "right", "middle");
        new WidgetScreenAlignment(this.alignmentSettings, 0, alignBoxTop + alignBoxHeight - 10, 10, 10, "left", "bottom");
        new WidgetScreenAlignment(this.alignmentSettings, 70, alignBoxTop + alignBoxHeight - 10, 10, 10, "center", "bottom");
        new WidgetScreenAlignment(this.alignmentSettings, 140, alignBoxTop + alignBoxHeight - 10, 10, 10, "right", "bottom");
        WidgetWrapper buttons = new WidgetWrapper(fluidGrid);
        this.unitsButton = new WidgetButton(buttons, 0, 0, 150, 20, "");
        this.showUnitsButton = new WidgetButton(buttons, 0, 25, 150, 20, "");
        this.backgroundButton = new WidgetButton(buttons, 0, 50, 150, 20, "");
        WidgetWrapper jumpInfoButtons = new WidgetWrapper(fluidGrid);
        this.lastJumpButton = new WidgetButton(jumpInfoButtons, 0, 0, 150, 20, "");
        this.lastJumpFloatButton = new WidgetButton(jumpInfoButtons, 0, 25, 150, 20, "");
        WidgetWrapper precisionSettings = new WidgetWrapper(fluidGrid);
        this.precisionField = new WidgetTextField(precisionSettings, 0, this.field_146289_q.field_78288_b + 5, 150, 20);
        new WidgetLabel((IGuiHierarchical)precisionSettings, (int)0, (int)0, (String)I18n.func_135052_a((String)"squeedometer.settings.precision", (Object[])new Object[0])).drawCentered = false;
        if (!Loader.isModLoaded((String)"Squake")) {
            this.lastJumpButton.setEnabled(false);
            this.lastJumpFloatButton.setEnabled(false);
            jumpInfoButtons.setTooltipString(I18n.func_135052_a((String)"squeedometer.needs.squake", (Object[])new Object[0]));
        }
        fluidGrid.determineLayout();
        this.setWidgetValuesFromConfig();
    }

    private void setWidgetValuesFromConfig() {
        this.lastJumpButton.setLabelText(I18n.func_135052_a((String)"squeedometer.settings.lastjump", (Object[])new Object[]{ModConfig.LAST_JUMP_INFO_ENABLED.getBoolean(true) ? I18n.func_135052_a((String)"squeedometer.settings.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"squeedometer.settings.off", (Object[])new Object[0])}));
        this.lastJumpFloatButton.setLabelText(I18n.func_135052_a((String)"squeedometer.settings.lastjump.float", (Object[])new Object[]{ModConfig.LAST_JUMP_INFO_FLOAT_ENABLED.getBoolean(true) ? I18n.func_135052_a((String)"squeedometer.settings.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"squeedometer.settings.off", (Object[])new Object[0])}));
        this.unitsButton.setLabelText(I18n.func_135052_a((String)"squeedometer.settings.units", (Object[])new Object[]{ModConfig.SPEED_UNIT.toString()}));
        this.backgroundButton.setLabelText(I18n.func_135052_a((String)"squeedometer.settings.background", (Object[])new Object[]{ModConfig.SPEEDOMETER_DRAW_BACKGROUND.getBoolean(true) ? I18n.func_135052_a((String)"squeedometer.settings.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"squeedometer.settings.off", (Object[])new Object[0])}));
        Object[] objectArray = new Object[1];
        objectArray[0] = ModConfig.SHOW_UNITS.getBoolean(true) ? (ModConfig.MINIMAL_UNITS.getBoolean(true) ? I18n.func_135052_a((String)"squeedometer.settings.minimal", (Object[])new Object[0]) : I18n.func_135052_a((String)"squeedometer.settings.on", (Object[])new Object[0])) : I18n.func_135052_a((String)"squeedometer.settings.off", (Object[])new Object[0]);
        this.showUnitsButton.setLabelText(I18n.func_135052_a((String)"squeedometer.settings.show.units", (Object[])objectArray));
        this.xField.setText(String.valueOf(ModConfig.SPEEDOMETER_XPOS.getInt(0)));
        this.yField.setText(String.valueOf(ModConfig.SPEEDOMETER_YPOS.getInt(0)));
        this.marginField.setText(String.valueOf(ModConfig.SPEEDOMETER_MARGIN.getInt(0)));
        this.paddingField.setText(String.valueOf(ModConfig.SPEEDOMETER_PADDING.getInt(0)));
        this.precisionField.setText(String.valueOf(ModConfig.SPEEDOMETER_PRECISION.getInt(0)));
        String alignX = ModConfig.SPEEDOMETER_ALIGNMENT_X.getString();
        String alignY = ModConfig.SPEEDOMETER_ALIGNMENT_Y.getString();
        for (IWidget alignmentSettingsChild : this.alignmentSettings.children) {
            if (!(alignmentSettingsChild instanceof WidgetScreenAlignment)) continue;
            WidgetScreenAlignment widgetAlign = (WidgetScreenAlignment)alignmentSettingsChild;
            widgetAlign.isHighlighted = widgetAlign.xAlign.equals(alignX) && widgetAlign.yAlign.equals(alignY);
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, f);
        GlStateManager.func_179140_f();
    }

    public boolean func_73868_f() {
        return true;
    }

    @Override
    public void onGuiEvent(GuiEvent event, Object source, Object[] data) {
        if (event == GuiEvent.BUTTON_PRESSED) {
            int type = (Integer)data[0];
            if (source == this.saveButton || source == this.cancelButton) {
                if (type == 0) {
                    if (source == this.saveButton) {
                        ModConfig.save();
                    } else if (source == this.cancelButton) {
                        ModConfig.load();
                    }
                    this.field_146297_k.func_147108_a(null);
                }
                return;
            }
            if (source == this.lastJumpButton) {
                boolean lastJump = ModConfig.LAST_JUMP_INFO_ENABLED.getBoolean(true);
                if (lastJump) {
                    this.lastJumpFloatButton.setEnabled(false);
                } else {
                    this.lastJumpFloatButton.setEnabled(true);
                }
                ModConfig.LAST_JUMP_INFO_ENABLED.set(!lastJump);
            } else if (source == this.lastJumpFloatButton) {
                ModConfig.LAST_JUMP_INFO_FLOAT_ENABLED.set(!ModConfig.LAST_JUMP_INFO_FLOAT_ENABLED.getBoolean(true));
            } else if (source == this.unitsButton) {
                int numUnits = SpeedUnit.values().length;
                int step = type == 0 ? 1 : -1;
                int nextIndex = (ModConfig.SPEED_UNIT.ordinal() + step % numUnits + numUnits) % numUnits;
                ModConfig.setSpeedUnit(SpeedUnit.values()[nextIndex]);
            } else if (source == this.backgroundButton) {
                ModConfig.SPEEDOMETER_DRAW_BACKGROUND.set(!ModConfig.SPEEDOMETER_DRAW_BACKGROUND.getBoolean(true));
            } else if (source == this.showUnitsButton) {
                boolean showUnits = ModConfig.SHOW_UNITS.getBoolean(true);
                if (!showUnits) {
                    ModConfig.SHOW_UNITS.set(true);
                    ModConfig.MINIMAL_UNITS.set(false);
                } else {
                    boolean minimalUnits = ModConfig.MINIMAL_UNITS.getBoolean(true);
                    if (minimalUnits) {
                        ModConfig.SHOW_UNITS.set(false);
                    } else {
                        ModConfig.MINIMAL_UNITS.set(true);
                    }
                }
            } else if (source instanceof WidgetScreenAlignment) {
                ModConfig.SPEEDOMETER_ALIGNMENT_X.set((String)data[2]);
                ModConfig.SPEEDOMETER_ALIGNMENT_Y.set((String)data[3]);
            } else {
                return;
            }
            this.setWidgetValuesFromConfig();
        } else if (event == GuiEvent.TEXT_CHANGED) {
            int intVal;
            String text = (String)data[0];
            try {
                intVal = Integer.parseInt(text);
            }
            catch (NumberFormatException ex) {
                return;
            }
            if (source == this.xField) {
                ModConfig.SPEEDOMETER_XPOS.set(intVal);
            } else if (source == this.yField) {
                ModConfig.SPEEDOMETER_YPOS.set(intVal);
            } else if (source == this.marginField) {
                ModConfig.SPEEDOMETER_MARGIN.set(intVal);
            } else if (source == this.paddingField) {
                ModConfig.SPEEDOMETER_PADDING.set(intVal);
            } else if (source == this.precisionField) {
                ModConfig.SPEEDOMETER_PRECISION.set(intVal);
            } else {
                return;
            }
            this.setWidgetValuesFromConfig();
        }
        super.onGuiEvent(event, source, data);
    }

    protected class WidgetScreenAlignment
    extends WidgetButton {
        private String xAlign;
        private String yAlign;
        public boolean isHighlighted;
        public int highlightColor;
        public int buttonColor;
        public int hoverColor;
        public int disabledColor;
        public int innerColor;

        public WidgetScreenAlignment(IGuiHierarchical parent, int x, int y, int w, int h, String xAlign, String yAlign) {
            super(parent, x, y, w, h, "");
            this.isHighlighted = false;
            this.highlightColor = -16746752;
            this.buttonColor = -16777216;
            this.hoverColor = -13421773;
            this.disabledColor = -5592406;
            this.innerColor = -6250336;
            this.xAlign = xAlign;
            this.yAlign = yAlign;
        }

        @Override
        public void drawBackground(int mouseX, int mouseY) {
            if (this.isVisible()) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean hovered = this.isMouseInsideBounds(mouseX, mouseY);
                Gui.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.w), (int)(this.y + this.h), (int)(this.isHighlighted ? this.highlightColor : this.innerColor));
                Gui.func_73734_a((int)(this.x + 1), (int)(this.y + 1), (int)(this.x + this.w - 1), (int)(this.y + this.h - 1), (int)(!this.isEnabled() ? this.disabledColor : (hovered ? this.hoverColor : this.buttonColor)));
            }
        }

        @Override
        protected void onClicked(int type, boolean isShiftKeyDown) {
            Object[] eventData = new Object[]{type, isShiftKeyDown, this.xAlign, this.yAlign};
            this.pushGuiEvent(GuiEvent.BUTTON_PRESSED, eventData);
        }
    }
}

