/*
 * Decompiled with CFR 0.152.
 */
package squeek.speedometer;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import squeek.speedometer.ModConfig;

public class HudSpeedometer
extends Gui {
    private static final Minecraft MC = FMLClientHandler.instance().getClient();
    private double firstJumpSpeed = 0.0;
    private double lastJumpSpeed = 0.0;
    private double percentJumpSpeedChanged = 0.0;
    private double jumpSpeedChanged = 0.0;
    private static boolean didJumpThisTick = false;
    private static boolean isJumping = false;
    private boolean didJumpLastTick = false;
    private long jumpInfoStartTime = 0L;
    private boolean wasFirstJump = true;
    private double currentSpeed = 0.0;

    public static void setDidJumpThisTick(boolean val) {
        didJumpThisTick = val;
    }

    public static void setIsJumping(boolean val) {
        isJumping = val;
    }

    @SubscribeEvent
    public void onRenderExperienceBar(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        this.updateValues();
        this.draw();
    }

    private float lastJumpInfoTimeRemaining() {
        return (float)(Minecraft.func_71386_F() - this.jumpInfoStartTime) / 1000.0f;
    }

    private boolean showingLastJumpInfo() {
        return this.jumpInfoStartTime != 0L && this.lastJumpInfoTimeRemaining() <= (float)ModConfig.LAST_JUMP_INFO_DURATION.getDouble(3.0);
    }

    private void draw() {
        ScaledResolution scaledresolution = new ScaledResolution(MC);
        boolean drawCurrentSpeed = true;
        boolean drawJumpSpeedChanged = this.lastJumpSpeed != 0.0 && this.showingLastJumpInfo();
        String numFormatString = "%." + ModConfig.SPEEDOMETER_PRECISION.getInt() + "f";
        String unitString = ModConfig.SHOW_UNITS.getBoolean(true) ? " " + (ModConfig.MINIMAL_UNITS.getBoolean(true) ? ModConfig.SPEED_UNIT.minimalName : ModConfig.SPEED_UNIT.name) : "";
        String strCurrentSpeed = drawCurrentSpeed ? String.format(numFormatString + "%s", ModConfig.SPEED_UNIT.convertTo(this.currentSpeed), unitString) : null;
        String strJumpSpeedChanged = !this.wasFirstJump ? String.format("%+.2f (%+.1f%%)", ModConfig.SPEED_UNIT.convertTo(this.jumpSpeedChanged), this.percentJumpSpeedChanged * 100.0) : String.format(numFormatString, ModConfig.SPEED_UNIT.convertTo(this.firstJumpSpeed));
        int width = HudSpeedometer.MC.field_71466_p.func_78256_a(strCurrentSpeed);
        int height = HudSpeedometer.MC.field_71466_p.field_78288_b;
        int padding = ModConfig.SPEEDOMETER_PADDING.getInt();
        int margin = ModConfig.SPEEDOMETER_MARGIN.getInt();
        int xPos = ModConfig.SPEEDOMETER_XPOS.getInt() + margin;
        int yPos = ModConfig.SPEEDOMETER_YPOS.getInt() + margin;
        int realheight = height + padding + padding - 1;
        if (ModConfig.SPEEDOMETER_ALIGNMENT_X.getString().equals("center") || ModConfig.SPEEDOMETER_ALIGNMENT_X.getString().equals("middle")) {
            xPos += scaledresolution.func_78326_a() / 2 - (margin * 2 + width + padding * 2) / 2;
        } else if (ModConfig.SPEEDOMETER_ALIGNMENT_X.getString().equals("right")) {
            xPos += scaledresolution.func_78326_a() - margin * 2 - width - padding * 2;
        }
        if (ModConfig.SPEEDOMETER_ALIGNMENT_Y.getString().equals("center") || ModConfig.SPEEDOMETER_ALIGNMENT_Y.getString().equals("middle")) {
            yPos += scaledresolution.func_78328_b() / 2 - (margin * 2 + realheight) / 2;
        } else if (ModConfig.SPEEDOMETER_ALIGNMENT_Y.getString().equals("bottom")) {
            yPos += scaledresolution.func_78328_b() - margin * 2 - realheight;
        }
        if (ModConfig.SPEEDOMETER_DRAW_BACKGROUND.getBoolean(true)) {
            Gui.func_73734_a((int)xPos, (int)yPos, (int)(xPos + width + padding * 2), (int)(yPos + height + padding + padding - 1), (int)-1442840576);
        }
        xPos += padding;
        yPos += padding;
        if (drawJumpSpeedChanged && ModConfig.LAST_JUMP_INFO_ENABLED.getBoolean(true)) {
            int stringWidth = HudSpeedometer.MC.field_71466_p.func_78256_a(strJumpSpeedChanged);
            int floatingXPos = xPos + width / 2 - stringWidth / 2;
            if (floatingXPos < margin) {
                floatingXPos = margin;
            } else if (floatingXPos > scaledresolution.func_78326_a() - stringWidth - margin) {
                floatingXPos = scaledresolution.func_78326_a() - stringWidth - margin;
            }
            int floatingYPos = yPos;
            int floatingYPosOffset = (int)((float)HudSpeedometer.MC.field_71466_p.field_78288_b * 1.75f);
            int floatingYPosOffsetDirection = floatingYPos - floatingYPosOffset < 0 ? 1 : -1;
            floatingYPos += floatingYPosOffsetDirection * floatingYPosOffset;
            if (ModConfig.LAST_JUMP_INFO_FLOAT_ENABLED.getBoolean(true)) {
                float percentJumpInfoElapsed = this.lastJumpInfoTimeRemaining() / (float)ModConfig.LAST_JUMP_INFO_DURATION.getDouble(3.0);
                floatingYPos = (int)((float)floatingYPos + (float)floatingYPosOffsetDirection * (percentJumpInfoElapsed * (float)HudSpeedometer.MC.field_71466_p.field_78288_b * 4.0f));
            }
            int color = this.wasFirstJump ? 2849791 : (this.jumpSpeedChanged == 0.0 ? 0xE0E0E0 : (this.jumpSpeedChanged > 0.0 ? 1481216 : 0x9A0000));
            this.func_73731_b(HudSpeedometer.MC.field_71466_p, strJumpSpeedChanged, floatingXPos, floatingYPos, color);
        }
        if (drawCurrentSpeed) {
            this.func_73731_b(HudSpeedometer.MC.field_71466_p, strCurrentSpeed, xPos, yPos, 0xE0E0E0);
        }
    }

    private void updateValues() {
        double distTraveledLastTickX = HudSpeedometer.MC.field_71439_g.field_70165_t - HudSpeedometer.MC.field_71439_g.field_70169_q;
        double distTraveledLastTickZ = HudSpeedometer.MC.field_71439_g.field_70161_v - HudSpeedometer.MC.field_71439_g.field_70166_s;
        this.currentSpeed = MathHelper.func_76133_a((double)(distTraveledLastTickX * distTraveledLastTickX + distTraveledLastTickZ * distTraveledLastTickZ));
        if ((this.showingLastJumpInfo() || didJumpThisTick) && (!HudSpeedometer.MC.field_71439_g.field_70122_E || isJumping)) {
            if (didJumpThisTick && !this.didJumpLastTick) {
                this.wasFirstJump = this.lastJumpSpeed == 0.0;
                this.percentJumpSpeedChanged = this.currentSpeed != 0.0 ? this.currentSpeed / this.lastJumpSpeed - 1.0 : -1.0;
                this.jumpSpeedChanged = this.currentSpeed - this.lastJumpSpeed;
                this.jumpInfoStartTime = Minecraft.func_71386_F();
                this.lastJumpSpeed = this.currentSpeed;
                this.firstJumpSpeed = this.wasFirstJump ? this.lastJumpSpeed : 0.0;
            }
            this.didJumpLastTick = didJumpThisTick;
        } else {
            this.didJumpLastTick = false;
            this.lastJumpSpeed = 0.0;
        }
    }
}

