/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.tileentities;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.zarathul.simplefluidtanks.blocks.FluidTank;
import net.zarathul.simplefluidtanks.blocks.TankBlock;
import net.zarathul.simplefluidtanks.common.BasicAStar;
import net.zarathul.simplefluidtanks.common.BlockSearchMode;
import net.zarathul.simplefluidtanks.common.Direction;
import net.zarathul.simplefluidtanks.common.Utils;
import net.zarathul.simplefluidtanks.configuration.Config;
import net.zarathul.simplefluidtanks.tileentities.TankBlockEntity;

public class ValveBlockEntity
extends TileEntity
implements IFluidHandler {
    private final FluidTank internalTank = new FluidTank(0);
    private IFluidTankProperties[] properties;
    private int linkedTankCount = 0;
    private Multimap<Integer, BlockPos> tankPriorities = ArrayListMultimap.create();
    private byte tankFacingSides = (byte)-1;
    private HashMap<BlockPos, Integer> tankToPriorityMappings;
    private HashSet<BlockPos> tanks;
    private HashSet<BlockPos> tanksBeforeDisband;
    private BasicAStar aStar;
    private EnumFacing facing = EnumFacing.NORTH;

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.internalTank.readFromNBT(tag);
        this.readTankPrioritiesFromNBT(tag);
        this.linkedTankCount = tag.func_74764_b("LinkedTankCount") ? tag.func_74762_e("LinkedTankCount") : Math.max(this.tankPriorities.size() - 1, 0);
        this.tankFacingSides = tag.func_74771_c("TankFacingSides");
        this.facing = EnumFacing.func_82600_a((int)tag.func_74771_c("Facing"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.internalTank.writeToNBT(tag);
        this.writeTankPrioritiesToNBT(tag);
        tag.func_74774_a("TankFacingSides", this.tankFacingSides);
        tag.func_74774_a("Facing", (byte)this.facing.func_176745_a());
        return tag;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74774_a("TankFacingSides", this.tankFacingSides);
        tag.func_74774_a("Facing", (byte)this.facing.func_176745_a());
        tag.func_74768_a("LinkedTankCount", this.linkedTankCount);
        this.internalTank.writeToNBT(tag);
        return tag;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        byte oldTankFacingSides = this.tankFacingSides;
        int oldFacing = this.facing.func_176745_a();
        this.func_145839_a(packet.func_148857_g());
        if (oldTankFacingSides != this.tankFacingSides || oldFacing != this.facing.func_176745_a()) {
            Utils.syncBlockAndRerender(this.field_145850_b, this.field_174879_c);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.properties == null) {
            this.properties = FluidTankProperties.convert((FluidTankInfo[])new FluidTankInfo[]{this.internalTank.getInfo()});
        }
        return this.properties;
    }

    public int fill(FluidStack fillFluid, boolean doFill) {
        if (!this.field_145850_b.field_72995_K && this.hasTanks()) {
            int fillAmount = this.internalTank.fill(fillFluid, doFill);
            if (doFill && fillAmount > 0) {
                this.distributeFluidToTanks();
                Utils.syncBlockAndRerender(this.field_145850_b, this.field_174879_c);
                this.func_70296_d();
            }
            return fillAmount;
        }
        return 0;
    }

    public FluidStack drain(FluidStack drainFluid, boolean doDrain) {
        return this.drain(drainFluid, -1, doDrain);
    }

    public FluidStack drain(int drainAmount, boolean doDrain) {
        return this.drain(null, drainAmount, doDrain);
    }

    private FluidStack drain(FluidStack drainFluid, int drainAmount, boolean doDrain) {
        if (!this.field_145850_b.field_72995_K && this.hasTanks()) {
            FluidStack drainedFluid;
            FluidStack fluidStack = drainFluid != null && drainFluid.isFluidEqual(this.internalTank.getFluid()) ? this.internalTank.drain(drainFluid.amount, doDrain) : (drainedFluid = drainAmount >= 0 ? this.internalTank.drain(drainAmount, doDrain) : null);
            if (doDrain && drainedFluid != null && drainedFluid.amount > 0) {
                this.distributeFluidToTanks();
                Utils.syncBlockAndRerender(this.field_145850_b, this.field_174879_c);
                this.func_70296_d();
            }
            return drainedFluid;
        }
        return null;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        if (facing.func_176740_k() != EnumFacing.Axis.Y) {
            this.facing = facing;
        }
    }

    public int getCapacity() {
        return this.internalTank.getCapacity();
    }

    public int getFluidAmount() {
        return this.internalTank.getFluidAmount();
    }

    public int getRemainingCapacity() {
        return this.internalTank.getRemainingCapacity();
    }

    public int getFluidLuminosity() {
        Fluid fluid;
        FluidStack storedFluid = this.internalTank.getFluid();
        if (storedFluid != null && (fluid = storedFluid.getFluid()) != null) {
            return fluid.getLuminosity();
        }
        return 0;
    }

    public String getLocalizedFluidName() {
        Fluid fluid;
        FluidStack storedFluid = this.internalTank.getFluid();
        if (storedFluid != null && (fluid = storedFluid.getFluid()) != null) {
            return fluid.getLocalizedName(storedFluid);
        }
        return null;
    }

    public FluidStack getFluid() {
        return this.internalTank.getFluid();
    }

    public boolean isFull() {
        return this.internalTank.isFull();
    }

    public int getTankFacingSides() {
        return this.tankFacingSides;
    }

    public void updateTankFacingSides() {
        int sides = 0;
        if (this.isInTankList(this.field_174879_c.func_177968_d())) {
            sides |= ((Integer)Direction.sidesToBitFlagsMappings.get((Object)EnumFacing.SOUTH)).intValue();
        }
        if (this.isInTankList(this.field_174879_c.func_177978_c())) {
            sides |= ((Integer)Direction.sidesToBitFlagsMappings.get((Object)EnumFacing.NORTH)).intValue();
        }
        if (this.isInTankList(this.field_174879_c.func_177974_f())) {
            sides |= ((Integer)Direction.sidesToBitFlagsMappings.get((Object)EnumFacing.EAST)).intValue();
        }
        if (this.isInTankList(this.field_174879_c.func_177976_e())) {
            sides |= ((Integer)Direction.sidesToBitFlagsMappings.get((Object)EnumFacing.WEST)).intValue();
        }
        if (this.isInTankList(this.field_174879_c.func_177984_a())) {
            sides |= ((Integer)Direction.sidesToBitFlagsMappings.get((Object)EnumFacing.UP)).intValue();
        }
        if (this.isInTankList(this.field_174879_c.func_177977_b())) {
            sides |= ((Integer)Direction.sidesToBitFlagsMappings.get((Object)EnumFacing.DOWN)).intValue();
        }
        this.tankFacingSides = (byte)sides;
    }

    public boolean isFacingTank(EnumFacing side) {
        if (side != null) {
            byte flags = ((Integer)Direction.sidesToBitFlagsMappings.get((Object)side)).byteValue();
            return (this.tankFacingSides & flags) == flags;
        }
        return false;
    }

    public boolean hasTanks() {
        return this.linkedTankCount > 0;
    }

    public int getLinkedTankCount() {
        return this.linkedTankCount;
    }

    public void disbandMultiblock() {
        this.disbandMultiblock(false);
    }

    public void disbandMultiblock(boolean suppressBlockUpdates) {
        FluidStack fluidInTank;
        for (BlockPos tankCoords : this.tankPriorities.values()) {
            TankBlockEntity tankEntity = Utils.getTileEntityAt((IBlockAccess)this.field_145850_b, TankBlockEntity.class, tankCoords);
            if (tankEntity == null) continue;
            tankEntity.disconnect(suppressBlockUpdates);
        }
        if (suppressBlockUpdates) {
            this.tanksBeforeDisband = new HashSet();
            this.tanksBeforeDisband.addAll(this.tankPriorities.values());
        }
        FluidStack spilledFluid = (fluidInTank = this.internalTank.getFluid()) != null ? fluidInTank.copy() : null;
        this.tankPriorities.clear();
        this.linkedTankCount = 0;
        this.tankFacingSides = 0;
        this.internalTank.setFluid(null);
        this.internalTank.setCapacity(0);
        if (!suppressBlockUpdates) {
            Utils.syncBlockAndRerender(this.field_145850_b, this.field_174879_c);
            this.func_70296_d();
            if (spilledFluid != null) {
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidSpilledEvent(spilledFluid, this.field_145850_b, this.field_174879_c));
            }
        }
    }

    public void formMultiblock() {
        FluidStack fluid = this.internalTank.getFluid();
        int oldFluidAmount = fluid != null ? fluid.amount : 0;
        this.disbandMultiblock(true);
        this.findAndPrioritizeTanks();
        this.updateOrphanedTanks();
        this.updateTankFacingSides();
        this.internalTank.setFluid(fluid);
        this.distributeFluidToTanks(true);
        this.linkedTankCount = Math.max(this.tankPriorities.size() - 1, 0);
        Utils.syncBlockAndRerender(this.field_145850_b, this.field_174879_c);
        this.func_70296_d();
        if (oldFluidAmount > this.internalTank.getCapacity() && fluid != null) {
            FluidStack spilledFluid = fluid.copy();
            spilledFluid.amount = oldFluidAmount - this.internalTank.getCapacity();
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidSpilledEvent(spilledFluid, this.field_145850_b, this.field_174879_c));
        }
    }

    private void findAndPrioritizeTanks() {
        this.generateTankList();
        this.computeFillPriorities();
        ArrayList<TankBlockEntity> tankEntities = new ArrayList<TankBlockEntity>(this.tankPriorities.size());
        for (BlockPos tankCoords : this.tankPriorities.values()) {
            TankBlockEntity tankEntity = Utils.getTileEntityAt((IBlockAccess)this.field_145850_b, TankBlockEntity.class, tankCoords);
            if (tankEntity == null) continue;
            tankEntity.setValve(this.field_174879_c);
            tankEntities.add(tankEntity);
        }
        for (TankBlockEntity t : tankEntities) {
            t.updateConnections();
        }
        this.internalTank.setCapacity((tankEntities.size() + 1) * Config.bucketsPerTank * 1000);
    }

    private void updateOrphanedTanks() {
        Collection tanksToUpdate = Collections2.filter(this.tanksBeforeDisband, (Predicate)Predicates.not((Predicate)Predicates.in(this.tanks)));
        for (BlockPos tank : tanksToUpdate) {
            TankBlockEntity tankEntity = Utils.getTileEntityAt((IBlockAccess)this.field_145850_b, TankBlockEntity.class, tank);
            if (tankEntity == null) continue;
            Utils.syncBlockAndRerender(this.field_145850_b, tankEntity.func_174877_v());
            tankEntity.func_70296_d();
        }
        this.tanksBeforeDisband.clear();
    }

    private void distributeFluidToTanks() {
        this.distributeFluidToTanks(false);
    }

    private void distributeFluidToTanks(boolean forceBlockUpdates) {
        int amountToDistribute = this.internalTank.getFluidAmount();
        if (amountToDistribute == 0 || amountToDistribute == this.internalTank.getCapacity()) {
            int fillPercentage = amountToDistribute == 0 ? 0 : 100;
            for (BlockPos tankCoords : this.tankPriorities.values()) {
                TankBlockEntity tankEntity = Utils.getTileEntityAt((IBlockAccess)this.field_145850_b, TankBlockEntity.class, tankCoords);
                if (tankEntity == null) continue;
                tankEntity.setFillLevel(Utils.getFluidLevel(fillPercentage), forceBlockUpdates);
            }
        } else {
            int[] priorities = Ints.toArray((Collection)this.tankPriorities.keySet());
            Arrays.sort(priorities);
            Collection tanksToFill = null;
            for (int i = 0; i < priorities.length; ++i) {
                tanksToFill = this.tankPriorities.get((Object)priorities[i]);
                int capacity = tanksToFill.size() * Config.bucketsPerTank * 1000;
                int fillPercentage = MathHelper.func_76125_a((int)((int)Math.ceil((double)amountToDistribute / (double)capacity * 100.0)), (int)0, (int)100);
                for (BlockPos tank : tanksToFill) {
                    TankBlockEntity tankEntity = Utils.getTileEntityAt((IBlockAccess)this.field_145850_b, TankBlockEntity.class, tank);
                    if (tankEntity == null) continue;
                    tankEntity.setFillLevel(Utils.getFluidLevel(fillPercentage), forceBlockUpdates);
                }
                amountToDistribute -= Math.min(capacity, amountToDistribute);
            }
        }
    }

    private void generateTankList() {
        this.tanks = new HashSet();
        ArrayList<Object> currentTanks = new ArrayList<Object>();
        ArrayList<BlockPos> newTanks = new ArrayList<BlockPos>();
        currentTanks.add(this.field_174879_c);
        do {
            for (BlockPos blockPos : currentTanks) {
                ArrayList<BlockPos> adjacentTanks = this.findAdjacentTanks(blockPos);
                for (BlockPos adjacentTank : adjacentTanks) {
                    if (!this.tanks.add(adjacentTank)) continue;
                    newTanks.add(adjacentTank);
                }
            }
            currentTanks.clear();
            currentTanks.addAll(newTanks);
            newTanks.clear();
        } while (currentTanks.size() > 0);
    }

    private void computeFillPriorities() {
        this.aStar = new BasicAStar();
        this.tankToPriorityMappings = new HashMap();
        ArrayList<BlockPos> tanksWithoutLowerTanks = new ArrayList<BlockPos>();
        ArrayList<Object> currentTanks = new ArrayList<Object>();
        HashMap<BlockPos, Integer> tanksToPrioritize = new HashMap<BlockPos, Integer>();
        HashSet<BlockPos> newTanks = new HashSet<BlockPos>();
        HashSet<BlockPos> handledSourceTanks = new HashSet<BlockPos>();
        HashSet<BlockPos> handledSegmentTanks = new HashSet<BlockPos>();
        currentTanks.add(this.field_174879_c);
        int priority = 0;
        do {
            for (BlockPos blockPos : currentTanks) {
                if (handledSegmentTanks.contains(blockPos)) continue;
                ArrayList<BlockPos> lowerTanks = this.getClosestLowestTanks(blockPos);
                if (lowerTanks.get(0) == blockPos) {
                    tanksWithoutLowerTanks.add(blockPos);
                    handledSegmentTanks.addAll(lowerTanks);
                    continue;
                }
                handledSourceTanks.add(blockPos);
                for (BlockPos lowerTank : lowerTanks) {
                    tanksToPrioritize.put(lowerTank, priority);
                    newTanks.addAll(this.getAdjacentTanks(lowerTank, BlockSearchMode.Above));
                }
            }
            for (BlockPos blockPos : tanksWithoutLowerTanks) {
                ArrayList<BlockPos> tanksOnSameHeight;
                if (tanksToPrioritize.containsKey(blockPos) || !Collections.disjoint(tanksOnSameHeight = this.getTanksOnSameHeight(blockPos), handledSourceTanks)) continue;
                for (BlockPos tankOnSameHeight : tanksOnSameHeight) {
                    int adjustedPriority = this.tankToPriorityMappings.containsKey(tankOnSameHeight) ? Math.max(priority, this.tankToPriorityMappings.get(tankOnSameHeight)) : priority;
                    tanksToPrioritize.put(tankOnSameHeight, adjustedPriority);
                    newTanks.addAll(this.getAdjacentTanks(tankOnSameHeight, BlockSearchMode.Above));
                }
            }
            for (Map.Entry entry : tanksToPrioritize.entrySet()) {
                this.setTankPriority((BlockPos)entry.getKey(), (Integer)entry.getValue());
            }
            ++priority;
            tanksWithoutLowerTanks.clear();
            handledSourceTanks.clear();
            handledSegmentTanks.clear();
            tanksToPrioritize.clear();
            currentTanks.clear();
            currentTanks.addAll(newTanks);
            newTanks.clear();
        } while (!currentTanks.isEmpty());
        this.aStar = null;
    }

    private ArrayList<BlockPos> getTanksOnSameHeight(BlockPos startTank) {
        if (startTank == null) {
            return null;
        }
        ArrayList<BlockPos> foundTanks = new ArrayList<BlockPos>();
        ArrayList<Object> currentTanks = new ArrayList<Object>();
        HashSet<BlockPos> handledTanks = new HashSet<BlockPos>();
        HashSet<BlockPos> newTanks = new HashSet<BlockPos>();
        currentTanks.add(startTank);
        do {
            for (BlockPos blockPos : currentTanks) {
                if (blockPos.func_177956_o() == startTank.func_177956_o()) {
                    foundTanks.add(blockPos);
                }
                EnumSet<BlockSearchMode> searchFlags = blockPos.func_177956_o() < startTank.func_177956_o() ? BlockSearchMode.All : BlockSearchMode.SameLevelAndBelow;
                ArrayList<BlockPos> adjacentTanks = this.getAdjacentTanks(blockPos, searchFlags);
                for (BlockPos adjacentTank : adjacentTanks) {
                    if (handledTanks.contains(adjacentTank)) continue;
                    newTanks.add(adjacentTank);
                }
                handledTanks.add(blockPos);
            }
            currentTanks.clear();
            currentTanks.addAll(newTanks);
            newTanks.clear();
        } while (!currentTanks.isEmpty());
        return foundTanks;
    }

    private void setTankPriority(BlockPos tank, int priority) {
        if (tank == null || priority < 0) {
            return;
        }
        Integer oldPriority = this.tankToPriorityMappings.put(tank, priority);
        if (oldPriority == null) {
            this.tankPriorities.put((Object)priority, (Object)tank);
        } else {
            this.tankPriorities.remove((Object)oldPriority, (Object)tank);
            this.tankPriorities.put((Object)priority, (Object)tank);
        }
    }

    private ArrayList<BlockPos> getClosestLowestTanks(BlockPos startTank) {
        if (startTank == null) {
            return null;
        }
        ArrayList<BlockPos> tanksWithTanksBelow = new ArrayList<BlockPos>();
        ArrayList<BlockPos> newTanks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> foundTanks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> currentTanks = new ArrayList<BlockPos>();
        currentTanks.add(startTank);
        do {
            for (BlockPos currentTank : currentTanks) {
                ArrayList<BlockPos> tanksInSegment = this.getTanksInSegment(currentTank);
                for (BlockPos segmentTank : tanksInSegment) {
                    ArrayList<BlockPos> adjacentTanks = this.getAdjacentTanks(segmentTank, BlockSearchMode.Below);
                    if (adjacentTanks.isEmpty() || this.hasPriority(adjacentTanks.get(0))) continue;
                    tanksWithTanksBelow.add(segmentTank);
                }
                if (!tanksWithTanksBelow.isEmpty()) {
                    ArrayList<BlockPos> closestTanksWithTanksBelow = tanksWithTanksBelow.size() > 1 ? this.getClosestTanks(tanksInSegment, tanksWithTanksBelow, currentTank) : tanksWithTanksBelow;
                    for (BlockPos closestTank : closestTanksWithTanksBelow) {
                        newTanks.add(closestTank.func_177977_b());
                    }
                } else {
                    foundTanks.addAll(tanksInSegment);
                }
                tanksWithTanksBelow.clear();
            }
            currentTanks.clear();
            currentTanks.addAll(newTanks);
            newTanks.clear();
        } while (!currentTanks.isEmpty());
        return foundTanks;
    }

    private ArrayList<BlockPos> getClosestTanks(Collection<BlockPos> passableBlocks, Collection<BlockPos> sources, BlockPos destination) {
        if (this.tanks == null || this.tanks.isEmpty() || sources == null || sources.isEmpty() || destination == null) {
            return null;
        }
        ArrayList<Integer> distances = new ArrayList<Integer>();
        ArrayListMultimap distanceToTanksMappings = ArrayListMultimap.create();
        this.aStar.setPassableBlocks(this.tanks);
        for (BlockPos source : sources) {
            int distance = source.equals((Object)destination) ? 0 : this.aStar.getShortestPath((BlockPos)source, (BlockPos)destination).currentCost;
            distances.add(distance);
            distanceToTanksMappings.put((Object)distance, (Object)source);
        }
        Collections.sort(distances);
        return new ArrayList<BlockPos>(distanceToTanksMappings.get(distances.get(0)));
    }

    private ArrayList<BlockPos> getTanksInSegment(BlockPos firstTank) {
        if (firstTank == null) {
            return null;
        }
        LinkedHashSet<BlockPos> foundTanks = new LinkedHashSet<BlockPos>();
        foundTanks.add(firstTank);
        ArrayList<Object> currentTanks = new ArrayList<Object>();
        ArrayList<BlockPos> newTanks = new ArrayList<BlockPos>();
        currentTanks.add(firstTank);
        do {
            for (BlockPos blockPos : currentTanks) {
                ArrayList<BlockPos> adjacentTanks = this.getAdjacentTanks(blockPos, BlockSearchMode.SameLevel);
                for (BlockPos adjacentTank : adjacentTanks) {
                    if (!foundTanks.add(adjacentTank)) continue;
                    newTanks.add(adjacentTank);
                }
            }
            currentTanks.clear();
            currentTanks.addAll(newTanks);
            newTanks.clear();
        } while (!currentTanks.isEmpty());
        return new ArrayList<BlockPos>(foundTanks);
    }

    private ArrayList<BlockPos> getAdjacentTanks(BlockPos block) {
        return this.getOrFindAdjacentTanks(block, null, BlockSearchMode.All, true);
    }

    private ArrayList<BlockPos> getAdjacentTanks(BlockPos block, BlockSearchMode mode) {
        return this.getOrFindAdjacentTanks(block, mode, null, true);
    }

    private ArrayList<BlockPos> getAdjacentTanks(BlockPos block, EnumSet<BlockSearchMode> searchFlags) {
        return this.getOrFindAdjacentTanks(block, null, searchFlags, true);
    }

    private ArrayList<BlockPos> findAdjacentTanks(BlockPos block) {
        return this.getOrFindAdjacentTanks(block, null, BlockSearchMode.All, false);
    }

    private ArrayList<BlockPos> findAdjacentTanks(BlockPos block, BlockSearchMode mode) {
        return this.getOrFindAdjacentTanks(block, mode, null, false);
    }

    private ArrayList<BlockPos> findAdjacentTanks(BlockPos block, EnumSet<BlockSearchMode> searchFlags) {
        return this.getOrFindAdjacentTanks(block, null, searchFlags, false);
    }

    private ArrayList<BlockPos> getOrFindAdjacentTanks(BlockPos block, BlockSearchMode mode, EnumSet<BlockSearchMode> searchFlags, boolean useTankList) {
        if (block == null || mode == null && searchFlags == null) {
            return null;
        }
        ArrayList<BlockPos> foundTanks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> adjacentBlocks = new ArrayList<BlockPos>();
        if (mode == BlockSearchMode.SameLevel || searchFlags != null && searchFlags.contains((Object)BlockSearchMode.SameLevel)) {
            adjacentBlocks.add(block.func_177974_f());
            adjacentBlocks.add(block.func_177976_e());
            adjacentBlocks.add(block.func_177968_d());
            adjacentBlocks.add(block.func_177978_c());
        }
        if (mode == BlockSearchMode.Above || searchFlags != null && searchFlags.contains((Object)BlockSearchMode.Above)) {
            adjacentBlocks.add(block.func_177984_a());
        }
        if (mode == BlockSearchMode.Below || searchFlags != null && searchFlags.contains((Object)BlockSearchMode.Below)) {
            adjacentBlocks.add(block.func_177977_b());
        }
        if (useTankList) {
            for (BlockPos adjacentBlock : adjacentBlocks) {
                if (!this.isInTankList(adjacentBlock)) continue;
                foundTanks.add(adjacentBlock);
            }
        } else {
            for (BlockPos adjacentBlock : adjacentBlocks) {
                if (!this.isUnlinkedTank(adjacentBlock)) continue;
                foundTanks.add(adjacentBlock);
            }
        }
        return foundTanks;
    }

    private boolean isUnlinkedTank(BlockPos block) {
        if (block == null) {
            return false;
        }
        IBlockState state = this.field_145850_b.func_180495_p(block);
        if (state != null) {
            if (state.func_177230_c() instanceof TankBlock) {
                TankBlockEntity tankEntity = Utils.getTileEntityAt((IBlockAccess)this.field_145850_b, TankBlockEntity.class, block);
                if (tankEntity != null) {
                    return !tankEntity.isPartOfTank();
                }
            } else if (block.equals((Object)this.field_174879_c) && this.tankPriorities.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private boolean isInTankList(BlockPos pos) {
        if (pos == null) {
            return false;
        }
        if (this.tanks != null) {
            return this.tanks.contains(pos);
        }
        if (this.tankPriorities != null) {
            return this.tankPriorities.values().contains(pos);
        }
        return false;
    }

    private boolean hasPriority(BlockPos tank) {
        return this.tankPriorities.containsValue((Object)tank);
    }

    private void writeTankPrioritiesToNBT(NBTTagCompound tag) {
        if (tag == null) {
            return;
        }
        NBTTagCompound tankPrioritiesTag = new NBTTagCompound();
        int i = 0;
        for (Map.Entry entry : this.tankPriorities.entries()) {
            BlockPos currentCoords = (BlockPos)entry.getValue();
            int[] serializableEntry = new int[]{(Integer)entry.getKey(), currentCoords.func_177958_n(), currentCoords.func_177956_o(), currentCoords.func_177952_p()};
            tankPrioritiesTag.func_74783_a(Integer.toString(i), serializableEntry);
            ++i;
        }
        tag.func_74782_a("TankPriorities", (NBTBase)tankPrioritiesTag);
    }

    private void readTankPrioritiesFromNBT(NBTTagCompound tag) {
        if (tag != null) {
            String key;
            this.tankPriorities = ArrayListMultimap.create();
            NBTTagCompound tankPrioritiesTag = tag.func_74775_l("TankPriorities");
            int i = 0;
            while (tankPrioritiesTag.func_74764_b(key = Integer.toString(i))) {
                int[] serializedEntry = tankPrioritiesTag.func_74759_k(key);
                this.tankPriorities.put((Object)serializedEntry[0], (Object)new BlockPos(serializedEntry[1], serializedEntry[2], serializedEntry[3]));
                ++i;
            }
        }
    }
}

