/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.rendering;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.zarathul.simplefluidtanks.blocks.TankBlock;

public class BakedTankModel
implements IBakedModel {
    public static final int FLUID_LEVELS = 16;
    public static final HashMap<String, IBakedModel[]> FLUID_MODELS = new HashMap();
    private IBakedModel baseModel;

    public BakedTankModel(IBakedModel baseModel) {
        this.baseModel = baseModel;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        if (MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.CUTOUT_MIPPED) {
            quads.addAll(this.baseModel.func_188616_a(state, side, rand));
        } else if (MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.TRANSLUCENT) {
            IExtendedBlockState exState = (IExtendedBlockState)state;
            boolean cullFluidTop = (Boolean)exState.getValue(TankBlock.CullFluidTop);
            int fluidLevel = (Integer)exState.getValue(TankBlock.FluidLevel);
            String fluidName = (String)exState.getValue(TankBlock.FluidName);
            if ((side != null && side != EnumFacing.UP || side == null && !cullFluidTop) && fluidLevel > 0 && fluidLevel <= 16 && FLUID_MODELS.containsKey(fluidName)) {
                IBakedModel fluidModel = FLUID_MODELS.get(fluidName)[fluidLevel - 1];
                quads.addAll(fluidModel.func_188616_a(null, side, rand));
            }
        }
        return quads;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return this.baseModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.baseModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.baseModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return null;
    }
}

