/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.rendering;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class BakedTankFluidModel
implements IBakedModel {
    private static final float offset = 5.0E-5f;
    private static final float[] x = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
    private static final float[] z = new float[]{0.0f, 1.0f, 1.0f, 0.0f};
    private Fluid fluid;
    private int level;
    private VertexFormat format;
    private EnumMap<EnumFacing, List<BakedQuad>> faceQuads;

    public BakedTankFluidModel(Fluid fluid, int level) {
        float Z;
        float X;
        int i;
        EnumFacing side2;
        this.fluid = fluid;
        this.level = level;
        this.format = DefaultVertexFormats.field_176599_b;
        this.faceQuads = Maps.newEnumMap(EnumFacing.class);
        for (EnumFacing side2 : EnumFacing.values()) {
            this.faceQuads.put(side2, (List<BakedQuad>)ImmutableList.of());
        }
        float[] y = new float[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            y[i2] = Math.min((float)level / 16.0f, 0.99995f);
        }
        TextureAtlasSprite texture = this.func_177554_e();
        side2 = EnumFacing.UP;
        UnpackedBakedQuad.Builder quadBuilder = new UnpackedBakedQuad.Builder(this.format);
        quadBuilder.setQuadOrientation(side2);
        quadBuilder.setTexture(texture);
        for (i = 0; i < 4; ++i) {
            X = Math.min(Math.max(x[i], 5.0E-5f), 0.99995f);
            Z = Math.min(Math.max(z[i], 5.0E-5f), 0.99995f);
            this.putVertex(quadBuilder, side2, X, y[i] - 5.0E-5f, Z, texture.func_94214_a((double)(x[i] * 16.0f)), texture.func_94207_b((double)(z[i] * 16.0f)));
        }
        this.faceQuads.put(side2, (List<BakedQuad>)ImmutableList.of((Object)quadBuilder.build()));
        side2 = EnumFacing.DOWN;
        quadBuilder = new UnpackedBakedQuad.Builder(this.format);
        quadBuilder.setQuadOrientation(side2);
        quadBuilder.setTexture(texture);
        for (i = 0; i < 4; ++i) {
            X = Math.min(Math.max(x[i], 5.0E-5f), 0.99995f);
            Z = Math.min(Math.max(z[i], 5.0E-5f), 0.99995f);
            this.putVertex(quadBuilder, side2, Z, 5.0E-5f, X, texture.func_94214_a((double)(z[i] * 16.0f)), texture.func_94207_b((double)(x[i] * 16.0f)));
        }
        this.faceQuads.put(side2, (List<BakedQuad>)ImmutableList.of((Object)quadBuilder.build()));
        side2 = EnumFacing.EAST;
        quadBuilder = new UnpackedBakedQuad.Builder(this.format);
        quadBuilder.setQuadOrientation(side2);
        quadBuilder.setTexture(texture);
        this.putVertex(quadBuilder, side2, x[2] - 5.0E-5f, y[2], z[2], texture.func_94214_a(0.0), texture.func_94207_b((double)(16 - level)));
        this.putVertex(quadBuilder, side2, x[2] - 5.0E-5f, 5.0E-5f, z[2], texture.func_94214_a(0.0), texture.func_94207_b(16.0));
        this.putVertex(quadBuilder, side2, x[3] - 5.0E-5f, 5.0E-5f, z[3], texture.func_94214_a(16.0), texture.func_94207_b(16.0));
        this.putVertex(quadBuilder, side2, x[3] - 5.0E-5f, y[3], z[3], texture.func_94214_a(16.0), texture.func_94207_b((double)(16 - level)));
        this.faceQuads.put(side2, (List<BakedQuad>)ImmutableList.of((Object)quadBuilder.build()));
        side2 = EnumFacing.WEST;
        quadBuilder = new UnpackedBakedQuad.Builder(this.format);
        quadBuilder.setQuadOrientation(side2);
        quadBuilder.setTexture(texture);
        this.putVertex(quadBuilder, side2, x[0] + 5.0E-5f, y[0], z[0], texture.func_94214_a(0.0), texture.func_94207_b((double)(16 - level)));
        this.putVertex(quadBuilder, side2, x[0] + 5.0E-5f, 5.0E-5f, z[0], texture.func_94214_a(0.0), texture.func_94207_b(16.0));
        this.putVertex(quadBuilder, side2, x[1] + 5.0E-5f, 5.0E-5f, z[1], texture.func_94214_a(16.0), texture.func_94207_b(16.0));
        this.putVertex(quadBuilder, side2, x[1] + 5.0E-5f, y[1], z[1], texture.func_94214_a(16.0), texture.func_94207_b((double)(16 - level)));
        this.faceQuads.put(side2, (List<BakedQuad>)ImmutableList.of((Object)quadBuilder.build()));
        side2 = EnumFacing.SOUTH;
        quadBuilder = new UnpackedBakedQuad.Builder(this.format);
        quadBuilder.setQuadOrientation(side2);
        quadBuilder.setTexture(texture);
        this.putVertex(quadBuilder, side2, x[1], y[1], z[1] - 5.0E-5f, texture.func_94214_a(0.0), texture.func_94207_b((double)(16 - level)));
        this.putVertex(quadBuilder, side2, x[1], 5.0E-5f, z[1] - 5.0E-5f, texture.func_94214_a(0.0), texture.func_94207_b(16.0));
        this.putVertex(quadBuilder, side2, x[2], 5.0E-5f, z[2] - 5.0E-5f, texture.func_94214_a(16.0), texture.func_94207_b(16.0));
        this.putVertex(quadBuilder, side2, x[2], y[2], z[2] - 5.0E-5f, texture.func_94214_a(16.0), texture.func_94207_b((double)(16 - level)));
        this.faceQuads.put(side2, (List<BakedQuad>)ImmutableList.of((Object)quadBuilder.build()));
        side2 = EnumFacing.NORTH;
        quadBuilder = new UnpackedBakedQuad.Builder(this.format);
        quadBuilder.setQuadOrientation(side2);
        quadBuilder.setTexture(texture);
        this.putVertex(quadBuilder, side2, x[3], y[3], z[3] + 5.0E-5f, texture.func_94214_a(0.0), texture.func_94207_b((double)(16 - level)));
        this.putVertex(quadBuilder, side2, x[3], 5.0E-5f, z[3] + 5.0E-5f, texture.func_94214_a(0.0), texture.func_94207_b(16.0));
        this.putVertex(quadBuilder, side2, x[0], 5.0E-5f, z[0] + 5.0E-5f, texture.func_94214_a(16.0), texture.func_94207_b(16.0));
        this.putVertex(quadBuilder, side2, x[0], y[0], z[0] + 5.0E-5f, texture.func_94214_a(16.0), texture.func_94207_b((double)(16 - level)));
        this.faceQuads.put(side2, (List<BakedQuad>)ImmutableList.of((Object)quadBuilder.build()));
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side != null) {
            return this.faceQuads.get(side);
        }
        return this.faceQuads.get(EnumFacing.UP);
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        String fluidTextureLoc = this.fluid.getStill() != null ? this.fluid.getStill().toString() : (this.fluid.getFlowing() != null ? this.fluid.getFlowing().toString() : FluidRegistry.WATER.getStill().toString());
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidTextureLoc);
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    private void putVertex(UnpackedBakedQuad.Builder builder, EnumFacing side, float x, float y, float z, float u, float v) {
        block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
            switch (this.format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    float[] data = new float[]{x, y, z};
                    builder.put(e, data);
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{(float)(this.fluid.getColor() >> 16 & 0xFF) / 255.0f, (float)(this.fluid.getColor() >> 8 & 0xFF) / 255.0f, (float)(this.fluid.getColor() & 0xFF) / 255.0f, (float)(this.fluid.getColor() >> 24 & 0xFF) / 255.0f});
                    continue block6;
                }
                case UV: {
                    if (this.format.func_177348_c(e).func_177369_e() == 0) {
                        builder.put(e, new float[]{u, v});
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(e, new float[]{side.func_82601_c(), side.func_96559_d(), side.func_82599_e(), 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }
}

