/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.registration;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.zarathul.simplefluidtanks.SimpleFluidTanks;
import net.zarathul.simplefluidtanks.blocks.TankBlock;
import net.zarathul.simplefluidtanks.blocks.ValveBlock;
import net.zarathul.simplefluidtanks.configuration.Config;
import net.zarathul.simplefluidtanks.configuration.Recipe;
import net.zarathul.simplefluidtanks.items.TankItem;
import net.zarathul.simplefluidtanks.items.ValveItem;
import net.zarathul.simplefluidtanks.items.WrenchItem;
import net.zarathul.simplefluidtanks.tileentities.TankBlockEntity;
import net.zarathul.simplefluidtanks.tileentities.ValveBlockEntity;

public final class Registry {
    public static final String TANK_BLOCK_NAME = "tankBlock";
    public static final String TANK_ITEM_NAME = "tankItem";
    public static final String VALVE_BLOCK_NAME = "valveBlock";
    public static final String VALVE_ITEM_NAME = "valveItem";
    public static final String WRENCH_ITEM_NAME = "wrench";
    private static final String TANKBLOCK_ENTITY_NAME = "tankBlockEntity";
    private static final String TANKBLOCK_ENTITY_KEY = "simplefluidtanks:tankBlockEntity";
    private static final String VALVEBLOCK_ENTITY_NAME = "valveBlockEntity";
    private static final String VALVEBLOCK_ENTITY_KEY = "simplefluidtanks:valveBlockEntity";
    private static final String TANKITEM_MODEL_RESLOC = "simplefluidtanks:tankBlock";
    private static final String VALVEITEM_MODEL_RESLOC = "simplefluidtanks:valveBlock";
    private static final String WRENCHITEM_MODEL_RESLOC = "simplefluidtanks:wrench";

    public static void registerBlocks() {
        SimpleFluidTanks.tankBlock = new TankBlock();
        GameRegistry.register((IForgeRegistryEntry)SimpleFluidTanks.tankBlock);
        SimpleFluidTanks.valveBlock = new ValveBlock();
        GameRegistry.register((IForgeRegistryEntry)SimpleFluidTanks.valveBlock);
        GameRegistry.registerTileEntity(TankBlockEntity.class, (String)TANKBLOCK_ENTITY_KEY);
        GameRegistry.registerTileEntity(ValveBlockEntity.class, (String)VALVEBLOCK_ENTITY_KEY);
    }

    public static void registerItems() {
        SimpleFluidTanks.tankItem = new TankItem(SimpleFluidTanks.tankBlock);
        GameRegistry.register((IForgeRegistryEntry)SimpleFluidTanks.tankItem);
        SimpleFluidTanks.valveItem = new ValveItem(SimpleFluidTanks.valveBlock);
        GameRegistry.register((IForgeRegistryEntry)SimpleFluidTanks.valveItem);
        if (Config.wrenchEnabled) {
            SimpleFluidTanks.wrenchItem = new WrenchItem();
            GameRegistry.register((IForgeRegistryEntry)SimpleFluidTanks.wrenchItem);
        }
    }

    public static void registerItemModels() {
        ModelLoader.setCustomModelResourceLocation((Item)SimpleFluidTanks.tankItem, (int)0, (ModelResourceLocation)new ModelResourceLocation(TANKITEM_MODEL_RESLOC, "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)SimpleFluidTanks.valveItem, (int)0, (ModelResourceLocation)new ModelResourceLocation(VALVEITEM_MODEL_RESLOC, "inventory"));
        if (Config.wrenchEnabled) {
            ModelLoader.setCustomModelResourceLocation((Item)SimpleFluidTanks.wrenchItem, (int)0, (ModelResourceLocation)new ModelResourceLocation(WRENCHITEM_MODEL_RESLOC, "inventory"));
        }
    }

    public static final void registerWithWaila() {
        FMLInterModComms.sendMessage((String)"waila", (String)"register", (String)"net.zarathul.simplefluidtanks.waila.WailaRegistry.register");
    }

    public static final void registerRecipes() {
        ItemStack tankBlockRecipeResult = new ItemStack((Block)SimpleFluidTanks.tankBlock);
        ItemStack valveBlockRecipeResult = new ItemStack((Block)SimpleFluidTanks.valveBlock);
        Registry.registerRecipeWithAlternative(tankBlockRecipeResult, Config.tankBlockRecipe, Config.defaultTankBlockRecipe);
        Registry.registerRecipeWithAlternative(valveBlockRecipeResult, Config.valveBlockRecipe, Config.defaultValveBlockRecipe);
        if (Config.wrenchEnabled) {
            ItemStack wrenchRecipeResult = new ItemStack((Item)SimpleFluidTanks.wrenchItem);
            Registry.registerRecipeWithAlternative(wrenchRecipeResult, Config.wrenchRecipe, Config.defaultWrenchRecipe);
        }
    }

    private static final void registerRecipeWithAlternative(ItemStack result, Recipe recipe, Recipe defaultRecipe) {
        if (!Registry.registerRecipe(result, recipe)) {
            SimpleFluidTanks.log.warn(String.format("Failed to register recipe for '%s'. Check your config file.", result.func_77973_b().getRegistryName()));
            if (!Registry.registerRecipe(result, defaultRecipe)) {
                SimpleFluidTanks.log.error(String.format("Failed to register default recipe for '%s'. This should never happen.", result.func_77973_b().getRegistryName()));
            }
        }
    }

    private static final boolean registerRecipe(ItemStack result, Recipe recipe) {
        try {
            Object[] registrationArgs = recipe.getRegistrationArgs();
            if (registrationArgs != null && recipe.yield > 0) {
                result.func_190920_e(recipe.yield);
                if (recipe.isShapeless) {
                    GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(result, registrationArgs));
                } else {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result, new Object[]{false, registrationArgs}));
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static final void addCreativeTab() {
        SimpleFluidTanks.creativeTab = Arrays.stream(CreativeTabs.field_78032_a).filter(tab -> tab.func_78013_b().equals("Simple Mods")).findFirst().orElseGet(() -> new CreativeTabs("Simple Mods"){
            private ItemStack iconStack;

            public String func_78024_c() {
                return this.func_78013_b();
            }

            public ItemStack func_78016_d() {
                if (this.iconStack == null) {
                    this.iconStack = new ItemStack((Item)SimpleFluidTanks.valveItem);
                }
                return this.iconStack;
            }
        });
    }
}

