/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.configuration;

import java.io.File;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.zarathul.simplefluidtanks.configuration.Recipe;
import net.zarathul.simplefluidtanks.configuration.RecipeComponent;
import net.zarathul.simplefluidtanks.configuration.RecipePattern;

public final class Config {
    private static Configuration config = null;
    public static final Recipe defaultTankBlockRecipe = new Recipe(2, new RecipePattern("IGI", String.format("G%sG", Character.valueOf('-')), "IGI"), new RecipeComponent[]{new RecipeComponent("I", "oreDict", "ingotIron"), new RecipeComponent("G", "oreDict", "blockGlass")});
    public static final Recipe defaultValveBlockRecipe = new Recipe(1, new RecipePattern("ISI", "STS", "ISI"), new RecipeComponent[]{new RecipeComponent("I", "oreDict", "ingotIron"), new RecipeComponent("S", "oreDict", "slimeball"), new RecipeComponent("T", "simplefluidtanks", "tankItem")});
    public static final Recipe defaultWrenchRecipe = new Recipe(1, new RecipePattern(String.format("%1$sI%1$s", Character.valueOf('-')), String.format("%sII", Character.valueOf('-')), String.format("I%1$s%1$s", Character.valueOf('-'))), new RecipeComponent[]{new RecipeComponent("I", "oreDict", "ingotIron")});
    private static final int defaultBucketsPerTank = 32;
    private static final boolean defaultWrenchEnabled = true;
    private static final float defaultTankBlockHardness = 50.0f;
    private static final float defaultTankBlockResistance = 1000.0f;
    private static final float defaultValveBlockHardness = 50.0f;
    private static final float defaultValveBlockResistance = 1000.0f;
    public static int bucketsPerTank;
    public static boolean wrenchEnabled;
    public static float tankBlockHardness;
    public static float tankBlockResistance;
    public static float valveBlockHardness;
    public static float valveBlockResistance;
    public static Recipe tankBlockRecipe;
    public static Recipe valveBlockRecipe;
    public static Recipe wrenchRecipe;
    public static final String CATEGORY_MISC = "general.misc";
    public static final String CATEGORY_BLOCKS = "general.blocks";
    public static final String CATEGORY_RECIPES = "general.recipes";
    private static final String CATEGORY_BLOCKS_TANKBLOCK = "general.blocks.tank";
    private static final String CATEGORY_BLOCKS_VALVEBLOCK = "general.blocks.valve";
    private static final String CATEGORY_RECIPES_TANKBLOCK = "general.recipes.tank";
    private static final String CATEGORY_RECIPES_VALVEBLOCK = "general.recipes.valve";
    private static final String CATEGORY_RECIPES_WRENCH = "general.recipes.wrench";

    public static final Configuration getConfig() {
        return config;
    }

    public static final void load(File configFile) {
        config = new Configuration(configFile);
        config.load();
        Config.sync();
    }

    public static void sync() {
        config.getCategory(CATEGORY_MISC).setLanguageKey("configui.category.misc").setComment(I18n.func_74838_a((String)"configui.category.misc.tooltip"));
        Property prop = config.get(CATEGORY_MISC, "bucketsPerTank", 32);
        prop.setComment(I18n.func_74838_a((String)"configui.bucketsPerTank.tooltip"));
        prop.setLanguageKey("configui.bucketsPerTank").setRequiresWorldRestart(true).setMinValue(1);
        bucketsPerTank = prop.getInt();
        prop = config.get(CATEGORY_MISC, "wrenchEnabled", true);
        prop.setComment(I18n.func_74838_a((String)"configui.wrenchEnabled.tooltip"));
        prop.setLanguageKey("configui.wrenchEnabled").setRequiresMcRestart(true);
        wrenchEnabled = prop.getBoolean();
        config.getCategory(CATEGORY_BLOCKS).setLanguageKey("configui.category.blocks").setComment(I18n.func_74838_a((String)"configui.category.blocks.tooltip"));
        config.getCategory(CATEGORY_BLOCKS_TANKBLOCK).setLanguageKey("configui.category.tank");
        config.getCategory(CATEGORY_BLOCKS_VALVEBLOCK).setLanguageKey("configui.category.valve");
        String blockHardnessKey = "hardness";
        String blockResistanceKey = "resistance";
        String blockHardnessComment = I18n.func_74838_a((String)"configui.blockHardness.tooltip");
        String blockResistanceComment = I18n.func_74838_a((String)"configui.blockResistance.tooltip");
        prop = config.get(CATEGORY_BLOCKS_TANKBLOCK, blockHardnessKey, 50.0, blockHardnessComment);
        prop.setLanguageKey("configui.blockHardness").setRequiresMcRestart(true).setMinValue(-1.0).setMaxValue(1000000.0);
        tankBlockHardness = (float)prop.getDouble();
        prop = config.get(CATEGORY_BLOCKS_TANKBLOCK, blockResistanceKey, 1000.0, blockResistanceComment);
        prop.setLanguageKey("configui.blockResistance").setRequiresMcRestart(true).setMinValue(1.0).setMaxValue(1000000.0);
        tankBlockResistance = (float)prop.getDouble();
        prop = config.get(CATEGORY_BLOCKS_VALVEBLOCK, blockHardnessKey, 50.0, blockHardnessComment);
        prop.setLanguageKey("configui.blockHardness").setRequiresMcRestart(true).setMinValue(-1.0).setMaxValue(1000000.0);
        valveBlockHardness = (float)prop.getDouble();
        prop = config.get(CATEGORY_BLOCKS_VALVEBLOCK, blockResistanceKey, 1000.0, blockResistanceComment);
        prop.setLanguageKey("configui.blockResistance").setRequiresMcRestart(true).setMinValue(1.0).setMaxValue(1000000.0);
        valveBlockResistance = (float)prop.getDouble();
        config.getCategory(CATEGORY_RECIPES).setLanguageKey("configui.category.recipes").setComment(I18n.func_74838_a((String)"configui.category.recipes.tooltip"));
        config.getCategory(CATEGORY_RECIPES_TANKBLOCK).setLanguageKey("configui.category.tank");
        config.getCategory(CATEGORY_RECIPES_VALVEBLOCK).setLanguageKey("configui.category.valve");
        config.getCategory(CATEGORY_RECIPES_WRENCH).setLanguageKey("configui.category.wrench");
        tankBlockRecipe = Config.loadRecipe(config, CATEGORY_RECIPES_TANKBLOCK, defaultTankBlockRecipe);
        valveBlockRecipe = Config.loadRecipe(config, CATEGORY_RECIPES_VALVEBLOCK, defaultValveBlockRecipe);
        wrenchRecipe = Config.loadRecipe(config, CATEGORY_RECIPES_WRENCH, defaultWrenchRecipe);
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static Recipe loadRecipe(Configuration config, String category, Recipe defaultRecipe) {
        Property prop = config.get(category, "shapeless", defaultRecipe.isShapeless);
        prop.setComment(I18n.func_74838_a((String)"configui.shapeless.tooltip"));
        prop.setLanguageKey("configui.shapeless").setRequiresMcRestart(true);
        boolean shapeless = prop.getBoolean();
        prop = config.get(category, "yield", defaultRecipe.yield);
        prop.setComment(I18n.func_74838_a((String)"configui.yield.tooltip"));
        prop.setLanguageKey("configui.yield").setRequiresMcRestart(true).setMinValue(1).setMaxValue(64);
        int yield = prop.getInt();
        prop = config.get(category, "components", defaultRecipe.getComponentList());
        prop.setComment(I18n.func_74838_a((String)"configui.components.tooltip"));
        prop.setLanguageKey("configui.components").setRequiresMcRestart(true).setMaxListLength(27);
        String[] components = prop.getStringList();
        prop = config.get(category, "pattern", (String[])defaultRecipe.pattern.rows.toArray((Object[])new String[0])).setIsListLengthFixed(true).setMaxListLength(3);
        prop.setComment(I18n.func_74838_a((String)"configui.pattern.tooltip"));
        prop.setLanguageKey("configui.pattern").setRequiresMcRestart(true);
        String[] pattern = prop.getStringList();
        return new Recipe(yield, shapeless ? null : new RecipePattern(pattern), Recipe.toComponents(components));
    }
}

