/*
 * Decompiled with CFR 0.152.
 */
package net.zarathul.simplefluidtanks.blocks;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class FluidTank
implements IFluidTank {
    protected FluidStack fluid;
    protected int capacity;

    public FluidTank(int capacity) {
        this(null, capacity);
    }

    public FluidTank(FluidStack stack, int capacity) {
        this.setCapacity(capacity);
        this.setFluid(stack);
    }

    public FluidTank(Fluid fluid, int amount, int capacity) {
        this(new FluidStack(fluid, amount), capacity);
    }

    public FluidTank readFromNBT(NBTTagCompound nbt) {
        this.setCapacity(nbt.func_74762_e("Capacity"));
        FluidStack loadedFluid = nbt.func_74764_b("Empty") ? null : FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
        this.setFluid(loadedFluid);
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Capacity", this.capacity);
        if (this.fluid != null) {
            this.fluid.writeToNBT(nbt);
        } else {
            nbt.func_74778_a("Empty", "");
        }
        return nbt;
    }

    public void setFluid(FluidStack fluid) {
        if (fluid != null) {
            fluid.amount = Math.min(fluid.amount, this.capacity);
        }
        this.fluid = fluid;
    }

    public void setCapacity(int capacity) {
        int n = this.capacity = capacity >= 0 ? capacity : 0;
        if (this.fluid != null) {
            this.fluid.amount = Math.min(this.capacity, this.fluid.amount);
        }
    }

    public int getRemainingCapacity() {
        return this.getCapacity() - this.getFluidAmount();
    }

    public boolean isFull() {
        return this.getRemainingCapacity() == 0;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        return this.fluid != null ? this.fluid.amount : 0;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack fillFluid, boolean doFill) {
        if (fillFluid == null) {
            return 0;
        }
        if (this.fluid == null) {
            if (!doFill) {
                return Math.min(this.capacity, fillFluid.amount);
            }
            this.fluid = new FluidStack(fillFluid, Math.min(this.capacity, fillFluid.amount));
            return this.fluid.amount;
        }
        if (!this.fluid.isFluidEqual(fillFluid)) {
            return 0;
        }
        int fillAmount = Math.min(this.capacity - this.fluid.amount, fillFluid.amount);
        if (doFill && fillAmount > 0) {
            this.fluid.amount += fillAmount;
        }
        return fillAmount;
    }

    public FluidStack drain(int drainAmount, boolean doDrain) {
        if (this.fluid == null) {
            return null;
        }
        if (this.fluid.amount < drainAmount) {
            drainAmount = this.fluid.amount;
        }
        FluidStack drainedFluid = new FluidStack(this.fluid, drainAmount);
        if (doDrain) {
            this.fluid.amount -= drainAmount;
            if (this.fluid.amount == 0) {
                this.fluid = null;
            }
        }
        return drainedFluid;
    }
}

