/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item.tool;

import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.item.tool.ItemToolRF;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ItemShovelRF
extends ItemToolRF {
    int range = 5;

    public ItemShovelRF(Item.ToolMaterial toolMaterial) {
        super(-3.0f, toolMaterial);
        this.addToolClass("shovel");
        this.damage = 3;
        this.energyPerUseCharged = 800;
        this.field_150914_c.addAll((Collection)ItemSpade.field_150916_c);
        this.effectiveMaterials.add((Object)Material.field_151578_c);
        this.effectiveMaterials.add((Object)Material.field_151577_b);
        this.effectiveMaterials.add((Object)Material.field_151595_p);
        this.effectiveMaterials.add((Object)Material.field_151597_y);
        this.effectiveMaterials.add((Object)Material.field_151596_z);
        this.effectiveMaterials.add((Object)Material.field_151571_B);
    }

    protected boolean hoeBlock(World world, int x, int y, int z, int hitSide, EntityPlayer player) {
        if (hitSide == 0) {
            return false;
        }
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (world.func_175623_d(pos.func_177984_a())) {
            if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                world.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (ServerHelper.isServerWorld((World)world)) {
                    world.func_175656_a(pos, Blocks.field_150458_ak.func_176223_P());
                }
                return true;
            }
            if (block == Blocks.field_150346_d) {
                switch ((BlockDirt.DirtType)state.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                    case DIRT: {
                        if (ServerHelper.isServerWorld((World)world)) {
                            world.func_175656_a(pos, Blocks.field_150458_ak.func_176223_P());
                        }
                        return true;
                    }
                    case COARSE_DIRT: {
                        if (ServerHelper.isServerWorld((World)world)) {
                            world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected boolean makePath(World world, int x, int y, int z, int hitSide, EntityPlayer player) {
        if (hitSide == 0) {
            return false;
        }
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (world.func_175623_d(pos.func_177984_a()) && block == Blocks.field_150349_c) {
            world.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (ServerHelper.isServerWorld((World)world)) {
                world.func_180501_a(pos, Blocks.field_185774_da.func_176223_P(), 11);
            }
            return true;
        }
        return false;
    }

    protected Block getBlockFromPos(World world, int x, int y, int z) {
        return world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean check) {
        super.func_77624_a(stack, player, list, check);
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        list.add(StringHelper.getFlavorText((String)"info.redstonearsenal.tool.shovel"));
    }

    public boolean func_150897_b(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150431_aC ? true : state.func_177230_c() == Blocks.field_150433_aE;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        if ((double)state.func_185887_b(world, pos) == 0.0) {
            return false;
        }
        Block block = state.func_177230_c();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (this.getEffectiveBlocks(stack).contains((Object)block) && this.isEmpowered(stack)) {
            int facing = MathHelper.floor((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            switch (facing) {
                case 0: {
                    for (int i = ++z; i < z + this.range && this.getEffectiveBlocks(stack).contains((Object)this.getBlockFromPos(world, x, y, i)) && this.harvestBlock(world, new BlockPos(x, y, i), player); ++i) {
                    }
                    break;
                }
                case 1: {
                    for (int i = --x; i > x - this.range && this.getEffectiveBlocks(stack).contains((Object)this.getBlockFromPos(world, i, y, z)) && this.harvestBlock(world, new BlockPos(i, y, z), player); --i) {
                    }
                    break;
                }
                case 2: {
                    for (int i = --z; i > z - this.range && this.getEffectiveBlocks(stack).contains((Object)this.getBlockFromPos(world, x, y, i)) && this.harvestBlock(world, new BlockPos(x, y, i), player); --i) {
                    }
                    break;
                }
                case 3: {
                    for (int i = ++x; i < x + this.range && this.getEffectiveBlocks(stack).contains((Object)this.getBlockFromPos(world, i, y, z)) && this.harvestBlock(world, new BlockPos(i, y, z), player); ++i) {
                    }
                    break;
                }
            }
        }
        if (!player.field_71075_bZ.field_75098_d) {
            this.useEnergy(stack, false);
        }
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumActionResult used;
        ItemStack stack;
        block28: {
            block27: {
                stack = player.func_184586_b(hand);
                if (!player.func_175151_a(pos, facing, stack) || !player.field_71075_bZ.field_75098_d && this.getEnergyStored(stack) < this.getEnergyPerUse(stack)) {
                    return EnumActionResult.FAIL;
                }
                used = EnumActionResult.FAIL;
                if (!player.func_70093_af()) break block27;
                UseHoeEvent event = new UseHoeEvent(player, stack, worldIn, pos);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    return EnumActionResult.FAIL;
                }
                if (event.getResult() == Event.Result.ALLOW) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        this.useEnergy(stack, false);
                    }
                    return EnumActionResult.SUCCESS;
                }
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                int effRange = 1;
                if (this.isEmpowered(stack)) {
                    effRange = this.range;
                }
                int hitVec = MathHelper.floor((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                block0 : switch (hitVec) {
                    case 0: {
                        for (int i = z; i < z + effRange; ++i) {
                            if (!this.hoeBlock(worldIn, x, y, i, facing.ordinal(), player)) break block0;
                            used = EnumActionResult.SUCCESS;
                        }
                        break block28;
                    }
                    case 1: {
                        for (int i = x; i > x - effRange; --i) {
                            if (!this.hoeBlock(worldIn, i, y, z, facing.ordinal(), player)) break block0;
                            used = EnumActionResult.SUCCESS;
                        }
                        break block28;
                    }
                    case 2: {
                        for (int i = z; i > z - effRange; --i) {
                            if (!this.hoeBlock(worldIn, x, y, i, facing.ordinal(), player)) break block0;
                            used = EnumActionResult.SUCCESS;
                        }
                        break block28;
                    }
                    case 3: {
                        for (int i = x; i < x + effRange && this.hoeBlock(worldIn, i, y, z, facing.ordinal(), player); ++i) {
                            used = EnumActionResult.SUCCESS;
                        }
                        break;
                    }
                }
                break block28;
            }
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            int effRange = 1;
            if (this.isEmpowered(stack)) {
                effRange = this.range;
            }
            int hitVec = MathHelper.floor((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            switch (hitVec) {
                case 0: {
                    for (int i = z; i < z + effRange && this.makePath(worldIn, x, y, i, facing.ordinal(), player); ++i) {
                        used = EnumActionResult.SUCCESS;
                    }
                    break;
                }
                case 1: {
                    for (int i = x; i > x - effRange && this.makePath(worldIn, i, y, z, facing.ordinal(), player); --i) {
                        used = EnumActionResult.SUCCESS;
                    }
                    break;
                }
                case 2: {
                    for (int i = z; i > z - effRange && this.makePath(worldIn, x, y, i, facing.ordinal(), player); --i) {
                        used = EnumActionResult.SUCCESS;
                    }
                    break;
                }
                case 3: {
                    for (int i = x; i < x + effRange && this.makePath(worldIn, i, y, z, facing.ordinal(), player); ++i) {
                        used = EnumActionResult.SUCCESS;
                    }
                    break;
                }
            }
        }
        if (used == EnumActionResult.SUCCESS && !player.field_71075_bZ.field_75098_d) {
            this.useEnergy(stack, false);
        }
        return used;
    }
}

