/*
 * Decompiled with CFR 0.152.
 */
package optifine.xdelta;

import optifine.xdelta.BitArray;

public class EratosthenesPrimes {
    static BitArray sieve;
    static int lastInit;

    static {
        lastInit = -1;
    }

    public static synchronized void reset() {
        sieve = null;
        lastInit = -1;
    }

    public static synchronized void init(int maxNumber) {
        if (maxNumber <= lastInit) {
            return;
        }
        int sqrt = (int)Math.ceil(Math.sqrt(maxNumber));
        lastInit = maxNumber;
        maxNumber >>= 1;
        sqrt >>= 1;
        ++sqrt;
        sieve = new BitArray(++maxNumber + 1);
        sieve.set(0, true);
        int i2 = 1;
        while (i2 <= sqrt) {
            if (!sieve.get(i2)) {
                int currentPrime = (i2 << 1) + 1;
                int j2 = i2 * ((i2 << 1) + 2);
                while (j2 <= maxNumber) {
                    sieve.set(j2, true);
                    j2 += currentPrime;
                }
            }
            ++i2;
        }
    }

    public static synchronized int[] getPrimes(int maxNumber) {
        int primesNo = EratosthenesPrimes.primesCount(maxNumber);
        if (primesNo <= 0) {
            return new int[0];
        }
        if (maxNumber == 2) {
            return new int[]{2};
        }
        EratosthenesPrimes.init(maxNumber);
        int[] primes = new int[primesNo];
        int maxNumber_2 = maxNumber - 1 >> 1;
        int prime = 0;
        primes[prime++] = 2;
        int i2 = 1;
        while (i2 <= maxNumber_2) {
            if (!sieve.get(i2)) {
                primes[prime++] = (i2 << 1) + 1;
            }
            ++i2;
        }
        return primes;
    }

    public static synchronized int primesCount(int number) {
        if (number < 2) {
            return 0;
        }
        EratosthenesPrimes.init(number);
        int maxNumber_2 = number - 1 >> 1;
        int primesNo = 1;
        int i2 = 1;
        while (i2 <= maxNumber_2) {
            if (!sieve.get(i2)) {
                ++primesNo;
            }
            ++i2;
        }
        return primesNo;
    }

    public static synchronized int belowOrEqual(int number) {
        int maxNumber_2;
        if (number < 2) {
            return -1;
        }
        if (number == 2) {
            return 2;
        }
        EratosthenesPrimes.init(number);
        int i2 = maxNumber_2 = number - 1 >> 1;
        while (i2 > 0) {
            if (!sieve.get(i2)) {
                return (i2 << 1) + 1;
            }
            --i2;
        }
        return -1;
    }

    public static int below(int number) {
        return EratosthenesPrimes.belowOrEqual(number - 1);
    }
}

