/*
 * Decompiled with CFR 0.152.
 */
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DynamicLights {
    private static Map<Integer, DynamicLight> mapDynamicLights = new HashMap<Integer, DynamicLight>();
    private static long timeUpdateMs = 0L;
    private static final double MAX_DIST = 7.5;
    private static final double MAX_DIST_SQ = 56.25;
    private static final int LIGHT_LEVEL_MAX = 15;
    private static final int LIGHT_LEVEL_FIRE = 15;
    private static final int LIGHT_LEVEL_BLAZE = 10;
    private static final int LIGHT_LEVEL_MAGMA_CUBE = 8;
    private static final int LIGHT_LEVEL_MAGMA_CUBE_CORE = 13;
    private static final int LIGHT_LEVEL_GLOWSTONE_DUST = 8;
    private static final int LIGHT_LEVEL_PRISMARINE_CRYSTALS = 8;
    private static final kk<afj> PARAMETER_ITEM_STACK = new kk(6, km.f);

    public static void entityAdded(sn entityIn, bqm renderGlobal) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void entityRemoved(sn entityIn, bqm renderGlobal) {
        Map<Integer, DynamicLight> map = mapDynamicLights;
        synchronized (map) {
            DynamicLight dynamicLight = mapDynamicLights.remove(on.a((int)entityIn.O()));
            if (dynamicLight != null) {
                dynamicLight.updateLitChunks(renderGlobal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(bqm renderGlobal) {
        long timeNowMs = System.currentTimeMillis();
        if (timeNowMs < timeUpdateMs + 50L) {
            return;
        }
        timeUpdateMs = timeNowMs;
        Map<Integer, DynamicLight> map = mapDynamicLights;
        synchronized (map) {
            DynamicLights.updateMapDynamicLights(renderGlobal);
            if (mapDynamicLights.size() <= 0) {
                return;
            }
            Collection<DynamicLight> dynamicLights = mapDynamicLights.values();
            for (DynamicLight dynamicLight : dynamicLights) {
                dynamicLight.update(renderGlobal);
            }
        }
    }

    private static void updateMapDynamicLights(bqm renderGlobal) {
        bnq world = renderGlobal.getWorld();
        if (world == null) {
            return;
        }
        List entities = world.J();
        for (sn entity : entities) {
            DynamicLight dynamicLight;
            Integer key;
            int lightLevel = DynamicLights.getLightLevel(entity);
            if (lightLevel > 0) {
                key = on.a((int)entity.O());
                dynamicLight = mapDynamicLights.get(key);
                if (dynamicLight != null) continue;
                dynamicLight = new DynamicLight(entity);
                mapDynamicLights.put(key, dynamicLight);
                continue;
            }
            key = on.a((int)entity.O());
            dynamicLight = mapDynamicLights.remove(key);
            if (dynamicLight == null) continue;
            dynamicLight.updateLitChunks(renderGlobal);
        }
    }

    public static int getCombinedLight(co pos, int combinedLight) {
        double lightPlayer = DynamicLights.getLightLevel(pos);
        combinedLight = DynamicLights.getCombinedLight(lightPlayer, combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(sn entity, int combinedLight) {
        double lightPlayer = DynamicLights.getLightLevel(entity);
        combinedLight = DynamicLights.getCombinedLight(lightPlayer, combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(double lightPlayer, int combinedLight) {
        int lightBlockFF;
        int lightPlayerFF;
        if (lightPlayer > 0.0 && (lightPlayerFF = (int)(lightPlayer * 16.0)) > (lightBlockFF = combinedLight & 0xFF)) {
            combinedLight &= 0xFFFFFF00;
            combinedLight |= lightPlayerFF;
        }
        return combinedLight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getLightLevel(co pos) {
        double lightLevelMax = 0.0;
        Map<Integer, DynamicLight> map = mapDynamicLights;
        synchronized (map) {
            Collection<DynamicLight> dynamicLights = mapDynamicLights.values();
            for (DynamicLight dynamicLight : dynamicLights) {
                double dist;
                double light;
                double lightLevel;
                int dynamicLightLevel = dynamicLight.getLastLightLevel();
                if (dynamicLightLevel <= 0) continue;
                double px = dynamicLight.getLastPosX();
                double py = dynamicLight.getLastPosY();
                double pz = dynamicLight.getLastPosZ();
                double dx = (double)pos.p() - px;
                double dy = (double)pos.q() - py;
                double dz = (double)pos.r() - pz;
                double distSq = dx * dx + dy * dy + dz * dz;
                if (dynamicLight.isUnderwater() && !Config.isClearWater()) {
                    dynamicLightLevel = Config.limit(dynamicLightLevel - 2, 0, 15);
                    distSq *= 2.0;
                }
                if (distSq > 56.25 || !((lightLevel = (light = 1.0 - (dist = Math.sqrt(distSq)) / 7.5) * (double)dynamicLightLevel) > lightLevelMax)) continue;
                lightLevelMax = lightLevel;
            }
        }
        double lightPlayer = Config.limit(lightLevelMax, 0.0, 15.0);
        return lightPlayer;
    }

    public static int getLightLevel(afj itemStack) {
        adv itemBlock;
        alu block;
        if (itemStack == null) {
            return 0;
        }
        afh item = itemStack.c();
        if (item instanceof adv && (block = (itemBlock = (adv)item).d()) != null) {
            return block.o(block.t());
        }
        if (item == afl.aB) {
            return alv.l.o(alv.l.t());
        }
        if (item == afl.bD || item == afl.bO) {
            return 10;
        }
        if (item == afl.bb) {
            return 8;
        }
        if (item == afl.cO) {
            return 8;
        }
        if (item == afl.bP) {
            return 8;
        }
        if (item == afl.ck) {
            return alv.bY.o(alv.bY.t()) / 2;
        }
        return 0;
    }

    public static int getLightLevel(sn entity) {
        zp entityCreeper;
        aay player;
        if (entity == Config.getMinecraft().aa() && !Config.isDynamicHandLight()) {
            return 0;
        }
        if (entity instanceof aay && (player = (aay)entity).y()) {
            return 0;
        }
        if (entity.aJ()) {
            return 15;
        }
        if (entity instanceof abf) {
            return 15;
        }
        if (entity instanceof zk) {
            return 15;
        }
        if (entity instanceof zn) {
            zn entityBlaze = (zn)entity;
            if (entityBlaze.o()) {
                return 15;
            }
            return 10;
        }
        if (entity instanceof zz) {
            zz emc = (zz)entity;
            if ((double)emc.b > 0.6) {
                return 13;
            }
            return 8;
        }
        if (entity instanceof zp && (double)(entityCreeper = (zp)entity).a(0.0f) > 0.001) {
            return 15;
        }
        if (entity instanceof sw) {
            player = (sw)entity;
            afj stackMain = player.cg();
            int levelMain = DynamicLights.getLightLevel(stackMain);
            afj stackOff = player.ch();
            int levelOff = DynamicLights.getLightLevel(stackOff);
            afj stackHead = player.b(ss.f);
            int levelHead = DynamicLights.getLightLevel(stackHead);
            int levelHandMax = Math.max(levelMain, levelOff);
            return Math.max(levelHandMax, levelHead);
        }
        if (entity instanceof zj) {
            zj entityItem = (zj)entity;
            afj itemStack = DynamicLights.getItemStack(entityItem);
            return DynamicLights.getLightLevel(itemStack);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLights(bqm renderGlobal) {
        Map<Integer, DynamicLight> map = mapDynamicLights;
        synchronized (map) {
            Collection<DynamicLight> lights = mapDynamicLights.values();
            Iterator<DynamicLight> it = lights.iterator();
            while (it.hasNext()) {
                DynamicLight dynamicLight = it.next();
                it.remove();
                dynamicLight.updateLitChunks(renderGlobal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<Integer, DynamicLight> map = mapDynamicLights;
        synchronized (map) {
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount() {
        Map<Integer, DynamicLight> map = mapDynamicLights;
        synchronized (map) {
            return mapDynamicLights.size();
        }
    }

    public static afj getItemStack(zj entityItem) {
        afj itemstack = (afj)entityItem.R().a(PARAMETER_ITEM_STACK);
        return itemstack;
    }
}

