/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.lwjgl.util.vector.Vector3f;

public class BlockModelUtils {
    private static final float VERTEX_COORD_ACCURACY = 1.0E-6f;

    public static cbh makeModelCube(String spriteName, int tintIndex) {
        byz sprite = Config.getMinecraft().R().a(spriteName);
        return BlockModelUtils.makeModelCube(sprite, tintIndex);
    }

    public static cbh makeModelCube(byz sprite, int tintIndex) {
        ArrayList generalQuads = new ArrayList();
        cv[] facings = cv.n;
        HashMap faceQuads = new HashMap();
        for (int i = 0; i < facings.length; ++i) {
            cv facing = facings[i];
            ArrayList<brd> quads = new ArrayList<brd>();
            quads.add(BlockModelUtils.makeBakedQuad(facing, sprite, tintIndex));
            faceQuads.put(facing, quads);
        }
        bro itemOverrideList = new bro(new ArrayList());
        cbo bakedModel = new cbo(generalQuads, faceQuads, true, true, sprite, brq.a, itemOverrideList);
        return bakedModel;
    }

    public static brd makeBakedQuad(cv facing, byz sprite, int tintIndex) {
        Vector3f posFrom = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f posTo = new Vector3f(16.0f, 16.0f, 16.0f);
        brh uv = new brh(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
        brf face = new brf(facing, tintIndex, "#" + facing.m(), uv);
        cbi modelRotation = cbi.a;
        brg partRotation = null;
        boolean uvLocked = false;
        boolean shade = true;
        brl faceBakery = new brl();
        brd quad = faceBakery.a(posFrom, posTo, face, sprite, facing, modelRotation, partRotation, uvLocked, shade);
        return quad;
    }

    public static cbh makeModel(String modelName, String spriteOldName, String spriteNewName) {
        byy textureMap = Config.getMinecraft().R();
        byz spriteOld = textureMap.getSpriteSafe(spriteOldName);
        byz spriteNew = textureMap.getSpriteSafe(spriteNewName);
        return BlockModelUtils.makeModel(modelName, spriteOld, spriteNew);
    }

    public static cbh makeModel(String modelName, byz spriteOld, byz spriteNew) {
        if (spriteOld == null || spriteNew == null) {
            return null;
        }
        cbl modelManager = Config.getModelManager();
        if (modelManager == null) {
            return null;
        }
        cbm mrl = new cbm(modelName, "normal");
        cbh model = modelManager.a(mrl);
        if (model == null || model == modelManager.a()) {
            return null;
        }
        cbh modelNew = ModelUtils.duplicateModel(model);
        cv[] faces = cv.n;
        for (int i = 0; i < faces.length; ++i) {
            cv face = faces[i];
            List quads = modelNew.a(null, face, 0L);
            BlockModelUtils.replaceTexture(quads, spriteOld, spriteNew);
        }
        List quadsGeneral = modelNew.a(null, null, 0L);
        BlockModelUtils.replaceTexture(quadsGeneral, spriteOld, spriteNew);
        return modelNew;
    }

    private static void replaceTexture(List<brd> quads, byz spriteOld, byz spriteNew) {
        ArrayList<Object> quadsNew = new ArrayList<Object>();
        for (brd quad : quads) {
            if (quad.a() != spriteOld) {
                quadsNew.add(quad);
                break;
            }
            brk quadNew = new brk(quad, spriteNew);
            quadsNew.add(quadNew);
        }
        quads.clear();
        quads.addAll(quadsNew);
    }

    public static void snapVertexPosition(Vector3f pos) {
        pos.setX(BlockModelUtils.snapVertexCoord(pos.getX()));
        pos.setY(BlockModelUtils.snapVertexCoord(pos.getY()));
        pos.setZ(BlockModelUtils.snapVertexCoord(pos.getZ()));
    }

    private static float snapVertexCoord(float x) {
        if (x > -1.0E-6f && x < 1.0E-6f) {
            return 0.0f;
        }
        if (x > 0.999999f && x < 1.000001f) {
            return 1.0f;
        }
        return x;
    }

    public static bdt getOffsetBoundingBox(bdt aabb, alu.a offsetType, co pos) {
        int x = pos.p();
        int z = pos.r();
        long k = (long)(x * 3129871) ^ (long)z * 116129781L;
        k = k * k * 42317861L + k * 11L;
        double dx = ((double)((float)(k >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dz = ((double)((float)(k >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dy = 0.0;
        if (offsetType == alu.a.c) {
            dy = ((double)((float)(k >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
        }
        return aabb.d(dx, dy, dz);
    }
}

