/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.DimensionLogic;
import com.mcmoddev.orespawn.api.OreSpawnAPI;
import com.mcmoddev.orespawn.api.SpawnEntry;
import com.mcmoddev.orespawn.api.SpawnLogic;
import com.mcmoddev.orespawn.json.Replacements;
import com.mcmoddev.orespawn.util.StateUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.world.biome.Biome;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class OS3Writer {
    private void writeFeatures(String base) {
        File file = new File(base, "_features.json");
        OreSpawn.FEATURES.writeFeatures(file);
    }

    private void writeReplacements(String base) {
        File file = new File(base, "_replacements.json");
        Replacements.save(file);
    }

    public void writeSpawnEntries() {
        String basePath = String.format(".%sorespawn%sos3", File.separator, File.separator);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        this.writeFeatures(basePath);
        this.writeReplacements(basePath);
        for (Map.Entry<String, SpawnLogic> entry : OreSpawn.API.getAllSpawnLogic().entrySet()) {
            File file = new File(basePath, entry.getKey() + ".json");
            if (file.exists()) continue;
            Map<Integer, DimensionLogic> dimensions = entry.getValue().getAllDimensions();
            JsonObject wrapper = new JsonObject();
            wrapper.addProperty("version", (Number)1);
            JsonArray array = new JsonArray();
            for (Map.Entry<Integer, DimensionLogic> dimension : dimensions.entrySet()) {
                JsonObject object = new JsonObject();
                if (dimension.getKey() != OreSpawnAPI.DIMENSION_WILDCARD) {
                    object.addProperty("dimension", (Number)dimension.getKey());
                }
                JsonArray ores = new JsonArray();
                Collection<SpawnEntry> entries = dimension.getValue().getEntries();
                for (SpawnEntry spawnEntry : entries) {
                    JsonObject ore = new JsonObject();
                    ore.addProperty("block", spawnEntry.getState().func_177230_c().getRegistryName().toString());
                    if (spawnEntry.getState() != spawnEntry.getState().func_177230_c().func_176223_P()) {
                        ore.addProperty("state", StateUtil.serializeState(spawnEntry.getState()));
                    }
                    ore.add("parameters", (JsonElement)spawnEntry.getParameters());
                    ore.addProperty("feature", OreSpawn.FEATURES.getFeatureName(spawnEntry.getFeatureGen()));
                    ore.addProperty("replace_block", "default");
                    List<Biome> biomeArray = spawnEntry.getBiomes();
                    if (!biomeArray.equals(Collections.emptyList())) {
                        JsonArray biomes = new JsonArray();
                        for (Biome biome : biomeArray) {
                            biomes.add((JsonElement)new JsonPrimitive(biome.getRegistryName().toString()));
                        }
                        ore.add("biomes", (JsonElement)biomes);
                    }
                    ores.add((JsonElement)ore);
                }
                object.add("ores", (JsonElement)ores);
                array.add((JsonElement)object);
            }
            wrapper.add("dimensions", (JsonElement)array);
            String json = gson.toJson((JsonElement)wrapper);
            try {
                FileUtils.writeStringToFile((File)file, (String)StringEscapeUtils.unescapeJson((String)json), (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                OreSpawn.LOGGER.fatal("Exception writing OreSpawn config %s - %s", new Object[]{file.toString(), e.getLocalizedMessage()});
            }
        }
    }
}

