/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.DimensionLogic;
import com.mcmoddev.orespawn.api.IFeature;
import com.mcmoddev.orespawn.api.OreSpawnAPI;
import com.mcmoddev.orespawn.api.SpawnLogic;
import com.mcmoddev.orespawn.data.ReplacementsRegistry;
import com.mcmoddev.orespawn.json.Replacements;
import com.mcmoddev.orespawn.util.StateUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.io.FileUtils;

public class OS3Reader {
    private OS3Reader() {
    }

    private static void loadFeatures(File file) {
        OreSpawn.FEATURES.loadFeaturesFile(file);
    }

    public static void loadEntries() {
        File directory = new File("." + File.separator + "orespawn", "os3");
        Map<String, IFeature> features = OreSpawn.FEATURES.getFeatures();
        JsonParser parser = new JsonParser();
        if (!directory.exists()) {
            directory.mkdirs();
            return;
        }
        if (!directory.isDirectory()) {
            OreSpawn.LOGGER.fatal("OreSpawn data directory inaccessible - " + directory + " is not a directory!");
            return;
        }
        File[] files = directory.listFiles();
        if (files.length == 0) {
            return;
        }
        Arrays.stream(files).filter(file -> file.getName().endsWith(".json")).forEach(file -> {
            if ("_features.json".equals(file.getName())) {
                OS3Reader.loadFeatures(file);
                return;
            }
            if ("_replacements.json".equals(file.getName())) {
                Replacements.load(file);
                return;
            }
            try {
                JsonElement full = parser.parse(FileUtils.readFileToString((File)file));
                JsonObject parsed = full.getAsJsonObject();
                if (parsed.get("version").getAsInt() != 1) {
                    return;
                }
                JsonArray elements = parsed.get("dimensions").getAsJsonArray();
                SpawnLogic spawnLogic = OreSpawn.API.createSpawnLogic();
                for (JsonElement element : elements) {
                    JsonObject object = element.getAsJsonObject();
                    int dimension = object.has("dimension") ? object.get("dimension").getAsInt() : OreSpawnAPI.DIMENSION_WILDCARD;
                    DimensionLogic dimensionLogic = spawnLogic.getDimension(dimension);
                    JsonArray ores = object.get("ores").getAsJsonArray();
                    for (JsonElement oresEntry : ores) {
                        String stateString;
                        JsonObject ore = oresEntry.getAsJsonObject();
                        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(ore.get("block").getAsString()));
                        if (block == null) continue;
                        IBlockState state = block.func_176223_P();
                        if (ore.has("state") && (state = StateUtil.deserializeState(block, stateString = ore.get("state").getAsString())) == null) {
                            throw new RuntimeException("Invalid state " + stateString + " for block " + block.getRegistryName());
                        }
                        JsonObject oreParams = ore.get("parameters").getAsJsonObject();
                        String feature = ore.get("feature").getAsString();
                        if (!features.containsKey(feature)) {
                            OreSpawn.LOGGER.warn("I don't know feature %s but was told to use it here, skipping this entry!");
                            continue;
                        }
                        IFeature featureGen = (IFeature)features.get(feature);
                        String replaceBase = ore.get("replace_block").getAsString();
                        IBlockState blockRep = "default".equals(replaceBase) ? ReplacementsRegistry.getDimensionDefault(dimension) : (replaceBase == null ? ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("minecraft:stone"))).func_176223_P() : ReplacementsRegistry.getBlock(replaceBase));
                        ArrayList<Biome> biomes = new ArrayList<Biome>();
                        if (ore.has("biomes")) {
                            JsonArray biomesArray = ore.get("biomes").getAsJsonArray();
                            for (JsonElement biomeEntry : biomesArray) {
                                Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeEntry.getAsString()));
                                if (biome == null) continue;
                                biomes.add(biome);
                            }
                        }
                        dimensionLogic.addOre(state, oreParams, biomes.toArray(new Biome[biomes.size()]), featureGen, blockRep);
                    }
                }
                OreSpawn.API.registerSpawnLogic(file.getName().substring(0, file.getName().lastIndexOf(46)), spawnLogic);
            }
            catch (Exception e) {
                CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)("Failed reading config " + file.getName()));
                report.func_85056_g().func_71507_a("OreSpawn Version", (Object)"3.0.0");
                OreSpawn.LOGGER.info(report.func_71502_e());
            }
        });
    }
}

