/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.DimensionLogic;
import com.mcmoddev.orespawn.api.OreSpawnAPI;
import com.mcmoddev.orespawn.api.SpawnLogic;
import com.mcmoddev.orespawn.util.StateUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.io.FileUtils;

public class OS2Reader {
    public static void loadEntries() {
        File directory = new File(".", "orespawn");
        JsonParser parser = new JsonParser();
        if (!directory.exists()) {
            directory.mkdirs();
            return;
        }
        if (!directory.isDirectory()) {
            OreSpawn.LOGGER.fatal("OreSpawn data directory inaccessible - " + directory + " is not a directory!");
            return;
        }
        File[] files = directory.listFiles();
        if (files.length == 0) {
            return;
        }
        Arrays.stream(files).filter(file -> file.getName().endsWith(".json")).forEach(file -> {
            try {
                JsonElement full = parser.parse(FileUtils.readFileToString((File)file));
                JsonArray elements = full.getAsJsonArray();
                SpawnLogic spawnLogic = OreSpawn.API.createSpawnLogic();
                for (JsonElement element : elements) {
                    JsonObject object = element.getAsJsonObject();
                    int dimension = object.has("dimension") ? object.get("dimension").getAsInt() : OreSpawnAPI.DIMENSION_WILDCARD;
                    DimensionLogic dimensionLogic = spawnLogic.getDimension(dimension);
                    JsonArray ores = object.get("ores").getAsJsonArray();
                    for (JsonElement oresEntry : ores) {
                        String stateString;
                        JsonObject ore = oresEntry.getAsJsonObject();
                        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(ore.get("block").getAsString()));
                        if (block == null) continue;
                        IBlockState state = block.func_176223_P();
                        if (ore.has("state") && (state = StateUtil.deserializeState(block, stateString = ore.get("state").getAsString())) == null) {
                            throw new RuntimeException("Invalid state " + stateString + " for block " + block.getRegistryName());
                        }
                        int size = ore.get("size").getAsInt();
                        int variation = ore.get("variation").getAsInt();
                        float frequency = ore.get("frequency").getAsFloat();
                        int minHeight = ore.get("min_height").getAsInt();
                        int maxHeight = ore.get("max_height").getAsInt();
                        ArrayList<Biome> biomes = new ArrayList<Biome>();
                        if (ore.has("biomes")) {
                            JsonArray biomesArray = ore.get("biomes").getAsJsonArray();
                            for (JsonElement biomeEntry : biomesArray) {
                                Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeEntry.getAsString()));
                                if (biome == null) continue;
                                biomes.add(biome);
                            }
                        }
                        dimensionLogic.addOre(state, size, variation, frequency, minHeight, maxHeight, biomes.toArray(new Biome[biomes.size()]));
                    }
                }
                OreSpawn.API.registerSpawnLogic(file.getName().substring(0, file.getName().lastIndexOf(".")), spawnLogic);
            }
            catch (Exception e) {
                CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)("Failed reading config " + file.getName()));
                report.func_85056_g().func_71507_a("OreSpawn Version", (Object)"3.0.0");
                OreSpawn.LOGGER.info(report.func_71502_e());
            }
        });
    }
}

