/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.DimensionLogic;
import com.mcmoddev.orespawn.api.OreSpawnAPI;
import com.mcmoddev.orespawn.api.SpawnLogic;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.io.FileUtils;

public class OS1Reader {
    private OS1Reader() {
    }

    public static void loadEntries(Path confDir) {
        File directory = new File(confDir.toString());
        JsonParser parser = new JsonParser();
        if (!directory.exists()) {
            directory.mkdirs();
            return;
        }
        if (!directory.isDirectory()) {
            OreSpawn.LOGGER.fatal("OreSpawn data directory inaccessible - " + directory + " is not a directory!");
            return;
        }
        File[] files = directory.listFiles();
        if (files.length == 0) {
            return;
        }
        Arrays.stream(files).filter(file -> file.getName().endsWith(".json")).forEach(file -> {
            try {
                JsonObject root = parser.parse(FileUtils.readFileToString((File)file)).getAsJsonObject();
                SpawnLogic spawnLogic = OreSpawn.API.createSpawnLogic();
                for (JsonElement elem : root.get("dimensions").getAsJsonArray()) {
                    JsonObject dim = elem.getAsJsonObject();
                    int theDim = "+".equals(dim.get("dimension").getAsString()) ? OreSpawnAPI.DIMENSION_WILDCARD : dim.get("dimension").getAsInt();
                    DimensionLogic dimensionLogic = spawnLogic.getDimension(theDim);
                    for (JsonElement oElem : dim.get("ores").getAsJsonArray()) {
                        OS1Reader.loadOre(oElem.getAsJsonObject(), dimensionLogic);
                    }
                }
                OreSpawn.API.registerSpawnLogic(file.getName().substring(0, file.getName().lastIndexOf(46)), spawnLogic);
            }
            catch (Exception e) {
                CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)("Failed reading config " + file.getName()));
                report.func_85056_g().func_71507_a("OreSpawn Version", (Object)"3.0.0");
                OreSpawn.LOGGER.info(report.func_71502_e());
            }
        });
    }

    private static void loadOre(JsonObject oElem, DimensionLogic dimensionLogic) {
        List<Biome> biomes;
        int variation;
        String blockID = oElem.get("blockID").getAsString();
        String modId = blockID.contains(":") ? blockID.substring(0, blockID.indexOf(58)) : "minecraft";
        String name = blockID.contains(":") ? blockID.substring(blockID.indexOf(58) + 1) : blockID;
        int meta = oElem.has("metaData") ? oElem.get("metaData").getAsInt() : 0;
        ResourceLocation blockKey = new ResourceLocation(blockID);
        String biome = "biomes";
        if (!Block.field_149771_c.func_148741_d((Object)blockKey)) {
            OreSpawn.LOGGER.warn("Asked to spawn block " + modId + ":" + name + " that does not exist");
            return;
        }
        Block b = (Block)Block.field_149771_c.func_82594_a((Object)blockKey);
        IBlockState bs = meta == 0 ? b.func_176223_P() : b.func_176203_a(meta);
        float frequency = oElem.has("frequency") ? oElem.get("frequency").getAsFloat() : 20.0f;
        int size = oElem.has("size") ? oElem.get("size").getAsInt() : 8;
        int maxHeight = oElem.has("maxHeight") ? oElem.get("maxHeight").getAsInt() : 255;
        int minHeight = oElem.has("minHeight") ? oElem.get("minHeight").getAsInt() : 0;
        int n = variation = oElem.has("variation") ? oElem.get("variation").getAsInt() : (int)(0.5f * (float)size);
        if (oElem.has(biome) && oElem.get(biome).getAsJsonArray().size() > 0) {
            JsonArray biomesArray = oElem.get(biome).getAsJsonArray();
            biomes = new ArrayList();
            for (JsonElement biomeEntry : biomesArray) {
                Biome bm = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeEntry.getAsString()));
                if (bm == null) continue;
                biomes.add(bm);
            }
        } else {
            biomes = Collections.emptyList();
        }
        dimensionLogic.addOre(bs, size, variation, frequency, minHeight, maxHeight, biomes.toArray(new Biome[biomes.size()]));
    }
}

