/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.features;

import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.IFeature;
import com.mcmoddev.orespawn.data.Integer3D;
import com.mcmoddev.orespawn.data.ReplacementsRegistry;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;

public class DefaultFeatureGenerator
implements IFeature {
    private static final int maxCacheSize = 1024;
    private static final Map<Integer3D, Map<BlockPos, IBlockState>> overflowCache = new HashMap<Integer3D, Map<BlockPos, IBlockState>>(1024);
    private static final Deque<Integer3D> cacheOrder = new LinkedList<Integer3D>();
    private static final Vec3i[] offsets = new Vec3i[]{new Vec3i(-1, -1, -1), new Vec3i(0, -1, -1), new Vec3i(1, -1, -1), new Vec3i(-1, 0, -1), new Vec3i(0, 0, -1), new Vec3i(1, 0, -1), new Vec3i(-1, 1, -1), new Vec3i(0, 1, -1), new Vec3i(1, 1, -1), new Vec3i(-1, -1, 0), new Vec3i(0, -1, 0), new Vec3i(1, -1, 0), new Vec3i(-1, 0, 0), new Vec3i(0, 0, 0), new Vec3i(1, 0, 0), new Vec3i(-1, 1, 0), new Vec3i(0, 1, 0), new Vec3i(1, 1, 0), new Vec3i(-1, -1, 1), new Vec3i(0, -1, 1), new Vec3i(1, -1, 1), new Vec3i(-1, 0, 1), new Vec3i(0, 0, 1), new Vec3i(1, 0, 1), new Vec3i(-1, 1, 1), new Vec3i(0, 1, 1), new Vec3i(1, 1, 1)};
    private static final Vec3i[] offsets_small = new Vec3i[]{new Vec3i(0, 0, 0), new Vec3i(1, 0, 0), new Vec3i(0, 1, 0), new Vec3i(1, 1, 0), new Vec3i(0, 0, 1), new Vec3i(1, 0, 1), new Vec3i(0, 1, 1), new Vec3i(1, 1, 1)};
    private static final int[] offsetIndexRef = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
    private static final int[] offsetIndexRef_small = new int[]{0, 1, 2, 3, 4, 5, 6, 7};

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider, JsonObject parameters, IBlockState block, IBlockState replaceBlock) {
        Integer3D chunkCoord = new Integer3D(chunkX, chunkZ, world.field_73011_w.getDimension());
        Map<BlockPos, IBlockState> cache = DefaultFeatureGenerator.retrieveCache(chunkCoord);
        for (Map.Entry<BlockPos, IBlockState> ent : cache.entrySet()) {
            DefaultFeatureGenerator.spawn(cache.get(ent.getKey()), world, ent.getKey(), world.field_73011_w.getDimension(), false, replaceBlock);
        }
        int blockX = chunkX * 16 + 8;
        int blockZ = chunkZ * 16 + 8;
        int minY = parameters.get("minHeight").getAsInt();
        int maxY = parameters.get("maxHeight").getAsInt();
        int vari = parameters.get("variation").getAsInt();
        float freq = parameters.get("frequency").getAsFloat();
        int size = parameters.get("size").getAsInt();
        if (freq >= 1.0f) {
            int i = 0;
            while ((float)i < freq) {
                int x = blockX + random.nextInt(8);
                int y = random.nextInt(maxY - minY) + minY;
                int z = blockZ + random.nextInt(8);
                int r = vari > 0 ? random.nextInt(2 * vari) - vari : 0;
                DefaultFeatureGenerator.spawnOre(new BlockPos(x, y, z), block, size + r, world, random, replaceBlock);
                ++i;
            }
        } else if (random.nextFloat() < freq) {
            int x = blockX + random.nextInt(8);
            int y = random.nextInt(maxY - minY) + minY;
            int z = blockZ + random.nextInt(8);
            int r = vari > 0 ? random.nextInt(2 * vari) - vari : 0;
            DefaultFeatureGenerator.spawnOre(new BlockPos(x, y, z), block, size + r, world, random, replaceBlock);
        }
    }

    public static void spawnOre(BlockPos blockPos, IBlockState oreBlock, int quantity, World world, Random prng, IBlockState replaceBlock) {
        block16: {
            int count = quantity;
            if (quantity <= 8) {
                int[] scrambledLUT = new int[offsetIndexRef_small.length];
                System.arraycopy(offsetIndexRef_small, 0, scrambledLUT, 0, scrambledLUT.length);
                DefaultFeatureGenerator.scramble(scrambledLUT, prng);
                while (count > 0) {
                    DefaultFeatureGenerator.spawn(oreBlock, world, blockPos.func_177971_a(offsets_small[scrambledLUT[--count]]), world.field_73011_w.getDimension(), true, replaceBlock);
                }
                return;
            }
            if (quantity < 27) {
                int[] scrambledLUT = new int[offsetIndexRef.length];
                System.arraycopy(offsetIndexRef, 0, scrambledLUT, 0, scrambledLUT.length);
                DefaultFeatureGenerator.scramble(scrambledLUT, prng);
                while (count > 0) {
                    DefaultFeatureGenerator.spawn(oreBlock, world, blockPos.func_177971_a(offsets[scrambledLUT[--count]]), world.field_73011_w.getDimension(), true, replaceBlock);
                }
                return;
            }
            double radius = Math.pow(quantity, 0.3333333333333333) * 0.238732414637843 + 2.0;
            int rSqr = (int)(radius * radius);
            if (prng.nextBoolean()) {
                int dy = (int)(-1.0 * radius);
                while ((double)dy < radius) {
                    int dz = (int)(-1.0 * radius);
                    while ((double)dz < radius) {
                        int dx = (int)(-1.0 * radius);
                        while ((double)dx < radius) {
                            if (dx * dx + dy * dy + dz * dz <= rSqr) {
                                DefaultFeatureGenerator.spawn(oreBlock, world, blockPos.func_177982_a(dx, dy, dz), world.field_73011_w.getDimension(), true, replaceBlock);
                                --count;
                            }
                            if (count > 0) {
                                ++dx;
                                continue;
                            }
                            break block16;
                        }
                        ++dz;
                    }
                    ++dy;
                }
            } else {
                int dy = (int)(-1.0 * radius);
                while ((double)dy < radius) {
                    for (int dx = (int)radius; dx >= (int)(-1.0 * radius); --dx) {
                        for (int dz = (int)radius; dz >= (int)(-1.0 * radius); --dz) {
                            if (dx * dx + dy * dy + dz * dz <= rSqr) {
                                DefaultFeatureGenerator.spawn(oreBlock, world, blockPos.func_177982_a(dx, dy, dz), world.field_73011_w.getDimension(), true, replaceBlock);
                                --count;
                            }
                            if (count > 0) {
                                continue;
                            }
                            break block16;
                        }
                    }
                    ++dy;
                }
            }
        }
    }

    private static void scramble(int[] target, Random prng) {
        for (int i = target.length - 1; i > 0; --i) {
            int n = prng.nextInt(i);
            int temp = target[i];
            target[i] = target[n];
            target[n] = temp;
        }
    }

    private static boolean canReplace(IBlockState target, IBlockState toReplace) {
        if (target.func_177230_c().equals(Blocks.field_150350_a)) {
            return false;
        }
        return toReplace.equals(target);
    }

    private static void spawn(IBlockState b, World w, BlockPos coord, int dimension, boolean cacheOverflow, IBlockState replaceBlock) {
        IBlockState b2r = replaceBlock;
        if (b2r == null) {
            b2r = ReplacementsRegistry.getDimensionDefault(w.field_73011_w.getDimension());
        }
        if (b2r == null) {
            OreSpawn.LOGGER.fatal("called to spawn %s, replaceBlock is null and the registry says there is no default", new Object[]{b});
            return;
        }
        if (coord.func_177956_o() < 0 || coord.func_177956_o() >= w.func_72800_K()) {
            return;
        }
        if (w.func_175667_e(coord)) {
            IBlockState bs = w.func_180495_p(coord);
            if (DefaultFeatureGenerator.canReplace(bs, b2r)) {
                w.func_180501_a(coord, b, 2);
            }
        } else if (cacheOverflow) {
            DefaultFeatureGenerator.cacheOverflowBlock(b, coord, dimension);
        }
    }

    protected static void cacheOverflowBlock(IBlockState bs, BlockPos coord, int dimension) {
        Integer3D chunkCoord = new Integer3D(coord.func_177958_n() >> 4, coord.func_177956_o() >> 4, dimension);
        if (overflowCache.containsKey(chunkCoord)) {
            cacheOrder.addLast(chunkCoord);
            if (cacheOrder.size() > 1024) {
                Integer3D drop = cacheOrder.removeFirst();
                overflowCache.get(drop).clear();
                overflowCache.remove(drop);
            }
            overflowCache.put(chunkCoord, new HashMap());
        }
        Map<BlockPos, IBlockState> cache = overflowCache.get(chunkCoord);
        cache.put(coord, bs);
    }

    protected static Map<BlockPos, IBlockState> retrieveCache(Integer3D chunkCoord) {
        if (overflowCache.containsKey(chunkCoord)) {
            Map<BlockPos, IBlockState> cache = overflowCache.get(chunkCoord);
            cacheOrder.remove(chunkCoord);
            overflowCache.remove(chunkCoord);
            return cache;
        }
        return Collections.emptyMap();
    }
}

