/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl;

import com.google.common.collect.ImmutableMap;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.DimensionLogic;
import com.mcmoddev.orespawn.api.OreSpawnAPI;
import com.mcmoddev.orespawn.api.SpawnLogic;
import com.mcmoddev.orespawn.impl.SpawnLogicImpl;
import com.mcmoddev.orespawn.worldgen.OreSpawnWorldGen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class OreSpawnImpl
implements OreSpawnAPI {
    private final Map<String, SpawnLogic> spawnLogic = new HashMap<String, SpawnLogic>();
    private static OreSpawnWorldGen worldGenerator;

    @Override
    public SpawnLogic createSpawnLogic() {
        return new SpawnLogicImpl();
    }

    @Override
    public SpawnLogic getSpawnLogic(String id) {
        return this.spawnLogic.get(id);
    }

    @Override
    public Map<String, SpawnLogic> getAllSpawnLogic() {
        return ImmutableMap.copyOf(this.spawnLogic);
    }

    @Override
    public void registerSpawnLogic(String id, SpawnLogic spawnLogic) {
        this.spawnLogic.put(id, spawnLogic);
    }

    @Override
    public void registerSpawns() {
        for (Map.Entry<String, SpawnLogic> ent : this.spawnLogic.entrySet()) {
            for (Map.Entry<Integer, DimensionLogic> dL : ent.getValue().getAllDimensions().entrySet()) {
                if (OreSpawn.spawns.containsKey(dL.getKey())) {
                    OreSpawn.spawns.get(dL.getKey()).addAll(dL.getValue().getEntries());
                    continue;
                }
                OreSpawn.spawns.put(dL.getKey(), new ArrayList());
                OreSpawn.spawns.get(dL.getKey()).addAll(dL.getValue().getEntries());
            }
            OreSpawn.LOGGER.info("Registered spawn logic for mod " + ent.getKey());
        }
        Random random = new Random();
        worldGenerator = new OreSpawnWorldGen(OreSpawn.spawns, random.nextLong());
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldGenerator, (int)100);
    }

    @Override
    public OreSpawnWorldGen getWorldGenerator() {
        return worldGenerator;
    }

    @Override
    public void addFeatureGenerator(String name, String className) {
        OreSpawn.FEATURES.addFeature(name, className);
    }
}

