/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.IFeature;
import com.mcmoddev.orespawn.impl.features.DefaultFeatureGenerator;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.crash.CrashReport;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class FeatureRegistry {
    private Map<String, IFeature> features = new HashMap<String, IFeature>();
    private Map<IFeature, String> featuresInverse = new HashMap<IFeature, String>();
    private static final String def = "default";

    public FeatureRegistry() {
        DefaultFeatureGenerator defaultGen = new DefaultFeatureGenerator();
        this.features.put(def, defaultGen);
        this.featuresInverse.put(defaultGen, def);
    }

    public Map<String, IFeature> getFeatures() {
        return Collections.unmodifiableMap(this.features);
    }

    public String getFeatureName(IFeature feature) {
        if (this.hasFeature(feature)) {
            return this.featuresInverse.get(feature);
        }
        return def;
    }

    public IFeature getFeature(String name) {
        if (this.hasFeature(name)) {
            return this.features.get(name);
        }
        return this.features.get(def);
    }

    public boolean hasFeature(String name) {
        return this.features.containsKey(name);
    }

    public boolean hasFeature(IFeature feature) {
        return this.featuresInverse.containsKey(feature);
    }

    public void addFeature(JsonObject entry) {
        this.addFeature(entry.get("name").getAsString(), entry.get("class").getAsString());
    }

    public void addFeature(String name, String className) {
        IFeature feature = this.getInstance(className);
        if (feature != null && !this.features.containsKey(name)) {
            this.features.put(name, feature);
            this.featuresInverse.put(feature, name);
        }
    }

    private IFeature getInstance(String className) {
        IFeature feature = null;
        try {
            Class<?> featureClazz = Class.forName(className);
            Constructor<?> featureCons = featureClazz.getConstructor(new Class[0]);
            feature = (IFeature)featureCons.newInstance(new Object[0]);
        }
        catch (Exception e) {
            CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)("Failed to load and instantiate an instance of the feature generator named " + className + " that was specified as a feature generator"));
            report.func_85056_g().func_71507_a("OreSpawn Version", (Object)"3.0.0");
            OreSpawn.LOGGER.info(report.func_71502_e());
            return null;
        }
        return feature;
    }

    public void loadFeaturesFile(File file) {
        JsonParser parser = new JsonParser();
        String rawJson = "[]";
        try {
            rawJson = FileUtils.readFileToString((File)file);
        }
        catch (IOException e) {
            CrashReport report = CrashReport.func_85055_a((Throwable)e, (String)("Failed reading config " + file.getName()));
            report.func_85056_g().func_71507_a("OreSpawn Version", (Object)"3.0.0");
            OreSpawn.LOGGER.info(report.func_71502_e());
            return;
        }
        JsonArray elements = parser.parse(rawJson).getAsJsonArray();
        for (JsonElement elem : elements) {
            this.addFeature(elem.getAsJsonObject());
        }
    }

    public void writeFeatures(File file) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonArray root = new JsonArray();
        if (!this.features.equals(Collections.emptyMap())) {
            for (Map.Entry<String, IFeature> feature : this.features.entrySet()) {
                JsonObject entry = new JsonObject();
                entry.addProperty("name", feature.getKey());
                entry.addProperty("class", feature.getValue().getClass().getName());
                root.add((JsonElement)entry);
            }
        }
        String json = gson.toJson((JsonElement)root);
        try {
            FileUtils.writeStringToFile((File)file, (String)StringEscapeUtils.unescapeJson((String)json), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

