/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.data;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraftforge.common.config.Configuration;

public class Config {
    private static Configuration configuration;
    private static final HashMap<String, Boolean> boolVals;
    private static final HashMap<String, String> stringVals;
    private static final HashMap<String, Integer> intVals;
    private static final HashMap<String, Float> floatVals;
    private static final ArrayList<String> knownKeys;

    private Config() {
    }

    public static void loadConfig() {
        configuration = new Configuration(new File("config/orespawn.cfg"));
        boolVals.put("Retrogen", configuration.getBoolean("Retrogen", "general", false, "Do we have Retrogen active and generating anything different from the last run in already existing chunks ?"));
        boolVals.put("Force Retrogen", configuration.getBoolean("Force Retrogen", "general", false, "Force all chunks to retrogen regardless of anything else"));
        boolVals.put("Replace Vanilla Oregen", configuration.getBoolean("Replace Vanilla Oregen", "general", false, "Replace vanilla ore-generation entirely"));
        knownKeys.add("Retrogen");
        knownKeys.add("Force Retrogen");
        knownKeys.add("Replace Vanilla Oregen");
    }

    public static boolean getBoolean(String keyname) {
        if (knownKeys.contains(keyname) && boolVals.containsKey(keyname)) {
            return boolVals.get(keyname);
        }
        return false;
    }

    public static String getString(String keyname) {
        if (knownKeys.contains(keyname) && stringVals.containsKey(keyname)) {
            return stringVals.get(keyname);
        }
        return "";
    }

    public static int getInt(String keyname) {
        if (knownKeys.contains(keyname) && intVals.containsKey(keyname)) {
            return intVals.get(keyname);
        }
        return 0;
    }

    public static float getFloat(String keyname) {
        if (knownKeys.contains(keyname) && floatVals.containsKey(keyname)) {
            return floatVals.get(keyname).floatValue();
        }
        return 0.0f;
    }

    public static void saveConfig() {
        configuration.save();
    }

    static {
        boolVals = new HashMap();
        stringVals = new HashMap();
        intVals = new HashMap();
        floatVals = new HashMap();
        knownKeys = new ArrayList();
    }
}

