/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mcmoddev.orespawn.api.OreSpawnAPI;
import com.mcmoddev.orespawn.util.StateUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class AddOreCommand
extends CommandBase {
    private static final String dim = "dimension";
    private static final String all = "all";

    public String func_71517_b() {
        return "addore";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/addore <file> <dimension|all>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayer)) {
            throw new CommandException("Only players can use this command", new Object[0]);
        }
        EntityPlayer player = (EntityPlayer)sender;
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (stack == null) {
            throw new CommandException("You have no item in your main hand", new Object[0]);
        }
        if (!(stack.func_77973_b() instanceof ItemBlock)) {
            throw new CommandException("The item in your main hand isn't a block", new Object[0]);
        }
        if (args.length != 2) {
            throw new CommandException(this.func_71518_a(sender), new Object[0]);
        }
        File file = new File(".", "orespawn" + File.separator + args[0] + ".json");
        JsonParser parser = new JsonParser();
        IBlockState state = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77952_i());
        if (!file.exists()) {
            throw new CommandException("That file doesn't exist" + (args[0].endsWith(".json") ? " (don't add .json)" : ""), new Object[0]);
        }
        int dimension = OreSpawnAPI.DIMENSION_WILDCARD;
        try {
            if (!args[1].equals(all)) {
                dimension = Integer.parseInt(args[1]);
            }
        }
        catch (NumberFormatException e) {
            throw new CommandException(args[1] + " isn't a valid dimension", new Object[0]);
        }
        JsonObject ore = new JsonObject();
        ore.addProperty("block", state.func_177230_c().getRegistryName().toString());
        ore.addProperty("state", StateUtil.serializeState(state));
        ore.addProperty("size", (Number)25);
        ore.addProperty("variation", (Number)12);
        ore.addProperty("frequency", (Number)20);
        ore.addProperty("min_height", (Number)0);
        ore.addProperty("max_height", (Number)128);
        try {
            JsonArray json = parser.parse(FileUtils.readFileToString((File)file)).getAsJsonArray();
            for (JsonElement element : json) {
                JsonObject object = element.getAsJsonObject();
                if (!(object.has(dim) ? dimension == object.get(dim).getAsInt() : dimension == OreSpawnAPI.DIMENSION_WILDCARD)) continue;
                object.get("ores").getAsJsonArray().add((JsonElement)ore);
                this.saveFile(json, file);
                return;
            }
            JsonObject object = new JsonObject();
            if (dimension != OreSpawnAPI.DIMENSION_WILDCARD) {
                object.addProperty(dim, (Number)dimension);
            }
            JsonArray array = new JsonArray();
            array.add((JsonElement)ore);
            object.add("ores", (JsonElement)array);
            this.saveFile(json, file);
        }
        catch (IOException e) {
            throw new CommandException("Something went wrong - " + e.getMessage(), new Object[0]);
        }
        player.func_146105_b((ITextComponent)new TextComponentString("Added " + state.func_177230_c().getRegistryName().toString() + " to the json"), true);
    }

    private void saveFile(JsonArray array, File file) throws CommandException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((JsonElement)array);
        try {
            FileUtils.writeStringToFile((File)file, (String)StringEscapeUtils.unescapeJson((String)json), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new CommandException("Something went wrong - " + e.getMessage(), new Object[0]);
        }
    }

    public int compareTo(ICommand command) {
        return this.func_71517_b().compareTo(command.func_71517_b());
    }
}

