/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.mcmoddev.orespawn.EventHandlers;
import com.mcmoddev.orespawn.api.OreSpawnAPI;
import com.mcmoddev.orespawn.api.SpawnEntry;
import com.mcmoddev.orespawn.api.SpawnLogic;
import com.mcmoddev.orespawn.commands.AddOreCommand;
import com.mcmoddev.orespawn.commands.ClearChunkCommand;
import com.mcmoddev.orespawn.commands.DumpBiomesCommand;
import com.mcmoddev.orespawn.commands.WriteConfigsCommand;
import com.mcmoddev.orespawn.data.Config;
import com.mcmoddev.orespawn.data.FeatureRegistry;
import com.mcmoddev.orespawn.impl.OreSpawnImpl;
import com.mcmoddev.orespawn.json.OS1Reader;
import com.mcmoddev.orespawn.json.OS2Reader;
import com.mcmoddev.orespawn.json.OS3Reader;
import com.mcmoddev.orespawn.json.OS3Writer;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="orespawn", name="MMD OreSpawn", version="3.0.0", acceptedMinecraftVersions="[1.11.2,)")
public class OreSpawn {
    @Mod.Instance
    public static OreSpawn INSTANCE = null;
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"orespawn");
    public static final OreSpawnAPI API = new OreSpawnImpl();
    public static final OS3Writer writer = new OS3Writer();
    public static final EventHandlers eventHandlers = new EventHandlers();
    public static final FeatureRegistry FEATURES = new FeatureRegistry();
    private String OS1ConfigPath;
    public static final Map<Integer, List<SpawnEntry>> spawns = new HashMap<Integer, List<SpawnEntry>>();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent ev) {
        Config.loadConfig();
        if (Config.getBoolean("Retrogen")) {
            MinecraftForge.EVENT_BUS.register((Object)eventHandlers);
        }
        if (Config.getBoolean("Replace Vanilla Oregen")) {
            MinecraftForge.ORE_GEN_BUS.register((Object)eventHandlers);
        }
        this.OS1ConfigPath = Paths.get(ev.getSuggestedConfigurationFile().toPath().getParent().toString(), "orespawn").toString();
        FMLInterModComms.sendFunctionMessage((String)"orespawn", (String)"api", (String)"com.mcmoddev.orespawn.data.VanillaOrespawn");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent ev) {
        OS1Reader.loadEntries(Paths.get(this.OS1ConfigPath, new String[0]));
        OS2Reader.loadEntries();
        OS3Reader.loadEntries();
        API.registerSpawns();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent ev) {
        writer.writeSpawnEntries();
        Config.saveConfig();
    }

    @Mod.EventHandler
    public void onIMC(FMLInterModComms.IMCEvent event) {
        event.getMessages().stream().filter(message -> "api".equalsIgnoreCase(message.key)).forEach(message -> {
            Optional value = message.getFunctionValue(OreSpawnAPI.class, SpawnLogic.class);
            if (API.getSpawnLogic(message.getSender()) == null && value.isPresent()) {
                API.registerSpawnLogic(message.getSender(), (SpawnLogic)((Function)value.get()).apply((Object)API));
            }
        });
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent ev) {
        ev.registerServerCommand((ICommand)new ClearChunkCommand());
        ev.registerServerCommand((ICommand)new DumpBiomesCommand());
        ev.registerServerCommand((ICommand)new AddOreCommand());
        ev.registerServerCommand((ICommand)new WriteConfigsCommand());
    }
}

