/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn;

import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.OreSpawnAPI;
import com.mcmoddev.orespawn.api.SpawnEntry;
import com.mcmoddev.orespawn.api.SpawnLogic;
import com.mcmoddev.orespawn.data.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class EventHandlers {
    private List<ChunkPos> chunks = new ArrayList<ChunkPos>();

    @SubscribeEvent
    public void onGenerateMinable(OreGenEvent.GenerateMinable event) {
        event.setResult(Event.Result.DENY);
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save ev) {
        NBTTagCompound dataTag = ev.getData().func_74775_l("MMD OreSpawn Data");
        NBTTagList ores = new NBTTagList();
        NBTTagList features = new NBTTagList();
        features.func_74742_a((NBTBase)new NBTTagString("orespawn:default"));
        for (Map.Entry<String, SpawnLogic> ent : OreSpawn.API.getAllSpawnLogic().entrySet()) {
            Collection<SpawnEntry> vals;
            SpawnLogic log = ent.getValue();
            if (log.getAllDimensions().containsKey(ev.getWorld().field_73011_w.getDimension())) {
                vals = log.getDimension(ev.getWorld().field_73011_w.getDimension()).getEntries();
                for (SpawnEntry s : vals) {
                    ores.func_74742_a((NBTBase)new NBTTagString(s.getState().func_177230_c().getRegistryName().toString()));
                }
            }
            if (!log.getAllDimensions().containsKey(OreSpawnAPI.DIMENSION_WILDCARD)) continue;
            vals = log.getDimension(OreSpawnAPI.DIMENSION_WILDCARD).getEntries();
            for (SpawnEntry s : vals) {
                ores.func_74742_a((NBTBase)new NBTTagString(s.getState().func_177230_c().getRegistryName().toString()));
            }
        }
        dataTag.func_74782_a("ores", (NBTBase)ores);
        dataTag.func_74782_a("features", (NBTBase)features);
        ev.getData().func_74782_a("MMD OreSpawn Data", (NBTBase)dataTag);
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load ev) {
        World world = ev.getWorld();
        ChunkPos chunkCoords = new ChunkPos(ev.getChunk().field_76635_g, ev.getChunk().field_76647_h);
        int chunkX = ev.getChunk().field_76635_g;
        int chunkZ = ev.getChunk().field_76647_h;
        if (this.chunks.contains(chunkCoords)) {
            return;
        }
        if (Config.getBoolean("Retrogen")) {
            int count;
            this.chunks.add(chunkCoords);
            Set worldGens = (Set)ObfuscationReflectionHelper.getPrivateValue(GameRegistry.class, null, (String[])new String[]{"worldGenerators"});
            NBTTagCompound chunkTag = ev.getData().func_74775_l("MMD OreSpawn Data");
            int n = count = chunkTag == null ? 0 : chunkTag.func_150295_c("ores", 8).func_74745_c();
            if (count != this.countOres(ev.getWorld().field_73011_w.getDimension()) || Config.getBoolean("Force Retrogen")) {
                for (IWorldGenerator wg : worldGens) {
                    long worldSeed = world.func_72905_C();
                    Random fmlRandom = new Random(worldSeed);
                    long xSeed = fmlRandom.nextLong() >> 3;
                    long zSeed = fmlRandom.nextLong() >> 3;
                    long chunkSeed = xSeed * (long)chunkCoords.field_77276_a + zSeed * (long)chunkCoords.field_77275_b ^ worldSeed;
                    fmlRandom.setSeed(chunkSeed);
                    ChunkProviderServer chunkProvider = (ChunkProviderServer)world.func_72863_F();
                    IChunkGenerator chunkGenerator = (IChunkGenerator)ObfuscationReflectionHelper.getPrivateValue(ChunkProviderServer.class, (Object)chunkProvider, (String[])new String[]{"field_186029_c", "chunkGenerator"});
                    wg.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, (IChunkProvider)chunkProvider);
                }
            }
        }
    }

    private int countOres(int dim) {
        int acc = 0;
        for (Map.Entry<String, SpawnLogic> sL : OreSpawn.API.getAllSpawnLogic().entrySet()) {
            if (sL.getValue().getAllDimensions().containsKey(dim)) {
                acc += sL.getValue().getAllDimensions().get(dim).getEntries().size();
            }
            if (!sL.getValue().getAllDimensions().containsKey(OreSpawnAPI.DIMENSION_WILDCARD)) continue;
            acc += sL.getValue().getAllDimensions().get(OreSpawnAPI.DIMENSION_WILDCARD).getEntries().size();
        }
        return acc;
    }
}

