/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.nethermetals.util;

import com.mcmoddev.lib.registry.CrusherRecipeRegistry;
import java.io.File;
import java.util.HashSet;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.MissingModsException;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;

public class Config {
    private static Configuration configuration;
    private static final String CONFIG_FILE = "config/NetherMetals.cfg";
    private static final String ORESPAWN = "OreSpawn";
    private static final String NETHERORE = "Nether Ores";
    private static final String COMPAT = "Mod Compat";
    private static final String GENERAL = "General";
    private static final String MMDLIB = "MMD Lib";

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.getModID().equals("nethermetals")) {
            Config.init();
        }
    }

    public static void init() {
        if (configuration == null) {
            configuration = new Configuration(new File(CONFIG_FILE));
            MinecraftForge.EVENT_BUS.register((Object)new Config());
        }
        Options.enableFurnaceSmelting = configuration.getBoolean("enableFurnaceSmelting", GENERAL, true, "EnableFurnaceSmelting");
        Options.explosionChance = configuration.get("mean", "OreExplosionChance", 2, "Explosion Percentage Chance\nSet to 0 to not explode").getInt();
        Options.angerPigmenRange = configuration.get("mean", "PigmenAngerRange", 20, "Anger Pigmen Range\nRequires PigmenAnger").getInt();
        Options.smeltToIngots = configuration.getBoolean("smeltToIngots", GENERAL, false, "By default nether ores smelt to 2 standard ores - with this option you get 2 ingots");
        Options.makeDusts = configuration.getBoolean("makeDusts", GENERAL, false, "Normally hitting a Nether Ore with a Crackhammer gives you 2 normal ores. With this option you get 4 dusts");
        Options.enableCoalNetherOre = configuration.getBoolean("enableCoalNetherOre", NETHERORE, true, "Enable Coal Nether Ore");
        Options.enableDiamondNetherOre = configuration.getBoolean("enableDiamondNetherOre", NETHERORE, true, "Enable Diamond Nether Ore");
        Options.enableEmeraldNetherOre = configuration.getBoolean("enableEmeraldNetherOre", NETHERORE, true, "Enable Emerald Nether Ore");
        Options.enableGoldNetherOre = configuration.getBoolean("enableGoldNetherOre", NETHERORE, true, "Enable Gold Nether Ore");
        Options.enableIronNetherOre = configuration.getBoolean("enableIronNetherOre", NETHERORE, true, "Enable Iron Nether Ore");
        Options.enableLapisNetherOre = configuration.getBoolean("enableLapisNetherOre", NETHERORE, true, "Enable Lapis Nether Ore");
        Options.enableRedstoneNetherOre = configuration.getBoolean("enableRedstoneNetherOre", NETHERORE, true, "Enable Redstone Nether Ore");
        Options.enableAntimonyNetherOre = configuration.getBoolean("enableAntimonyNetherOre", NETHERORE, true, "Enable Antimony Nether Ore");
        Options.enableBismuthNetherOre = configuration.getBoolean("enableBismuthNetherOre", NETHERORE, true, "Enable Bismuth Nether Ore");
        Options.enableCopperNetherOre = configuration.getBoolean("enableCopperNetherOre", NETHERORE, true, "Enable Copper Nether Ore");
        Options.enableLeadNetherOre = configuration.getBoolean("enableLeadNetherOre", NETHERORE, true, "Enable Lead Nether Ore");
        Options.enableMercuryNetherOre = configuration.getBoolean("enableMercuryNetherOre", NETHERORE, true, "Enable Mercury Nether Ore");
        Options.enableNickelNetherOre = configuration.getBoolean("enableNickelNetherOre", NETHERORE, true, "Enable Nickel Nether Ore");
        Options.enablePlatinumNetherOre = configuration.getBoolean("enablePlatinumNetherOre", NETHERORE, true, "Enable Platinum Nether Ore");
        Options.enableSilverNetherOre = configuration.getBoolean("enableSilverNetherOre", NETHERORE, true, "Enable Silver Nether Ore");
        Options.enableTinNetherOre = configuration.getBoolean("enableTinNetherOre", NETHERORE, true, "Enable Tin Nether Ore");
        Options.enableZincNetherOre = configuration.getBoolean("enableZincNetherOre", NETHERORE, true, "Enable Zinc Nether Ore");
        Options.enableAluminumNetherOre = configuration.getBoolean("enableAluminumNetherOre", NETHERORE, true, "Enable Aluminum Nether Ore");
        Options.enableCadmiumNetherOre = configuration.getBoolean("enableCadmiumNetherOre", NETHERORE, true, "Enable Cadmium Nether Ore");
        Options.enableChromiumNetherOre = configuration.getBoolean("enableChromiumNetherOre", NETHERORE, true, "Enable Chromium Nether Ore");
        Options.enableIridiumNetherOre = configuration.getBoolean("enableIridiumNetherOre", NETHERORE, true, "Enable Iridium Nether Ore");
        Options.enableMagnesiumNetherOre = configuration.getBoolean("enableMagnesiumNetherOre", NETHERORE, true, "Enable Magnesium Nether Ore");
        Options.enableManganeseNetherOre = configuration.getBoolean("enableManganeseNetherOre", NETHERORE, true, "Enable Manganese Nether Ore");
        Options.enableOsmiumNetherOre = configuration.getBoolean("enableOsmiumNetherOre", NETHERORE, true, "Enable Osmium Nether Ore");
        Options.enablePlutoniumNetherOre = configuration.getBoolean("enablePlutoniumNetherOre", NETHERORE, true, "Enable Plutonium Nether Ore");
        Options.enableRutileNetherOre = configuration.getBoolean("enableRutileNetherOre", NETHERORE, true, "Enable Rutile Nether Ore");
        Options.enableTantalumNetherOre = configuration.getBoolean("enableTantalumNetherOre", NETHERORE, true, "Enable Tantalum Nether Ore");
        Options.enableTitaniumNetherOre = configuration.getBoolean("enableTitaniumNetherOre", NETHERORE, true, "Enable Titanium Nether Ore");
        Options.enableTungstenNetherOre = configuration.getBoolean("enableTungstenNetherOre", NETHERORE, true, "Enable Tungsten Nether Ore");
        Options.enableUraniumNetherOre = configuration.getBoolean("enableUraniumNetherOre", NETHERORE, true, "Enable Uranium Nether Ore");
        Options.enableZirconiumNetherOre = configuration.getBoolean("enableZirconiumNetherOre", NETHERORE, true, "Enable Zirconium Nether Ore");
        Options.requireMMDLib = configuration.getBoolean("requireMMDLib", MMDLIB, false, "Require MMD Lib");
        Options.requireMMDOreSpawn = configuration.getBoolean("requireMMDOreSpawn", ORESPAWN, true, "Require MMD OreSpawn");
        Options.enableVeinminer = configuration.getBoolean("enableVeinminer", COMPAT, true, "Enable Veinminer Support");
        Options.enableTinkersConstruct = configuration.getBoolean("enableTinkersConstruct", COMPAT, false, "Enable Tinkers Construct Support");
        if (configuration.hasChanged()) {
            configuration.save();
        }
        if (Options.requireMMDOreSpawn && !Loader.isModLoaded((String)"orespawn")) {
            HashSet<DefaultArtifactVersion> orespawnMod = new HashSet<DefaultArtifactVersion>();
            orespawnMod.add(new DefaultArtifactVersion("3.0.0"));
            throw new MissingModsException(orespawnMod, "orespawn", "MMD Ore Spawn Mod");
        }
    }

    public static void postInit() {
        CrusherRecipeRegistry.getInstance().clearCache();
    }

    public static class Options {
        public static boolean makeDusts;
        public static boolean smeltToIngots;
        public static boolean requireMMDLib;
        public static boolean requireMMDOreSpawn;
        public static boolean enableTinkersConstruct;
        public static boolean enableVeinminer;
        public static int explosionChance;
        public static int angerPigmenRange;
        public static boolean angerPigmen;
        public static boolean enableFurnaceSmelting;
        public static boolean enableCoalNetherOre;
        public static boolean enableDiamondNetherOre;
        public static boolean enableEmeraldNetherOre;
        public static boolean enableGoldNetherOre;
        public static boolean enableIronNetherOre;
        public static boolean enableLapisNetherOre;
        public static boolean enableRedstoneNetherOre;
        public static boolean enableAntimonyNetherOre;
        public static boolean enableBismuthNetherOre;
        public static boolean enableCopperNetherOre;
        public static boolean enableLeadNetherOre;
        public static boolean enableMercuryNetherOre;
        public static boolean enableNickelNetherOre;
        public static boolean enablePlatinumNetherOre;
        public static boolean enableSilverNetherOre;
        public static boolean enableTinNetherOre;
        public static boolean enableZincNetherOre;
        public static boolean enableAluminumNetherOre;
        public static boolean enableCadmiumNetherOre;
        public static boolean enableChromiumNetherOre;
        public static boolean enableIridiumNetherOre;
        public static boolean enableMagnesiumNetherOre;
        public static boolean enableManganeseNetherOre;
        public static boolean enableOsmiumNetherOre;
        public static boolean enablePlutoniumNetherOre;
        public static boolean enableRutileNetherOre;
        public static boolean enableTantalumNetherOre;
        public static boolean enableTitaniumNetherOre;
        public static boolean enableTungstenNetherOre;
        public static boolean enableUraniumNetherOre;
        public static boolean enableZirconiumNetherOre;

        private Options() {
            throw new IllegalAccessError("Not a instantiable class");
        }

        public static int getExplosionChance() {
            return explosionChance;
        }

        public static boolean isAngerPigmen() {
            return angerPigmen;
        }

        public static int getAngerPigmenRange() {
            return angerPigmenRange;
        }

        static {
            requireMMDLib = false;
            requireMMDOreSpawn = true;
            enableTinkersConstruct = false;
            enableVeinminer = false;
            explosionChance = 0;
            angerPigmenRange = 0;
            angerPigmen = false;
            enableFurnaceSmelting = true;
            enableCoalNetherOre = true;
            enableDiamondNetherOre = true;
            enableEmeraldNetherOre = true;
            enableGoldNetherOre = true;
            enableIronNetherOre = true;
            enableLapisNetherOre = true;
            enableRedstoneNetherOre = true;
            enableAntimonyNetherOre = true;
            enableBismuthNetherOre = true;
            enableCopperNetherOre = true;
            enableLeadNetherOre = true;
            enableMercuryNetherOre = true;
            enableNickelNetherOre = true;
            enablePlatinumNetherOre = true;
            enableSilverNetherOre = true;
            enableTinNetherOre = true;
            enableZincNetherOre = true;
            enableAluminumNetherOre = true;
            enableCadmiumNetherOre = true;
            enableChromiumNetherOre = true;
            enableIridiumNetherOre = true;
            enableMagnesiumNetherOre = true;
            enableManganeseNetherOre = true;
            enableOsmiumNetherOre = true;
            enablePlutoniumNetherOre = true;
            enableRutileNetherOre = true;
            enableTantalumNetherOre = true;
            enableTitaniumNetherOre = true;
            enableTungstenNetherOre = true;
            enableUraniumNetherOre = true;
            enableZirconiumNetherOre = true;
        }
    }
}

