/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.nethermetals.init;

import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.registry.CrusherRecipeRegistry;
import com.mcmoddev.nethermetals.NetherMetals;
import com.mcmoddev.nethermetals.util.Config;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;

public final class Recipes {
    private Recipes() {
        throw new IllegalAccessError("Not a instantiable class");
    }

    public static void init() {
        Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"coal"));
        Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"diamond"));
        Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"emerald"));
        Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"gold"));
        Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"iron"));
        Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"lapis"));
        Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"redstone"));
        if (Loader.isModLoaded((String)"basemetals")) {
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"antimony"));
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"bismuth"));
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"copper"));
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"lead"));
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"mercury"));
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"nickel"));
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"platinum"));
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"silver"));
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"tin"));
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"zinc"));
        }
        if (Loader.isModLoaded((String)"modernmetals")) {
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"aluminum"));
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"cadmium"));
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"chromium"));
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"iridium"));
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"magnesium"));
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"manganese"));
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"osmium"));
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"plutonium"));
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"rutile"));
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"tantalum"));
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"titanium"));
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"tungsten"));
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"uranium"));
            Recipes.recipeWrapper(true, Materials.getMaterialByName((String)"zirconium"));
        }
    }

    private static void recipeWrapper(boolean enabled, MMDMaterial material) {
        if (enabled && material != null) {
            if (material.getBlock(Names.NETHERORE) != null) {
                boolean makeDusts = Config.Options.makeDusts;
                boolean smeltToIngots = Config.Options.smeltToIngots;
                if (Config.Options.enableFurnaceSmelting) {
                    if (smeltToIngots) {
                        if (material.getItem(Names.INGOT) != null) {
                            GameRegistry.addSmelting((Block)material.getBlock(Names.NETHERORE), (ItemStack)new ItemStack(material.getItem(Names.INGOT), 2), (float)1.0f);
                        } else {
                            NetherMetals.logger.error("ingot was null for material " + material.getName());
                        }
                    } else if (material.getBlock(Names.ORE) != null) {
                        GameRegistry.addSmelting((Block)material.getBlock(Names.NETHERORE), (ItemStack)new ItemStack(material.getBlock(Names.ORE), 2), (float)1.0f);
                    } else {
                        NetherMetals.logger.error("ore was null for material " + material.getName());
                    }
                }
                if (makeDusts) {
                    if (material.getItem(Names.POWDER) != null) {
                        CrusherRecipeRegistry.addNewCrusherRecipe((Block)material.getBlock(Names.NETHERORE), (ItemStack)new ItemStack(material.getItem(Names.POWDER), 4));
                    } else {
                        NetherMetals.logger.error("powder was null for material " + material.getName());
                    }
                } else if (material.getBlock(Names.ORE) != null) {
                    CrusherRecipeRegistry.addNewCrusherRecipe((Block)material.getBlock(Names.NETHERORE), (ItemStack)new ItemStack(material.getBlock(Names.ORE), 2));
                } else {
                    NetherMetals.logger.error("ore was null" + material.getName());
                }
            } else {
                NetherMetals.logger.error("oreNether was null");
            }
        }
    }
}

