/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.util.helper;

import codechicken.lib.gui.GuiDraw;
import codechicken.lib.util.ClientUtils;
import codechicken.nei.guihook.IContainerObjectHandler;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.handler.NEIClientEventHandler;
import codechicken.nei.util.LogHelper;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;

public class GuiHelper {
    private static int modelviewDepth = -1;

    public static ItemStack getStackMouseOver(GuiContainer window, boolean useContainerSlots) {
        Slot slot;
        Point mousePos = GuiDraw.getMousePosition();
        for (IContainerObjectHandler objectHandler : NEIClientEventHandler.objectHandlers) {
            ItemStack item = objectHandler.getStackUnderMouse(window, mousePos.x, mousePos.y);
            if (item.func_190926_b()) continue;
            return item;
        }
        if (useContainerSlots && (slot = GuiHelper.getSlotMouseOver(window)) != null) {
            return slot.func_75211_c();
        }
        return ItemStack.field_190927_a;
    }

    public static Slot getSlotMouseOver(GuiContainer window) {
        Point mousePos = GuiDraw.getMousePosition();
        if (GuiHelper.objectUnderMouse(window, mousePos.x, mousePos.y)) {
            return null;
        }
        return window.func_146975_c(mousePos.x, mousePos.y);
    }

    public static boolean objectUnderMouse(GuiContainer container, int mousex, int mousey) {
        for (IContainerObjectHandler objectHandler : NEIClientEventHandler.objectHandlers) {
            if (!objectHandler.objectUnderMouse(container, mousex, mousey)) continue;
            return true;
        }
        return false;
    }

    public static void clickSlot(GuiContainer window, int slotIndex, int button, ClickType clickType) {
        window.field_146297_k.field_71442_b.func_187098_a(window.field_147002_h.field_75152_c, slotIndex, button, clickType, (EntityPlayer)window.field_146297_k.field_71439_g);
    }

    public static boolean shouldShowTooltip(GuiScreen window) {
        if (!ClientUtils.inWorld()) {
            return false;
        }
        for (IContainerObjectHandler handler : NEIClientEventHandler.objectHandlers) {
            if (handler.shouldShowTooltip(window)) continue;
            return false;
        }
        return Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o().func_190926_b();
    }

    public static void enable3DRender() {
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    public static void enable2DRender() {
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
    }

    public static void enableMatrixStackLogging() {
        modelviewDepth = GL11.glGetInteger((int)2979);
    }

    public static void disableMatrixStackLogging() {
        modelviewDepth = -1;
    }

    public static boolean checkMatrixStack() {
        return modelviewDepth < 0 || GL11.glGetInteger((int)2979) == modelviewDepth;
    }

    public static void restoreMatrixStack() {
        if (modelviewDepth >= 0) {
            for (int i = GL11.glGetInteger((int)2979); i > modelviewDepth; --i) {
                GlStateManager.func_179121_F();
            }
        }
    }

    public static RenderItem getRenderItem() {
        return Minecraft.func_71410_x().func_175599_af();
    }

    public static FontRenderer getFontRenderer(ItemStack stack) {
        FontRenderer f;
        if (!stack.func_190926_b() && stack.func_77973_b() != null && (f = stack.func_77973_b().getFontRenderer(stack)) != null) {
            return f;
        }
        return GuiDraw.fontRenderer;
    }

    public static void drawItem(int i, int j, ItemStack itemstack) {
        GuiHelper.drawItem(i, j, itemstack, GuiHelper.getFontRenderer(itemstack));
    }

    public static void drawItem(int i, int j, ItemStack itemstack, FontRenderer fontRenderer) {
        GuiHelper.enable3DRender();
        RenderItem drawItems = GuiHelper.getRenderItem();
        float zLevel = drawItems.field_77023_b += 100.0f;
        try {
            drawItems.func_180450_b(itemstack, i, j);
            drawItems.func_175030_a(fontRenderer, itemstack, i, j);
            if (!GuiHelper.checkMatrixStack()) {
                throw new IllegalStateException("Modelview matrix stack too deep");
            }
            if (Tessellator.func_178181_a().func_178180_c().field_179010_r) {
                throw new IllegalStateException("Still drawing");
            }
        }
        catch (Exception e) {
            LogHelper.errorOnce(e, itemstack.toString(), "Error whilst rendering: " + itemstack, new Object[0]);
            GuiHelper.restoreMatrixStack();
            if (Tessellator.func_178181_a().func_178180_c().field_179010_r) {
                Tessellator.func_178181_a().func_78381_a();
            }
            drawItems.field_77023_b = zLevel;
            drawItems.func_175042_a(new ItemStack(Blocks.field_150348_b), i, j);
        }
        GuiHelper.enable2DRender();
        drawItems.field_77023_b = zLevel - 100.0f;
    }

    public static List<String> itemDisplayNameMultiline(ItemStack itemstack, GuiContainer gui, boolean includeHandlers) {
        ArrayList<String> namelist = null;
        try {
            namelist = itemstack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (namelist == null) {
            namelist = new ArrayList<String>();
        }
        if (namelist.size() == 0) {
            namelist.add("Unnamed");
        }
        if (namelist.get(0) == null || ((String)namelist.get(0)).equals("")) {
            namelist.set(0, "Unnamed");
        }
        if (includeHandlers) {
            for (IContainerTooltipHandler handler : NEIClientEventHandler.tooltipHandlers) {
                handler.handleItemDisplayName((GuiScreen)gui, itemstack, namelist);
            }
        }
        namelist.set(0, itemstack.func_77953_t().field_77937_e.toString() + (String)namelist.get(0));
        for (int i = 1; i < namelist.size(); ++i) {
            namelist.set(i, "\u00a77" + (String)namelist.get(i));
        }
        return namelist;
    }

    public static String itemDisplayNameShort(ItemStack itemstack) {
        List<String> list = GuiHelper.itemDisplayNameMultiline(itemstack, null, false);
        return list.get(0);
    }

    public static String concatenatedDisplayName(ItemStack itemstack, boolean includeHandlers) {
        List<String> list = GuiHelper.itemDisplayNameMultiline(itemstack, null, includeHandlers);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String name : list) {
            if (first) {
                first = false;
            } else {
                sb.append("#");
            }
            sb.append(name);
        }
        return TextFormatting.func_110646_a((String)sb.toString());
    }
}

