/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.layout;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIController;
import codechicken.nei.VisibilityData;
import codechicken.nei.layout.LayoutStyle;
import codechicken.nei.util.NEIClientUtils;
import codechicken.nei.widget.Button;
import codechicken.nei.widget.action.NEIActions;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public abstract class LayoutStyleDefault
extends LayoutStyle {
    @Override
    public void layout(GuiContainer gui, VisibilityData visiblity) {
        int i;
        int windowWidth = gui.field_146294_l;
        int windowHeight = gui.field_146295_m;
        int containerWidth = gui.field_146999_f;
        int containerLeft = gui.field_147003_i;
        this.reset();
        LayoutManager.prev.y = 2;
        LayoutManager.prev.h = 16;
        LayoutManager.prev.w = containerLeft / 3;
        LayoutManager.prev.x = (containerWidth + windowWidth) / 2 + 2;
        LayoutManager.next.x = windowWidth - LayoutManager.prev.w - 2;
        LayoutManager.next.y = LayoutManager.prev.y;
        LayoutManager.next.w = LayoutManager.prev.w;
        LayoutManager.next.h = LayoutManager.prev.h;
        LayoutManager.pageLabel.x = containerLeft * 3 / 2 + containerWidth + 1;
        LayoutManager.pageLabel.y = LayoutManager.prev.y + 5;
        LayoutManager.pageLabel.text = "(" + LayoutManager.itemPanel.getPage() + "/" + LayoutManager.itemPanel.getNumPages() + ")";
        LayoutManager.itemPanel.y = LayoutManager.prev.h + LayoutManager.prev.y;
        LayoutManager.itemPanel.x = (containerWidth + windowWidth) / 2 + 3;
        LayoutManager.itemPanel.w = windowWidth - 3 - LayoutManager.itemPanel.x;
        LayoutManager.itemPanel.h = windowHeight - 15 - LayoutManager.itemPanel.y;
        if (!NEIClientConfig.canPerformAction("item")) {
            LayoutManager.itemPanel.h += 15;
        }
        LayoutManager.itemPanel.resize();
        LayoutManager.less.h = 16;
        LayoutManager.less.w = 16;
        LayoutManager.more.h = 16;
        LayoutManager.more.w = 16;
        LayoutManager.less.x = LayoutManager.prev.x;
        LayoutManager.more.x = windowWidth - LayoutManager.less.w - 2;
        LayoutManager.more.y = LayoutManager.less.y = windowHeight - LayoutManager.more.h - 2;
        LayoutManager.quantity.x = LayoutManager.less.x + LayoutManager.less.w + 2;
        LayoutManager.quantity.y = LayoutManager.less.y;
        LayoutManager.quantity.w = LayoutManager.more.x - LayoutManager.quantity.x - 2;
        LayoutManager.quantity.h = LayoutManager.less.h;
        LayoutManager.options.x = NEIClientConfig.isEnabled() ? 0 : 6;
        LayoutManager.options.y = NEIClientConfig.isEnabled() ? windowHeight - 22 : windowHeight - 28;
        LayoutManager.options.w = 80;
        LayoutManager.options.h = 22;
        LayoutManager.delete.state = 4;
        if (NEIController.getDeleteMode()) {
            LayoutManager.delete.state |= 1;
        } else if (!visiblity.enableDeleteMode) {
            LayoutManager.delete.state |= 2;
        }
        LayoutManager.rain.state = 4;
        if (NEIClientConfig.disabledActions.contains("rain")) {
            LayoutManager.rain.state |= 2;
        } else if (NEIClientUtils.isRaining()) {
            LayoutManager.rain.state |= 1;
        }
        LayoutManager.gamemode.state = 4;
        if (NEIClientUtils.getGamemode() != 0) {
            LayoutManager.gamemode.state |= 1;
            LayoutManager.gamemode.index = NEIClientUtils.getGamemode() - 1;
        } else if (NEIClientUtils.isValidGamemode("creative")) {
            LayoutManager.gamemode.index = 0;
        } else if (NEIClientUtils.isValidGamemode("creative+")) {
            LayoutManager.gamemode.index = 1;
        } else if (NEIClientUtils.isValidGamemode("adventure")) {
            LayoutManager.gamemode.index = 2;
        }
        LayoutManager.magnet.state = 4 | (NEIClientConfig.isMagnetModeEnabled() ? 1 : 0);
        if (NEIClientConfig.canPerformAction("delete")) {
            this.layoutButton(LayoutManager.delete);
        }
        if (NEIClientConfig.canPerformAction("rain")) {
            this.layoutButton(LayoutManager.rain);
        }
        if (NEIClientUtils.isValidGamemode("creative") || NEIClientUtils.isValidGamemode("creative+") || NEIClientUtils.isValidGamemode("adventure")) {
            this.layoutButton(LayoutManager.gamemode);
        }
        if (NEIClientConfig.canPerformAction("magnet")) {
            this.layoutButton(LayoutManager.magnet);
        }
        if (NEIClientConfig.canPerformAction("time")) {
            for (int i2 = 0; i2 < 4; ++i2) {
                LayoutManager.timeButtons[i2].state = NEIClientConfig.disabledActions.contains(NEIActions.timeZones[i2]) ? 2 : 0;
                this.layoutButton(LayoutManager.timeButtons[i2]);
            }
        }
        if (NEIClientConfig.canPerformAction("heal")) {
            this.layoutButton(LayoutManager.heal);
        }
        LayoutManager.searchField.y = windowHeight - LayoutManager.searchField.h - 2;
        LayoutManager.dropDown.h = 20;
        LayoutManager.dropDown.w = LayoutManager.prev.x - LayoutManager.dropDown.x - 3;
        LayoutManager.searchField.h = 20;
        LayoutManager.searchField.w = 150;
        LayoutManager.searchField.x = (windowWidth - LayoutManager.searchField.w) / 2;
        if (!visiblity.showSearchSection) {
            LayoutManager.searchField.setFocus(false);
        }
        int maxWidth = 0;
        for (i = 0; i < 7; ++i) {
            LayoutManager.deleteButtons[i].w = 16;
            LayoutManager.deleteButtons[i].h = 16;
            NBTTagCompound statelist = NEIClientConfig.global.nbt.func_74775_l("statename");
            NEIClientConfig.global.nbt.func_74782_a("statename", (NBTBase)statelist);
            String name = statelist.func_74779_i("" + i);
            if (statelist.func_74781_a("" + i) == null) {
                name = "" + (i + 1);
                statelist.func_74778_a("" + i, name);
            }
            LayoutManager.stateButtons[i].label = name;
            LayoutManager.stateButtons[i].saved = NEIClientConfig.isStateSaved(i);
            int width = GuiDraw.getStringWidth((String)LayoutManager.stateButtons[i].getRenderLabel()) + 26;
            if (width + 22 > containerLeft) {
                width = containerLeft - 22;
            }
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        for (i = 0; i < 7; ++i) {
            LayoutManager.stateButtons[i].x = 0;
            LayoutManager.stateButtons[i].y = 58 + i * 22;
            LayoutManager.stateButtons[i].h = 20;
            LayoutManager.stateButtons[i].x = 0;
            LayoutManager.stateButtons[i].w = maxWidth;
            LayoutManager.deleteButtons[i].x = LayoutManager.stateButtons[i].w + 3;
            LayoutManager.deleteButtons[i].y = LayoutManager.stateButtons[i].y + 2;
        }
    }

    public abstract void layoutButton(Button var1);
}

