/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.storage;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;

public class ExternalSaveHandler
implements ISaveHandler {
    private final File mapDataDir;
    private final long initializationTime = MinecraftServer.func_130071_aq();

    public ExternalSaveHandler(File directory, String savename) {
        this.mapDataDir = new File(directory, savename);
        this.mapDataDir.mkdirs();
        this.setSessionLock();
    }

    private void setSessionLock() {
        try {
            File file1 = new File(this.mapDataDir, "session.lock");
            try (DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(file1));){
                dataoutputstream.writeLong(this.initializationTime);
            }
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            throw new RuntimeException("Failed to check session lock, aborting");
        }
    }

    public File func_75765_b() {
        return this.mapDataDir;
    }

    public void func_75762_c() throws MinecraftException {
        try {
            File file1 = new File(this.mapDataDir, "session.lock");
            try (DataInputStream datainputstream = new DataInputStream(new FileInputStream(file1));){
                if (datainputstream.readLong() != this.initializationTime) {
                    throw new MinecraftException("The save is being accessed from another location, aborting");
                }
            }
        }
        catch (IOException ioexception) {
            throw new MinecraftException("Failed to check session lock, aborting");
        }
    }

    public IChunkLoader func_75763_a(WorldProvider p_75763_1_) {
        throw new RuntimeException("Chunk storage is not supported on this save handler");
    }

    public WorldInfo func_75757_d() {
        throw new RuntimeException("World info is not supported on this save handler");
    }

    public void func_75755_a(WorldInfo p_75755_1_, NBTTagCompound p_75755_2_) {
    }

    public void func_75761_a(WorldInfo p_75761_1_) {
    }

    public void writePlayerData(EntityPlayer p_75753_1_) {
    }

    public NBTTagCompound readPlayerData(EntityPlayer p_75752_1_) {
        throw new RuntimeException("Player data is not supported on this save handler");
    }

    public IPlayerFileData func_75756_e() {
        return null;
    }

    public String[] getAvailablePlayerDat() {
        throw new RuntimeException("Player data is not supported on this save handler");
    }

    public void func_75759_a() {
    }

    public File func_75758_b(String dataname) {
        return new File(this.mapDataDir, dataname + ".dat");
    }

    public TemplateManager func_186340_h() {
        return null;
    }
}

