/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.gen.feature;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenMystBigTree
extends WorldGenerator {
    static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};
    Random rand;
    World worldObj;
    int[] basePos = new int[]{0, 0, 0};
    int[] trueBase = new int[]{0, 0, 0};
    int heightLimit = 0;
    int height;
    double heightAttenuation = 0.9;
    double scaleWidth = 0.2;
    double leafDensity = 0.8;
    int trunkSize = 2;
    int heightLimitLimit;
    int leafDistanceLimit = 3;
    int[][] leafNodes;
    private static int max_height = 50;

    public WorldGenMystBigTree(boolean flag) {
        super(flag);
        this.rand = new Random();
        this.heightLimitLimit = max_height;
    }

    void generateLeafNodeList() {
        this.height = (int)((double)this.heightLimit * this.heightAttenuation);
        if (this.height >= this.heightLimit) {
            this.height = this.heightLimit - 1;
        }
        if (this.height < max_height / 2) {
            return;
        }
        int i = 4;
        if (i < 1) {
            i = 1;
        }
        int[][] ai = new int[i * this.heightLimit][4];
        int j = this.basePos[1] + this.heightLimit - this.leafDistanceLimit;
        int k = 1;
        int l = this.basePos[1] + this.height;
        int i1 = j - this.basePos[1];
        ai[0][0] = this.basePos[0];
        ai[0][1] = j--;
        ai[0][2] = this.basePos[2];
        ai[0][3] = l;
        int[] ai1 = new int[]{0, 0, 0};
        int[] ai2 = new int[]{0, 0, 0};
        int[] ai3 = new int[]{this.basePos[0], 0, this.basePos[2]};
        double d = 0.5;
        while (i1 >= 0) {
            float f = this.layerSize(i1);
            if (f < 0.0f) {
                --j;
                --i1;
                continue;
            }
            for (int j1 = 0; j1 < i; ++j1) {
                double d1 = this.scaleWidth * ((double)f * ((double)this.rand.nextFloat() + 3.0));
                double d2 = (double)this.rand.nextFloat() * 2.0 * 3.14159;
                int k1 = MathHelper.func_76128_c((double)(d1 * Math.sin(d2) + (double)this.basePos[0] + d));
                int l1 = MathHelper.func_76128_c((double)(d1 * Math.cos(d2) + (double)this.basePos[2] + d));
                ai1[0] = k1;
                ai1[1] = j;
                ai1[2] = l1;
                ai2[0] = k1;
                ai2[1] = j + this.leafDistanceLimit;
                ai2[2] = l1;
                if (this.checkBlockLine(ai1, ai2) != -1) continue;
                ai3[1] = j - 2;
                if (this.checkBlockLine(ai3, ai1) != -1) continue;
                ai[k][0] = k1;
                ai[k][1] = j;
                ai[k][2] = l1;
                ai[k][3] = ai3[1];
                ++k;
            }
            --j;
            --i1;
        }
        this.leafNodes = new int[k][4];
        System.arraycopy(ai, 0, this.leafNodes, 0, k);
    }

    void genTreeLayer(int i, int j, int k, float f, byte byte0, IBlockState block) {
        int i1 = (int)((double)f + 0.618);
        float f2 = f * f;
        byte byte1 = otherCoordPairs[byte0];
        byte byte2 = otherCoordPairs[byte0 + 3];
        int[] ai = new int[]{i, j, k};
        int[] ai1 = new int[]{0, 0, 0};
        ai1[byte0] = ai[byte0];
        for (int j1 = -i1; j1 <= i1; ++j1) {
            ai1[byte1] = ai[byte1] + j1;
            for (int l1 = -i1; l1 <= i1; ++l1) {
                if (!(Math.pow((double)j1 + 0.5, 2.0) + Math.pow((double)l1 + 0.5, 2.0) < (double)f2)) continue;
                ai1[byte2] = ai[byte2] + l1;
                this.func_175903_a(this.worldObj, new BlockPos(ai1[0], ai1[1], ai1[2]), block);
            }
        }
    }

    float layerSize(int i) {
        if ((double)i < (double)this.heightLimit * 0.75) {
            return -1.618f;
        }
        float f = (float)this.heightLimit * 0.5f;
        float f1 = (float)this.heightLimit * 0.5f - (float)i;
        float f2 = f1 == 0.0f ? f : (Math.abs(f1) >= f ? 0.0f : (float)WorldGenMystBigTree.sqrt(Math.pow(f, 2.0) - Math.pow(f1, 2.0)));
        return f2 *= 0.5f;
    }

    public static double sqrt(double a) {
        long x = Double.doubleToLongBits(a) >> 32;
        double y = Double.longBitsToDouble(x + 1072632448L << 31);
        return y;
    }

    float leafSize(int i) {
        if (i < 0 || i >= this.leafDistanceLimit) {
            return -1.0f;
        }
        return i != 0 && i != this.leafDistanceLimit - 1 ? 3.0f : 2.0f;
    }

    void generateLeafNode(int i, int j, int k) {
        int i1 = j + this.leafDistanceLimit;
        for (int l = j; l < i1; ++l) {
            float f = this.leafSize(l - j);
            if (f < 0.0f) continue;
            this.genTreeLayer(i, l, k, f, (byte)1, Blocks.field_150362_t.func_176223_P());
        }
    }

    void placeBlockLine(int[] ai, int[] ai1, IBlockState i) {
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return;
        }
        byte byte1 = otherCoordPairs[j];
        byte byte2 = otherCoordPairs[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            this.func_175903_a(this.worldObj, new BlockPos(ai3[0], ai3[1], ai3[2]), i);
        }
    }

    void generateLeaves() {
        for (int i = 0; i < this.leafNodes.length; ++i) {
            int k = this.leafNodes[i][0];
            int l = this.leafNodes[i][1];
            int i1 = this.leafNodes[i][2];
            this.generateLeafNode(k, l, i1);
        }
    }

    boolean leafNodeNeedsBase(int i) {
        return (double)i >= (double)this.heightLimit * 0.2;
    }

    void generateTrunk() {
        int i = this.trueBase[0];
        int j = this.trueBase[1];
        int k = this.basePos[1] + this.height;
        int l = this.trueBase[2];
        int[] ai = new int[]{i, j, l};
        int[] ai1 = new int[]{i, k, l};
        this.placeBlockLine(ai, ai1, Blocks.field_150364_r.func_176223_P());
        if (this.trunkSize == 2) {
            ai[0] = ai[0] + 1;
            ai1[0] = ai1[0] + 1;
            this.placeBlockLine(ai, ai1, Blocks.field_150364_r.func_176223_P());
            ai[2] = ai[2] + 1;
            ai1[2] = ai1[2] + 1;
            this.placeBlockLine(ai, ai1, Blocks.field_150364_r.func_176223_P());
            ai[0] = ai[0] - 1;
            ai1[0] = ai1[0] - 1;
            this.placeBlockLine(ai, ai1, Blocks.field_150364_r.func_176223_P());
        }
    }

    void generateRoots() {
        int i = this.trueBase[0];
        int j = this.trueBase[1];
        int k = this.trueBase[2];
        int[] ai = new int[]{i, j + 1, k};
        int[] ai1 = new int[]{i, j, k};
        int range = this.height >> 2;
        for (int c = 0; c < range; ++c) {
            ai[0] = i + c % 2;
            ai[2] = k + (c > 2 ? 1 : 0);
            ai1[0] = i + this.rand.nextInt(9) - 4;
            ai1[1] = j - this.rand.nextInt(range + 1) - 3;
            ai1[2] = k + this.rand.nextInt(9) - 4;
            this.placeBlockLine(ai, ai1, Blocks.field_150364_r.func_176223_P());
        }
    }

    void generateLeafNodeBases() {
        int j = this.leafNodes.length;
        int[] ai = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        for (int i = 0; i < j; ++i) {
            int[] ai1 = this.leafNodes[i];
            int[] ai2 = new int[]{ai1[0], ai1[1], ai1[2]};
            ai[1] = ai1[3];
            int k = ai[1] - this.basePos[1];
            if (!this.leafNodeNeedsBase(k)) continue;
            this.placeBlockLine(ai, ai2, Blocks.field_150364_r.func_176223_P());
        }
    }

    int checkBlockLine(int[] ai, int[] ai1) {
        return -1;
    }

    boolean validTreeLocation() {
        int[] ai = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        IBlockState block = this.getBlock(this.basePos[0], this.basePos[1] - 1, this.basePos[2]);
        while (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            this.basePos[1] = this.basePos[1] - 1;
            block = this.getBlock(this.basePos[0], this.basePos[1] - 1, this.basePos[2]);
        }
        if (block.func_177230_c() != Blocks.field_150346_d && block.func_177230_c() != Blocks.field_150349_c) {
            return false;
        }
        int[] ai1 = new int[]{this.basePos[0], this.basePos[1] + this.heightLimit - 1, this.basePos[2]};
        int j = this.checkBlockLine(ai, ai1);
        if (j == -1) {
            return true;
        }
        if (j < max_height / 2) {
            return false;
        }
        this.heightLimit = j;
        return true;
    }

    private IBlockState getBlock(int i, int j, int k) {
        if (i >> 4 != this.trueBase[0] >> 4 || k >> 4 != this.trueBase[2] >> 4) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return this.worldObj.func_180495_p(new BlockPos(i, j, k));
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        this.worldObj = world;
        long l = random.nextLong();
        this.rand.setSeed(l);
        this.trueBase[0] = this.basePos[0] = pos.func_177958_n();
        this.basePos[1] = pos.func_177956_o();
        this.trueBase[2] = this.basePos[2] = pos.func_177952_p();
        if (this.heightLimit == 0) {
            this.heightLimit = 20 + this.rand.nextInt(this.heightLimitLimit);
        }
        if (!this.validTreeLocation()) {
            return false;
        }
        this.trueBase[1] = this.basePos[1];
        this.basePos[1] = Math.max(this.trueBase[1], 128 - this.heightLimit - this.rand.nextInt(16));
        this.generateLeafNodeList();
        if (this.height < max_height / 2) {
            return false;
        }
        this.generateLeaves();
        this.generateTrunk();
        this.generateRoots();
        this.generateLeafNodeBases();
        return true;
    }
}

