/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.biome;

import com.xcompwiz.mystcraft.api.util.Color;
import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.MinecraftDummyContainer;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiomeWrapperMyst
extends Biome {
    private final WorldProviderMyst provider;
    private final Biome baseBiome;

    private static Biome.BiomeProperties generateBiomeProperties(WorldProviderMyst provider, Biome biome) {
        Biome.BiomeProperties properties = new Biome.BiomeProperties(biome.func_185359_l());
        properties.func_185398_c(biome.func_185355_j());
        properties.func_185400_d(biome.func_185360_m());
        if (provider != null) {
            ResourceLocation biomeIdentifier = biome.getRegistryName();
            properties.func_185410_a(provider.getTemperature(biome.func_185353_n(), biomeIdentifier));
            properties.func_185395_b(provider.getRainfall(biome.func_76727_i(), biomeIdentifier));
        } else {
            properties.func_185410_a(biome.func_185353_n());
            properties.func_185395_b(biome.func_76727_i());
        }
        properties.func_185402_a(biome.func_185361_o());
        if (!biome.func_76738_d()) {
            properties.func_185396_a();
        }
        if (biome.func_76746_c()) {
            properties.func_185411_b();
        }
        if (biome.func_185363_b()) {
            properties.func_185399_a("mutant");
        }
        return properties;
    }

    public BiomeWrapperMyst(WorldProviderMyst provider, Biome baseBiome) {
        super(BiomeWrapperMyst.generateBiomeProperties(provider, baseBiome));
        ModContainer active = Loader.instance().activeModContainer();
        String makeActiveId = baseBiome.getRegistryName().func_110624_b();
        MinecraftDummyContainer tryActive = "minecraft".equals(makeActiveId) ? Loader.instance().getMinecraftModContainer() : (ModContainer)Loader.instance().getIndexedModList().get(makeActiveId);
        Loader.instance().setActiveModContainer((ModContainer)tryActive);
        this.setRegistryName(baseBiome.getRegistryName());
        Loader.instance().setActiveModContainer(active);
        this.provider = provider;
        this.baseBiome = baseBiome;
        this.field_76760_I = baseBiome.field_76760_I;
        this.field_76752_A = baseBiome.field_76752_A;
        this.field_76753_B = baseBiome.field_76753_B;
        this.field_76761_J = null;
        this.field_76762_K = null;
        this.field_76755_L = null;
        this.field_82914_M = null;
    }

    public BiomeDecorator func_76729_a() {
        if (this.baseBiome == null) {
            return null;
        }
        return this.baseBiome.field_76760_I;
    }

    public boolean func_185363_b() {
        return this.baseBiome.func_185363_b();
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return this.baseBiome.func_150567_a(rand);
    }

    public WorldGenerator func_76730_b(Random par1Random) {
        return this.baseBiome.func_76730_b(par1Random);
    }

    public BlockFlower.EnumFlowerType func_180623_a(Random rand, BlockPos pos) {
        return this.baseBiome.func_180623_a(rand, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float temp) {
        return this.baseBiome.func_76731_a(temp);
    }

    public List<Biome.SpawnListEntry> func_76747_a(EnumCreatureType par1EnumCreatureType) {
        return this.baseBiome.func_76747_a(par1EnumCreatureType);
    }

    public boolean func_76746_c() {
        if (this.provider == null) {
            return this.baseBiome.func_76746_c();
        }
        return this.provider.getEnableSnow(this.baseBiome.func_76746_c(), this.baseBiome.getRegistryName());
    }

    public boolean func_76738_d() {
        if (this.provider == null) {
            return this.baseBiome.func_76738_d();
        }
        return this.func_76746_c() ? false : this.provider.getEnableRain(this.baseBiome.func_76738_d(), this.baseBiome.getRegistryName());
    }

    public boolean func_76736_e() {
        return this.baseBiome.func_76736_e();
    }

    public float func_76741_f() {
        return this.baseBiome.func_76741_f();
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        this.baseBiome.func_180624_a(worldIn, rand, pos);
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        this.baseBiome.func_180622_a(worldIn, rand, chunkPrimerIn, x, z, noiseVal);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        if (this.provider == null) {
            return this.baseBiome.func_180627_b(pos);
        }
        Color color = this.provider.getStaticColor("grass", this.baseBiome, pos);
        if (color != null) {
            return this.getModdedBiomeGrassColor(color.asInt());
        }
        return this.baseBiome.func_180627_b(pos);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        if (this.provider == null) {
            return this.baseBiome.func_180625_c(pos);
        }
        Color color = this.provider.getStaticColor("foliage", this.baseBiome, pos);
        if (color != null) {
            return this.getModdedBiomeFoliageColor(color.asInt());
        }
        return this.baseBiome.func_180625_c(pos);
    }

    public Class<? extends Biome> func_150562_l() {
        return this.baseBiome.func_150562_l();
    }

    public Biome.TempCategory func_150561_m() {
        return this.baseBiome.func_150561_m();
    }

    public int getWaterColorMultiplier() {
        return this.getWaterColorMultiplier(BlockPos.field_177992_a);
    }

    public int getWaterColorMultiplier(BlockPos pos) {
        if (this.provider == null) {
            return this.baseBiome.getWaterColorMultiplier();
        }
        Color color = this.provider.getStaticColor("water", this.baseBiome, pos);
        if (color != null) {
            return this.getModdedBiomeWaterColor(color.asInt());
        }
        return this.baseBiome.getWaterColorMultiplier();
    }

    public int getModdedBiomeWaterColor(int original) {
        BiomeEvent.GetWaterColor event = new BiomeEvent.GetWaterColor(this.baseBiome, original);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getNewColor();
    }
}

