/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.tileentity;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.data.InkEffects;
import com.xcompwiz.mystcraft.data.ModLinkEffects;
import com.xcompwiz.mystcraft.fluids.FluidUtils;
import com.xcompwiz.mystcraft.inventory.IItemBuilder;
import com.xcompwiz.mystcraft.item.ItemPage;
import com.xcompwiz.mystcraft.nbt.NBTUtils;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.tileentity.IOInventory;
import com.xcompwiz.mystcraft.tileentity.InventoryFilter;
import com.xcompwiz.mystcraft.tileentity.InventoryUpdateListener;
import com.xcompwiz.mystcraft.tileentity.TileEntityBase;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityInkMixer
extends TileEntityBase
implements IItemBuilder,
InventoryFilter,
InventoryUpdateListener,
ITickable {
    private IOInventory inventory;
    private boolean hasInk = false;
    private HashMap<String, Float> ink_probabilities = new HashMap();
    private long next_seed = new Random().nextLong();
    private static final int ink_in = 0;
    private static final int ink_out = 2;
    private static final int paper = 1;

    public TileEntityInkMixer() {
        this.inventory = this.buildInventory();
    }

    protected IOInventory buildInventory() {
        return new IOInventory(this, new int[]{0, 1}, new int[]{2}, EnumFacing.field_82609_l).setListener(this).applyFilter(this, 0, 1);
    }

    @Override
    public void onChange() {
        this.markForUpdate();
    }

    @Override
    public boolean canAcceptItem(int slot, @Nonnull ItemStack stack) {
        FluidStack fluidStack;
        if (stack.func_190926_b()) {
            return false;
        }
        if (slot == 0 && (fluidStack = FluidUtil.getFluidContained((ItemStack)stack)) != null) {
            return Mystcraft.validInks.contains(fluidStack.getFluid().getName());
        }
        return slot == 1 && stack.func_77973_b().equals(Items.field_151121_aF);
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.inventory.readNBT(compound.func_74775_l("inventory"));
        this.hasInk = compound.func_74767_n("ink");
        this.ink_probabilities = NBTUtils.readFloatMap(compound.func_74775_l("probabilities"), new HashMap());
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.writeNBT());
        compound.func_74757_a("ink", this.hasInk);
        compound.func_74782_a("probabilities", (NBTBase)NBTUtils.writeFloatMap(new NBTTagCompound(), this.ink_probabilities));
    }

    @Override
    public void buildItem(@Nonnull ItemStack itemstack, @Nonnull EntityPlayer player) {
        if (!this.canBuildItem()) {
            return;
        }
        if (itemstack.func_77973_b() instanceof ItemPage) {
            Random rand = new Random(this.next_seed);
            for (Map.Entry<String, Float> entry : this.ink_probabilities.entrySet()) {
                float f = entry.getValue().floatValue() * 100.0f;
                int i = rand.nextInt(100);
                if (!((float)i < f)) continue;
                Page.addLinkProperty(itemstack, entry.getKey());
            }
            this.next_seed = rand.nextLong();
            this.hasInk = false;
            this.ink_probabilities.clear();
            this.inventory.getStackInSlot(1).func_190918_g(1);
            this.markForUpdate();
        } else {
            itemstack.func_190920_e(0);
        }
    }

    private boolean canBuildItem() {
        return !this.inventory.getStackInSlot(1).func_190926_b() && this.inventory.getStackInSlot(1).func_77973_b().equals(Items.field_151121_aF) && this.hasInk;
    }

    @Nonnull
    public ItemStack getCraftedItem() {
        if (!this.canBuildItem()) {
            return ItemStack.field_190927_a;
        }
        return Page.createLinkPage();
    }

    public boolean getHasInk() {
        return this.hasInk;
    }

    public void setHasInk(boolean b) {
        this.hasInk = b;
    }

    public long getNextSeed() {
        return this.next_seed;
    }

    public void setNextSeed(long seed) {
        this.next_seed = seed;
    }

    public void func_73660_a() {
        ItemStack result;
        ItemStack fluidContainer;
        ItemStack emptyContainer;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!(this.inventory.getStackInSlot(0).func_190926_b() || this.hasInk || !(emptyContainer = (fluidContainer = this.inventory.getStackInSlot(0)).func_77973_b().getContainerItem(fluidContainer)).func_190926_b() && this.mergeItemStacksLeft(this.inventory.getStackInSlot(2), emptyContainer) == this.inventory.getStackInSlot(2) || (result = this.fillBasinWithContainer(fluidContainer)).func_190926_b())) {
            this.inventory.setStackInSlot(2, this.mergeItemStacksLeft(this.inventory.getStackInSlot(2), result));
            if (fluidContainer.func_190916_E() <= 0) {
                this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
            }
        }
    }

    @Nonnull
    private ItemStack fillBasinWithContainer(@Nonnull ItemStack containerStack) {
        ItemStack container = containerStack.func_77946_l();
        container.func_190920_e(1);
        FluidStack contained = FluidUtil.getFluidContained((ItemStack)container);
        if (contained != null) {
            if (!Mystcraft.validInks.contains(contained.getFluid().getName())) {
                return ItemStack.field_190927_a;
            }
            int used = 1000;
            if (used == contained.amount) {
                containerStack.func_190918_g(1);
                this.hasInk = true;
                container = FluidUtils.emptyContainer(container);
                return container;
            }
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    private ItemStack mergeItemStacksLeft(@Nonnull ItemStack left, @Nonnull ItemStack right) {
        if (right.func_190926_b()) {
            return left;
        }
        if (left.func_190926_b()) {
            return right;
        }
        if (left.func_77973_b() != right.func_77973_b()) {
            return left;
        }
        if (left.func_77942_o() != right.func_77942_o()) {
            return left;
        }
        if (left.func_77942_o() && !left.func_77978_p().equals((Object)right.func_77978_p())) {
            return left;
        }
        if (left.func_77973_b().func_77614_k() && left.func_77952_i() != right.func_77952_i()) {
            return left;
        }
        if (left.func_190916_E() + right.func_190916_E() > left.func_77976_d()) {
            return left;
        }
        left = left.func_77946_l();
        left.func_190917_f(right.func_190916_E());
        right.func_190920_e(0);
        return left;
    }

    public Map<String, Float> getInkProperties() {
        return Collections.unmodifiableMap(this.ink_probabilities);
    }

    @Nonnull
    public ItemStack addItems(@Nonnull ItemStack itemstack, int amount) {
        Map<String, Float> itemprobs = InkEffects.getItemEffects(itemstack);
        if (itemprobs == null) {
            return itemstack;
        }
        float total = 0.0f;
        for (Map.Entry<String, Float> entry : itemprobs.entrySet()) {
            if (entry.getKey().equals("") || !this.isPropertyAllowed(entry.getKey())) continue;
            total += entry.getValue().floatValue();
        }
        float inverse = 1.0f - total;
        if (amount > itemstack.func_190916_E()) {
            amount = itemstack.func_190916_E();
        }
        for (int i = 0; i < amount; ++i) {
            itemstack.func_190918_g(1);
            for (Map.Entry<String, Float> entry : this.ink_probabilities.entrySet()) {
                entry.setValue(Float.valueOf(entry.getValue().floatValue() * inverse));
            }
            for (Map.Entry<String, Float> entry : itemprobs.entrySet()) {
                if (entry.getKey().equals("") || !this.isPropertyAllowed(entry.getKey())) continue;
                float prob = entry.getValue().floatValue();
                Float f = this.ink_probabilities.get(entry.getKey());
                if (f != null) {
                    prob += f.floatValue();
                }
                this.ink_probabilities.put(entry.getKey(), Float.valueOf(prob));
            }
        }
        if (itemstack.func_190916_E() <= 0) {
            itemstack = ItemStack.field_190927_a;
        }
        return itemstack;
    }

    private boolean isPropertyAllowed(String property) {
        return ModLinkEffects.isPropertyAllowed(property);
    }

    private void addTraitWithProbability(String trait, float prob) {
        float inverse = 1.0f - prob;
        for (Map.Entry<String, Float> entry : this.ink_probabilities.entrySet()) {
            entry.setValue(Float.valueOf(entry.getValue().floatValue() * inverse));
        }
        if (trait.equals("")) {
            return;
        }
        Float f = this.ink_probabilities.get(trait);
        if (f != null) {
            prob += f.floatValue();
        }
        this.ink_probabilities.put(trait, Float.valueOf(prob));
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.inventory.hasCapability(facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory.getCapability(facing);
        }
        return null;
    }
}

