/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.util.Color;
import com.xcompwiz.mystcraft.api.util.ColorGradient;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.symbol.symbols.CelestialBase;
import java.util.Random;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SymbolStarsTwinkle
extends SymbolBase {
    public SymbolStarsTwinkle(String identifier) {
        super(identifier);
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        Number period = controller.popModifier("wavelength").asNumber();
        Number angle = controller.popModifier("angle").asNumber();
        ColorGradient gradient = ModifierUtils.popGradient(controller, 1.0f, 1.0f, 1.0f);
        controller.registerInterface(new SkyBackground(controller, seed, period, angle, gradient));
    }

    private class SkyBackground
    extends CelestialBase {
        private static final int layerscount = 10;
        private Random rand;
        private int[] starGLCallList;
        private long[] offsets;
        private boolean initialized;
        private long period;
        private float angle;
        private float offset = 0.0f;
        private ColorGradient gradient;
        private AgeDirector controller;

        SkyBackground(AgeDirector controller, long seed, Number period, Number angle, ColorGradient gradient) {
            this.controller = controller;
            this.rand = new Random(seed);
            if (period == null) {
                period = 1.8 * this.rand.nextDouble() + 0.2;
            }
            this.period = (long)(period.doubleValue() * 240000.0);
            if (angle == null) {
                angle = this.rand.nextDouble() * 360.0;
            }
            this.angle = -angle.floatValue();
            this.gradient = gradient;
        }

        @Override
        public void render(TextureManager texturemanager, World world, float partial) {
            if (!this.initialized) {
                this.initialize();
            }
            float invertRain = 1.0f - world.func_72867_j(partial);
            GlStateManager.func_179090_x();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)this.angle, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(this.getCelestialPeriod(world.func_72820_D(), partial) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            float starbrightness = world.func_72880_h(partial) * invertRain;
            if (starbrightness > 0.0f) {
                Color color = this.gradient.getColor((float)this.controller.getTime() / 12000.0f);
                for (int i = 0; i < this.starGLCallList.length; ++i) {
                    GlStateManager.func_179131_c((float)color.r, (float)color.g, (float)color.b, (float)(starbrightness * this.getLayerBrightness(i, world, partial)));
                    GlStateManager.func_179148_o((int)this.starGLCallList[i]);
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }

        private float getLayerBrightness(int i, World worldObj, float partial) {
            long time = worldObj.func_72820_D() + this.offsets[i];
            float f1 = ((float)(time %= 100L) + partial) / 100.0f;
            float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            return f2;
        }

        public float getCelestialPeriod(long time, float partialTime) {
            if (this.period == 0L) {
                return this.offset;
            }
            int i = (int)(time % this.period);
            float f = ((float)i + partialTime) / (float)this.period + this.offset;
            if (f < 0.0f) {
                f += 1.0f;
            }
            if (f > 1.0f) {
                f -= 1.0f;
            }
            float f1 = f;
            f = 1.0f - (float)((Math.cos((double)f * Math.PI) + 1.0) / 2.0);
            f = f1 + (f - f1) / 3.0f;
            return f;
        }

        @SideOnly(value=Side.CLIENT)
        private void initialize() {
            int i;
            this.initialized = true;
            this.starGLCallList = new int[10];
            this.offsets = new long[this.starGLCallList.length];
            for (i = 0; i < this.offsets.length; ++i) {
                this.offsets[i] = this.rand.nextLong();
            }
            this.starGLCallList[0] = GLAllocation.func_74526_a((int)this.starGLCallList.length);
            for (i = 0; i < this.starGLCallList.length; ++i) {
                this.starGLCallList[i] = this.starGLCallList[0] + i;
                GlStateManager.func_179094_E();
                GlStateManager.func_187423_f((int)this.starGLCallList[i], (int)4864);
                this.renderStars();
                GlStateManager.func_187415_K();
                GlStateManager.func_179121_F();
            }
        }

        private void renderStars() {
            Tessellator tes = Tessellator.func_178181_a();
            VertexBuffer vb = tes.func_178180_c();
            vb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            for (int i = 0; i < 100; ++i) {
                double var4 = this.rand.nextFloat() * 2.0f - 1.0f;
                double var6 = this.rand.nextFloat() * 2.0f - 1.0f;
                double var8 = this.rand.nextFloat() * 2.0f - 1.0f;
                double var10 = 0.15f + this.rand.nextFloat() * 0.1f;
                double var12 = var4 * var4 + var6 * var6 + var8 * var8;
                if (!(var12 < 1.0) || !(var12 > 0.01)) continue;
                var12 = 1.0 / Math.sqrt(var12);
                double var14 = (var4 *= var12) * 100.0;
                double var16 = (var6 *= var12) * 100.0;
                double var18 = (var8 *= var12) * 100.0;
                double var20 = Math.atan2(var4, var8);
                double var22 = Math.sin(var20);
                double var24 = Math.cos(var20);
                double var26 = Math.atan2(Math.sqrt(var4 * var4 + var8 * var8), var6);
                double var28 = Math.sin(var26);
                double var30 = Math.cos(var26);
                double var32 = this.rand.nextDouble() * Math.PI * 2.0;
                double var34 = Math.sin(var32);
                double var36 = Math.cos(var32);
                java.awt.Color c = this.getRandomColor();
                for (int var38 = 0; var38 < 4; ++var38) {
                    double var39 = 0.0;
                    double var41 = (double)((var38 & 2) - 1) * var10;
                    double var43 = (double)((var38 + 1 & 2) - 1) * var10;
                    double var47 = var41 * var36 - var43 * var34;
                    double var49 = var43 * var36 + var41 * var34;
                    double var53 = var47 * var28 + var39 * var30;
                    double var55 = var39 * var28 - var47 * var30;
                    double var57 = var55 * var22 - var49 * var24;
                    double var61 = var49 * var22 + var55 * var24;
                    vb.func_181662_b(var14 + var57, var16 + var53, var18 + var61).func_181669_b(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha()).func_181675_d();
                }
            }
            tes.func_78381_a();
        }

        private java.awt.Color getRandomColor() {
            return new java.awt.Color(this.rand.nextFloat(), this.rand.nextFloat(), this.rand.nextFloat(), this.rand.nextFloat() * 0.8f + 0.2f);
        }
    }
}

