/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.ITerrainAlteration;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import java.util.Random;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorOctaves;

public class SymbolSkylands
extends SymbolBase {
    public SymbolSkylands(String identifier) {
        super(identifier);
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        NoiseGeneratorOctaves noise = new NoiseGeneratorOctaves(new Random(controller.getSeed()), 7);
        controller.registerInterface(new TerrainAlteration(noise));
        controller.setCloudHeight(42.5f);
        controller.setHorizon(0.0);
    }

    private static class TerrainAlteration
    implements ITerrainAlteration {
        private static final double factor = 0.03125;
        private double[] skyNoise = null;
        private NoiseGeneratorOctaves noiseGen;

        public TerrainAlteration(NoiseGeneratorOctaves noise) {
            this.noiseGen = noise;
        }

        @Override
        public void alterTerrain(World worldObj, int chunkX, int chunkZ, ChunkPrimer primer) {
            this.skyNoise = this.noiseGen.func_76305_a(this.skyNoise, chunkX * 16, chunkZ * 16, 16, 16, 1.0, 1.0, 1.0);
            int layers = 256;
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    int height = this.calcSkyCutoff(x, z, this.skyNoise);
                    for (int y = 0; y < layers; ++y) {
                        if (y <= height) {
                            primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        IBlockState blockstate = primer.func_177856_a(x, y, z);
                        if (blockstate.func_185904_a().func_76224_d()) {
                            primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        if (!(blockstate.func_177230_c() instanceof BlockFalling) || this.isSupported(x, y, z, height, primer)) continue;
                        primer.func_177855_a(x, y, z, Blocks.field_150348_b.func_176223_P());
                    }
                }
            }
        }

        private int calcSkyCutoff(int x, int z, double[] skyNoise) {
            return 76 + (int)skyNoise[x << 4 | z];
        }

        private boolean isSupported(int x, int y, int z, int sky, ChunkPrimer primer) {
            if (y < 1) {
                return false;
            }
            if (y - 1 <= sky) {
                return false;
            }
            IBlockState block = primer.func_177856_a(x, y - 1, z);
            if (block.func_177230_c() == Blocks.field_150347_e) {
                return false;
            }
            if (block.func_177230_c() == Blocks.field_150350_a) {
                return false;
            }
            if (block.func_185904_a().func_76224_d()) {
                return false;
            }
            return block.func_185904_a().func_76220_a();
        }
    }
}

