/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.IPopulate;
import com.xcompwiz.mystcraft.api.world.logic.ITerrainAlteration;
import com.xcompwiz.mystcraft.api.world.logic.ITerrainFeatureLocator;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.structure.MapGenNetherBridge;

public class SymbolNetherFort
extends SymbolBase {
    public SymbolNetherFort(String identifier) {
        super(identifier);
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        MapGenNetherBridge generator = new MapGenNetherBridge();
        controller.registerInterface(new TerrainAlteration(generator));
        controller.registerInterface(new Populator(generator));
        controller.registerInterface(new FeatureLocator(generator));
    }

    @Override
    public int instabilityModifier(int count) {
        if (count > 3) {
            return 100;
        }
        return 0;
    }

    private class FeatureLocator
    implements ITerrainFeatureLocator {
        private MapGenNetherBridge generator;

        public FeatureLocator(MapGenNetherBridge gen) {
            this.generator = gen;
        }

        @Override
        public BlockPos locate(World world, String s, BlockPos pos, boolean genChunks) {
            if ("Nether Fortress".equals(s) && this.generator != null) {
                return this.generator.func_180706_b(world, pos, genChunks);
            }
            return null;
        }
    }

    private class TerrainAlteration
    implements ITerrainAlteration {
        private MapGenNetherBridge generator;

        public TerrainAlteration(MapGenNetherBridge gen) {
            this.generator = gen;
        }

        @Override
        public void alterTerrain(World worldObj, int chunkX, int chunkZ, ChunkPrimer primer) {
            this.generator.func_186125_a(worldObj, chunkX, chunkZ, primer);
        }
    }

    private class Populator
    implements IPopulate {
        private MapGenNetherBridge generator;

        public Populator(MapGenNetherBridge gen) {
            this.generator = gen;
        }

        @Override
        public boolean populate(World worldObj, Random rand, int i, int j, boolean flag) {
            this.generator.func_175794_a(worldObj, rand, new ChunkPos(i >> 4, j >> 4));
            return false;
        }
    }
}

