/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.network;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.linking.DimensionUtils;
import com.xcompwiz.mystcraft.network.MystcraftPacketHandler;
import com.xcompwiz.mystcraft.network.NetworkUtils;
import com.xcompwiz.mystcraft.network.packet.MPacketConfigs;
import com.xcompwiz.mystcraft.network.packet.MPacketDimensions;
import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.storage.SaveDataMemoryStorage;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MystcraftConnectionHandler {
    private static boolean connected = false;

    @SubscribeEvent
    public void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.player.func_70005_c_().equals("XCompWiz")) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        UUID checkUUID = DimensionUtils.getPlayerDimensionUUID(player);
        if (checkUUID == null && Mystcraft.requireUUID || DimensionUtils.isDimensionDead(player.field_70170_p.field_73011_w.getDimension()) || checkUUID != null && !DimensionUtils.checkDimensionUUID(player.field_70170_p.field_73011_w.getDimension(), checkUUID)) {
            DimensionUtils.ejectPlayerFromDimension(event.player);
        }
        if (player.field_70170_p.field_73011_w instanceof WorldProviderMyst) {
            NetworkUtils.sendAgeData(player, player.field_71093_bK);
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        EntityPlayer player = event.player;
        if (DimensionUtils.isDimensionDead(event.toDim)) {
            DimensionUtils.ejectPlayerFromDimension(event.player);
            return;
        }
        DimensionUtils.setPlayerDimensionUUID(event.player, DimensionUtils.getDimensionUUID(event.toDim));
        if (Mystcraft.registeredDims.contains(event.toDim)) {
            NetworkUtils.sendAgeData(player, event.toDim);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void connectionOpened(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        connected = true;
        Mystcraft.clientStorage = new SaveDataMemoryStorage();
    }

    @SubscribeEvent
    public void onPlJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            MystcraftPacketHandler.CHANNEL.sendTo((IMessage)new MPacketDimensions(Mystcraft.registeredDims), (EntityPlayerMP)event.player);
            MystcraftPacketHandler.CHANNEL.sendTo((IMessage)MPacketConfigs.createPacket(), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void connectionClosed(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        if (connected) {
            connected = false;
            Mystcraft.clientStorage = null;
            Mystcraft.serverLabels = Mystcraft.renderlabels;
            MinecraftServer mcServer = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (mcServer == null || mcServer.func_71241_aa()) {
                Mystcraft.unregisterDimensions();
            }
        }
    }
}

